/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.rest.handle;

import com.huawei.ism.tool.file.SecurityUtils;
import com.huawei.ism.tool.service.rest.excep.ForbiddenException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class SmartKitSceneInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SmartKitSceneInterceptor.class);
    private static String scene = "";
    private boolean isFirstCertification = true;
    private boolean isSceneActive;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!this.isSceneActive) {
            return true;
        }
        log.info("uri:{}, type: {}", (Object)request.getRequestURI(), (Object)request.getMethod());
        if ("OPTIONS".equals(request.getMethod())) {
            return true;
        }
        if (StringUtils.contains((CharSequence)request.getHeader("Authorization"), (CharSequence)scene)) {
            if (this.isFirstCertification) {
                this.isFirstCertification = false;
                SmartKitSceneInterceptor.setScene(SecurityUtils.generateAuthorizationKey());
            }
            response.setHeader("Authorization", scene);
            return true;
        }
        response.setStatus(HttpStatus.UNAUTHORIZED.value());
        throw new ForbiddenException("please visit by smartkit");
    }

    @Value(value="${scene.active:false}")
    public void setSceneActive(String sceneActive) {
        this.isSceneActive = Boolean.parseBoolean(sceneActive);
    }

    public static void setScene(String scene) {
        SmartKitSceneInterceptor.scene = scene;
    }
}

