/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.rest.model.entity;

import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.service.rest.model.entity.AuthClusterNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class BusinessDevice {
    protected DevNode devNode;
    protected List<AuthClusterNode> authClusterNodes = new ArrayList<AuthClusterNode>();

    public BusinessDevice(DevNode devNode) {
        this.devNode = devNode;
        if (null != devNode.getClusterNodes()) {
            this.authClusterNodes = devNode.getClusterNodes().stream().map(AuthClusterNode::new).collect(Collectors.toList());
        }
    }

    public Optional<AuthClusterNode> findTargetClusterNodeByIp(String ip) {
        return this.authClusterNodes.stream().filter(node -> ip.equals(node.getNode().getManagementIp())).findFirst();
    }

    public DevNode getDevNode() {
        return this.devNode;
    }

    public List<AuthClusterNode> getAuthClusterNodes() {
        return this.authClusterNodes;
    }

    public void setDevNode(DevNode devNode) {
        this.devNode = devNode;
    }

    public void setAuthClusterNodes(List<AuthClusterNode> authClusterNodes) {
        this.authClusterNodes = authClusterNodes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessDevice)) {
            return false;
        }
        BusinessDevice other = (BusinessDevice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DevNode this$devNode = this.getDevNode();
        DevNode other$devNode = other.getDevNode();
        if (this$devNode == null ? other$devNode != null : !((Object)this$devNode).equals(other$devNode)) {
            return false;
        }
        List<AuthClusterNode> this$authClusterNodes = this.getAuthClusterNodes();
        List<AuthClusterNode> other$authClusterNodes = other.getAuthClusterNodes();
        return !(this$authClusterNodes == null ? other$authClusterNodes != null : !((Object)this$authClusterNodes).equals(other$authClusterNodes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BusinessDevice;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DevNode $devNode = this.getDevNode();
        result = result * 59 + ($devNode == null ? 43 : ((Object)$devNode).hashCode());
        List<AuthClusterNode> $authClusterNodes = this.getAuthClusterNodes();
        result = result * 59 + ($authClusterNodes == null ? 43 : ((Object)$authClusterNodes).hashCode());
        return result;
    }

    public String toString() {
        return "BusinessDevice(devNode=" + this.getDevNode() + ", authClusterNodes=" + this.getAuthClusterNodes() + ")";
    }

    public BusinessDevice() {
    }
}

