/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.rest.model.entity.vo;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevNodeVO
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(DevNodeVO.class);
    private static final long serialVersionUID = -5278109688491301623L;
    private String name;
    private String sn;
    private String ip;
    private String productModel;
    private String productVersion;
    private String status;
    private ItDeviceType deviceType;
    private String fingerprint;

    public DevNodeVO(DevNode node) {
        this(node, null);
    }

    public DevNodeVO(DevNode node, String fingerprint) {
        this.name = node.getDeviceName();
        this.ip = node.getIp();
        this.initProductModel(node);
        this.productVersion = node.getProductVersion();
        this.sn = node.getDeviceSerialNumber();
        this.fingerprint = fingerprint;
        this.deviceType = node.getItDeviceType();
    }

    private void initProductModel(DevNode node) {
        if (null == node.getDeviceType()) {
            log.warn("node {} type is null", (Object)StringUtils.getCleanMessage((String)node.getIp()));
            this.productModel = "";
            return;
        }
        this.productModel = node.getDeviceType().toString();
    }

    public DevNodeVO(com.huawei.ism.tool.framework.pubservice.entity.DevNode node) {
        this(EntityUtils.toOldDev(node));
    }

    public String getName() {
        return this.name;
    }

    public String getSn() {
        return this.sn;
    }

    public String getIp() {
        return this.ip;
    }

    public String getProductModel() {
        return this.productModel;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getStatus() {
        return this.status;
    }

    public ItDeviceType getDeviceType() {
        return this.deviceType;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setProductModel(String productModel) {
        this.productModel = productModel;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setDeviceType(ItDeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DevNodeVO)) {
            return false;
        }
        DevNodeVO other = (DevNodeVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$sn = this.getSn();
        String other$sn = other.getSn();
        if (this$sn == null ? other$sn != null : !this$sn.equals(other$sn)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$productModel = this.getProductModel();
        String other$productModel = other.getProductModel();
        if (this$productModel == null ? other$productModel != null : !this$productModel.equals(other$productModel)) {
            return false;
        }
        String this$productVersion = this.getProductVersion();
        String other$productVersion = other.getProductVersion();
        if (this$productVersion == null ? other$productVersion != null : !this$productVersion.equals(other$productVersion)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        ItDeviceType this$deviceType = this.getDeviceType();
        ItDeviceType other$deviceType = other.getDeviceType();
        if (this$deviceType == null ? other$deviceType != null : !this$deviceType.equals(other$deviceType)) {
            return false;
        }
        String this$fingerprint = this.getFingerprint();
        String other$fingerprint = other.getFingerprint();
        return !(this$fingerprint == null ? other$fingerprint != null : !this$fingerprint.equals(other$fingerprint));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DevNodeVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $sn = this.getSn();
        result = result * 59 + ($sn == null ? 43 : $sn.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $productModel = this.getProductModel();
        result = result * 59 + ($productModel == null ? 43 : $productModel.hashCode());
        String $productVersion = this.getProductVersion();
        result = result * 59 + ($productVersion == null ? 43 : $productVersion.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        ItDeviceType $deviceType = this.getDeviceType();
        result = result * 59 + ($deviceType == null ? 43 : $deviceType.hashCode());
        String $fingerprint = this.getFingerprint();
        result = result * 59 + ($fingerprint == null ? 43 : $fingerprint.hashCode());
        return result;
    }

    public String toString() {
        return "DevNodeVO(name=" + this.getName() + ", sn=" + this.getSn() + ", ip=" + this.getIp() + ", productModel=" + this.getProductModel() + ", productVersion=" + this.getProductVersion() + ", status=" + this.getStatus() + ", deviceType=" + this.getDeviceType() + ", fingerprint=" + this.getFingerprint() + ")";
    }

    public DevNodeVO() {
    }
}

