/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.task.state.based.construct;

import com.huawei.ism.tool.service.task.state.based.Action;
import com.huawei.ism.tool.service.task.state.based.Condition;
import com.huawei.ism.tool.service.task.state.based.DefaultExecuteContext;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

class BuilderHelper {
    static <S extends Enum<S>, E extends Enum<E>> Action<S, E> composeWithErrorAction(Action<S, E> action, Action<S, E> error) {
        return context -> {
            try {
                return action.execute(context);
            }
            catch (Exception exception) {
                try {
                    return error.execute(new DefaultExecuteContext(context.sourceState(), context.targetState(), context.event(), context.extraData(), context.executor(), exception));
                }
                catch (Exception ignored) {
                    return Optional.empty();
                }
            }
        };
    }

    static <S extends Enum<S>, E extends Enum<E>> Condition<S, E> composeErrTransitCondition(int errTransitionId, @Nullable Condition<S, E> condition) {
        return context -> errTransitionId == context.getOpt("__ERR_TRANSITION_ID_KEY__").orElse(-1) && (condition == null || condition.matches(context));
    }

    private BuilderHelper() {
    }
}

