/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.number;

import java.text.Format;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.python.icu.impl.StandardPlural;
import org.python.icu.impl.Utility;
import org.python.icu.impl.number.DecimalQuantity;
import org.python.icu.impl.number.DecimalQuantity_DualStorageBCD;
import org.python.icu.impl.number.LocalizedNumberFormatterAsFormat;
import org.python.icu.impl.number.MacroProps;
import org.python.icu.impl.number.NumberStringBuilder;
import org.python.icu.number.FormattedNumber;
import org.python.icu.number.NumberFormatterImpl;
import org.python.icu.number.NumberFormatterSettings;
import org.python.icu.util.Measure;
import org.python.icu.util.MeasureUnit;

public class LocalizedNumberFormatter
extends NumberFormatterSettings<LocalizedNumberFormatter> {
    static final AtomicLongFieldUpdater<LocalizedNumberFormatter> callCount = AtomicLongFieldUpdater.newUpdater(LocalizedNumberFormatter.class, "callCountInternal");
    volatile long callCountInternal;
    volatile LocalizedNumberFormatter savedWithUnit;
    volatile NumberFormatterImpl compiled;

    LocalizedNumberFormatter(NumberFormatterSettings<?> parent, int key, Object value) {
        super(parent, key, value);
    }

    public FormattedNumber format(long input) {
        return this.format(new DecimalQuantity_DualStorageBCD(input));
    }

    public FormattedNumber format(double input) {
        return this.format(new DecimalQuantity_DualStorageBCD(input));
    }

    public FormattedNumber format(Number input) {
        return this.format(new DecimalQuantity_DualStorageBCD(input));
    }

    public FormattedNumber format(Measure input) {
        MeasureUnit unit = input.getUnit();
        Number number = input.getNumber();
        if (Utility.equals(this.resolve().unit, unit)) {
            return this.format(number);
        }
        LocalizedNumberFormatter withUnit = this.savedWithUnit;
        if (withUnit == null || !Utility.equals(withUnit.resolve().unit, unit)) {
            this.savedWithUnit = withUnit = new LocalizedNumberFormatter(this, 3, unit);
        }
        return withUnit.format(number);
    }

    public Format toFormat() {
        return new LocalizedNumberFormatterAsFormat(this, this.resolve().loc);
    }

    @Deprecated
    public FormattedNumber format(DecimalQuantity fq) {
        NumberStringBuilder string2 = new NumberStringBuilder();
        if (this.computeCompiled()) {
            this.compiled.apply(fq, string2);
        } else {
            NumberFormatterImpl.applyStatic(this.resolve(), fq, string2);
        }
        return new FormattedNumber(string2, fq);
    }

    @Deprecated
    public String getAffixImpl(boolean isPrefix, boolean isNegative) {
        NumberStringBuilder string2 = new NumberStringBuilder();
        byte signum = (byte)(isNegative ? -1 : 1);
        StandardPlural plural = StandardPlural.OTHER;
        int prefixLength = this.computeCompiled() ? this.compiled.getPrefixSuffix(signum, plural, string2) : NumberFormatterImpl.getPrefixSuffixStatic(this.resolve(), signum, plural, string2);
        if (isPrefix) {
            return string2.subSequence(0, prefixLength).toString();
        }
        return string2.subSequence(prefixLength, string2.length()).toString();
    }

    private boolean computeCompiled() {
        MacroProps macros = this.resolve();
        long currentCount = callCount.incrementAndGet(this);
        if (currentCount == macros.threshold) {
            this.compiled = NumberFormatterImpl.fromMacros(macros);
            return true;
        }
        return this.compiled != null;
    }

    @Override
    LocalizedNumberFormatter create(int key, Object value) {
        return new LocalizedNumberFormatter(this, key, value);
    }
}

