/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.ui.LookAndFeelInstaller;
import com.huawei.ism.tool.distributed.fru.common.Constants;
import com.huawei.ism.tool.distributed.fru.common.Context;
import com.huawei.ism.tool.distributed.fru.service.parser.ProductInitiator;
import com.huawei.ism.tool.distributed.fru.util.DocUtil;
import com.huawei.ism.tool.file.SecurityUtils;
import com.huawei.ism.tool.framework.platform.common.tool.AbstractTool;
import com.huawei.ism.tool.framework.platform.common.tool.ToolStartItem;
import com.huawei.ism.tool.framework.platform.common.tool.ToolType;
import com.huawei.ism.tool.framework.platform.common.ui.IStartAction;
import com.huawei.ism.tool.framework.platform.context.AbstractContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.rest.handle.SmartKitSceneInterceptor;
import com.huawei.ism.tool.service.rest.util.CertsUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.plaf.flat.FlatLookAndFeel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Paths;
import javax.swing.Icon;
import javax.swing.LookAndFeel;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;

@SpringBootApplication(scanBasePackages={"com.huawei.ism.tool.distributed.fru", "com.huawei.ism.tool.service.rest"})
public class FruToolStarter
extends AbstractTool
implements IStartAction {
    private static final Logger log = LoggerFactory.getLogger(FruToolStarter.class);

    public ToolType getType() {
        return ToolType.maintenance;
    }

    public ToolStartItem getStartItem() {
        String funcName = ResourceUtil.getString((String)"tool.funcItem.name");
        String funcDesc = ResourceUtil.getString((String)"tool.funcItem.desc");
        return new ToolStartItem(funcName, funcDesc, (Icon)Constants.TOOL_ICON, (IStartAction)this);
    }

    protected AbstractContext getContext() {
        return Context.INS;
    }

    private String startBrowser() {
        String scene = SecurityUtils.generatePassword((int)36);
        SmartKitSceneInterceptor.setScene((String)scene);
        try {
            String[] cmdArray = new String[]{Constants.WORK_PATH + File.separator + "electron\\ftd-browser.exe", "common"};
            String[] envs = new String[]{"scene=\"" + scene + "\""};
            Process exec = Runtime.getRuntime().exec(cmdArray, envs);
            log.info("stand out:{}", (Object)IOUtils.readLines((InputStream)exec.getInputStream(), (String)"gbk"));
            log.error("error out:{}", (Object)IOUtils.readLines((InputStream)exec.getErrorStream(), (String)"gbk"));
        }
        catch (Exception e) {
            log.info("Error exec!", (Throwable)e);
        }
        return "";
    }

    public void actionPerformed(Window parent, ActionEvent event) {
        LookAndFeelInstaller.installToolCustomUI((LookAndFeel)new FlatLookAndFeel());
        this.initBusiness();
        CertsUtil.generateDefaultSelfSignedCerts();
        SpringApplication.run(FruToolStarter.class, (String[])new String[0]);
        AsyncExcutor.submit(this::startBrowser);
    }

    private void initBusiness() {
        try {
            ProductInitiator initiator = new ProductInitiator();
            Context.INS.setSupportProducts(initiator.init(new File(Constants.PACKAGE_ROOT_DIR)));
            File docRouteFile = Paths.get(Constants.PACKAGE_ROOT_DIR, "doc", "docRoute.xml").toFile();
            DocUtil.INS.parseAndSaveDocRoute(docRouteFile);
            File fusionCubeDocRouteFile = Paths.get(Constants.PACKAGE_ROOT_DIR, "doc", "fusioncubeDocRoute.xml").toFile();
            DocUtil.INS.parseAndSaveFusionCubeDocRoute(fusionCubeDocRouteFile);
        }
        catch (Exception e) {
            log.error("Init product error.", (Throwable)e);
            DialogUtils.showErrorDialog(null, (String)ResourceUtil.getString((String)"product.parse.error"));
            Context.INS.fireToolStopped();
        }
    }
}

