/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.common;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.distributed.fru.model.entity.FruDevice;
import com.huawei.ism.tool.distributed.fru.model.entity.Product;
import com.huawei.ism.tool.distributed.fru.model.entity.doc.ItemDocConf;
import com.huawei.ism.tool.distributed.fru.model.entity.doc.ModuleDocConf;
import com.huawei.ism.tool.framework.platform.context.AbstractContext;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context
extends AbstractContext {
    private static final Logger log = LoggerFactory.getLogger(Context.class);
    public static final Context INS = new Context();
    private List<Product> supportProducts = new ArrayList<Product>();
    private Map<String, ModuleDocConf> moduleDocConf = new HashMap<String, ModuleDocConf>();
    private Map<String, ModuleDocConf> fusionCubeModuleDocConf = new HashMap<String, ModuleDocConf>();
    private Map<String, ItemDocConf> itemDocConf = new HashMap<String, ItemDocConf>();
    private Map<String, ItemDocConf> fusionCubeItemDocConf = new HashMap<String, ItemDocConf>();
    private final Map<String, FruDevice> sn2FruDevMap = new ConcurrentHashMap<String, FruDevice>();

    private Context() {
    }

    public void shutdown() {
        Executors.newSingleThreadScheduledExecutor().schedule(() -> ((Context)this).fireToolStopped(), 1L, TimeUnit.SECONDS);
    }

    public void callBackSceneInfo() {
        if (!SceneUtils.isScene()) {
            return;
        }
        try {
            ArrayList resultList = new ArrayList();
            this.sn2FruDevMap.keySet().forEach(sn -> {
                DevNode dev = this.sn2FruDevMap.get(sn).getBusinessDevice().getDevNode();
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("IP", dev.getIp());
                data.put("SN", dev.getDeviceSerialNumber());
                data.put("status", TaskResult.Result.SUCCESS.toString());
                data.put("toolId", "DistributedFRU");
                resultList.add(data);
            });
            TaskResult result = SceneEnvironmentImpl.getInstance().finishedSceneTask(resultList);
            log.info("Call back scene info result {}.", (Object)result.isTaskSuccess());
        }
        catch (ToolException e) {
            log.error("Call back scene info failed.", (Throwable)e);
        }
    }

    public List<Product> getSupportProducts() {
        return this.supportProducts;
    }

    public Map<String, ModuleDocConf> getModuleDocConf() {
        return this.moduleDocConf;
    }

    public Map<String, ModuleDocConf> getFusionCubeModuleDocConf() {
        return this.fusionCubeModuleDocConf;
    }

    public Map<String, ItemDocConf> getItemDocConf() {
        return this.itemDocConf;
    }

    public Map<String, ItemDocConf> getFusionCubeItemDocConf() {
        return this.fusionCubeItemDocConf;
    }

    public Map<String, FruDevice> getSn2FruDevMap() {
        return this.sn2FruDevMap;
    }

    public void setSupportProducts(List<Product> supportProducts) {
        this.supportProducts = supportProducts;
    }

    public void setModuleDocConf(Map<String, ModuleDocConf> moduleDocConf) {
        this.moduleDocConf = moduleDocConf;
    }

    public void setFusionCubeModuleDocConf(Map<String, ModuleDocConf> fusionCubeModuleDocConf) {
        this.fusionCubeModuleDocConf = fusionCubeModuleDocConf;
    }

    public void setItemDocConf(Map<String, ItemDocConf> itemDocConf) {
        this.itemDocConf = itemDocConf;
    }

    public void setFusionCubeItemDocConf(Map<String, ItemDocConf> fusionCubeItemDocConf) {
        this.fusionCubeItemDocConf = fusionCubeItemDocConf;
    }
}

