/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.controller;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.service.INodeObserver;
import com.huawei.ism.tool.distributed.fru.common.Context;
import com.huawei.ism.tool.distributed.fru.model.entity.FruDevice;
import com.huawei.ism.tool.distributed.fru.model.entity.vo.ModuleDataInfoVO;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.board.arcard.ArCardAuthService;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.board.arcard.ArCardConfigBackUp;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.board.arcard.ArCardTaskService;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.entity.BackUpDirRequestTo;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.entity.board.ArCardAuthRequestTo;
import com.huawei.ism.tool.distributed.fru.util.DeviceUtil;
import com.huawei.ism.tool.distributed.fru.util.FusionCubeNodeTypeSupportUtil;
import com.huawei.ism.tool.distributed.fru.util.NodeTypeSupportUtil;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.service.rest.common.Constants;
import com.huawei.ism.tool.service.rest.controller.BaseDeviceController;
import com.huawei.ism.tool.service.rest.model.entity.AuthClusterNode;
import com.huawei.ism.tool.service.rest.model.entity.Response;
import com.huawei.ism.tool.service.rest.util.BusinessDeviceUtil;
import com.huawei.uMate.common.SystemConfig;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/device"})
public class FruDeviceController
extends BaseDeviceController {
    private static final Logger log = LoggerFactory.getLogger(FruDeviceController.class);
    private static final int MAX_PATH_LENGTH = 128;

    FruDeviceController(INodeSupport support, INodeObserver nodeObserver) {
        super(support, nodeObserver);
    }

    @GetMapping(value={"/support/unit/{sn}"})
    public Response<?> querySupportModule(@PathVariable(value="sn") String deviceSn) {
        Optional<FruDevice> fruDevice = DeviceUtil.INS.findFruDev(deviceSn);
        if (!fruDevice.isPresent()) {
            return Response.fail((String)Constants.Device.NODE_NOT_EXIST);
        }
        return Response.success(fruDevice.get().getProduct().getSupportModules());
    }

    @PostMapping(value={"/unit/statistics"})
    public Response<?> queryModuleDataStatistics(@RequestBody ModuleDataInfoVO.CountReq info) {
        Optional<FruDevice> fruDeviceOpt = DeviceUtil.INS.findFruDev(info.getDeviceSn());
        if (!fruDeviceOpt.isPresent()) {
            return Response.fail((String)Constants.Device.NODE_NOT_EXIST);
        }
        FruDevice fruDevice = fruDeviceOpt.get();
        return Response.success(DeviceUtil.INS.countStatisticsInfo(info, fruDevice));
    }

    @PostMapping(value={"/unit"})
    public Response<?> queryModuleData(@RequestBody ModuleDataInfoVO.DetailReq info) {
        Optional<FruDevice> fruDeviceOpt = DeviceUtil.INS.findFruDev(info.getDeviceSn());
        if (!fruDeviceOpt.isPresent()) {
            return Response.fail((String)Constants.Device.NODE_NOT_EXIST);
        }
        return Response.success((Object)ModuleDataInfoVO.DetailRet.builder().moduleData(DeviceUtil.INS.findTargetNodesModuleData(fruDeviceOpt.get(), info.getModuleId(), info.getNodeIds())).build());
    }

    @PostMapping(value={"/fault/nodes"})
    public Response<?> queryFaultNodeIds(@RequestBody ModuleDataInfoVO.DetailReq info) {
        Optional<FruDevice> fruDeviceOpt = DeviceUtil.INS.findFruDev(info.getDeviceSn());
        if (!fruDeviceOpt.isPresent()) {
            return Response.fail((String)Constants.Device.NODE_NOT_EXIST);
        }
        return Response.success(DeviceUtil.INS.findNodeIdsWhichHasFaultModule(fruDeviceOpt.get()));
    }

    @GetMapping(value={"/isSupport/{clusterSn}/{nodeManageIp}"})
    public Response<?> isServerTypeSupport(@PathVariable(value="clusterSn") String clusterSn, @PathVariable(value="nodeManageIp") String nodeManageIp) {
        FruDevice fruDevice = Context.INS.getSn2FruDevMap().get(clusterSn);
        if (Objects.isNull(fruDevice)) {
            return Response.fail((String)Constants.Device.NODE_NOT_EXIST);
        }
        try {
            return Response.success((Object)this.isSupportType(fruDevice, nodeManageIp));
        }
        catch (ToolException e) {
            return Response.fail((String)e.getErrorLocaleDescription());
        }
    }

    private boolean isSupportType(FruDevice fruDevice, String nodeManageIp) throws ToolException {
        Optional<AuthClusterNode> authClusterNodeOpt = fruDevice.getBusinessDevice().getAuthClusterNodes().stream().filter(e -> nodeManageIp.equals(e.getNode().getManagementIp()) && e.getBmcAuthStatusInfo().isAuthSuccess()).findFirst();
        if (!authClusterNodeOpt.isPresent()) {
            log.warn("bmc is not auth complete, but user confirm in UI, check supportType pass.");
            return true;
        }
        try {
            if (fruDevice.getDevNode().isFusionCube()) {
                return FusionCubeNodeTypeSupportUtil.getInstance().isSupport(fruDevice.getDevNode(), authClusterNodeOpt.get().getNode().getManagementIp());
            }
            return NodeTypeSupportUtil.INS.isSupport(BusinessDeviceUtil.INS.buildBmcNode(authClusterNodeOpt.get()));
        }
        catch (ToolException e2) {
            if ("devicemanager.layout.device.rest.connection.fusioncube.password.is.wrong".equals(e2.getErrorId())) {
                throw e2;
            }
            throw new ToolException("device.cluster.auth.failed", new Object[]{nodeManageIp});
        }
    }

    @PutMapping(value={"/arAuth"})
    public Response<String> authOsInfo(@RequestBody ArCardAuthRequestTo request) {
        Optional<FruDevice> fruDeviceOpt = DeviceUtil.INS.findFruDev(request.getDeviceSn());
        if (!fruDeviceOpt.isPresent()) {
            return Response.fail((String)Constants.Device.NODE_NOT_EXIST);
        }
        if (ArCardAuthService.INS.batchAuthArCard(request, fruDeviceOpt.get())) {
            return Response.success((Object)"");
        }
        return Response.fail((String)Constants.Device.UN_SUPPORT_MSG);
    }

    @GetMapping(value={"/arCard/backUpDir"})
    public Response<String> getArConfigBackUpPath() {
        return Response.success((Object)ArCardConfigBackUp.getHomeDir());
    }

    @PostMapping(value={"/arCard/backUpDir"})
    public Response<String> getArConfigBackUpPath(@RequestBody BackUpDirRequestTo dir) {
        try {
            ToolFileChooser.checkDirThrowError((int)128, (String)dir.getPath());
        }
        catch (ToolException e) {
            log.error("Target path {} check not pass.Cause : {}", (Object)StringUtils.getCleanMessage((String)dir.getPath()), (Object)e.getErrorLocaleDescription());
            return Response.fail((String)e.getErrorLocaleDescription());
        }
        ArCardConfigBackUp.setHomeDir(dir.getPath());
        return Response.success((Object)"");
    }

    @GetMapping(value={"/arCard/needArAuth/{deviceSn}"})
    public Response<Boolean> needArAuth(@PathVariable(value="deviceSn") String deviceSn) {
        Optional<FruDevice> fruDeviceOpt = DeviceUtil.INS.findFruDev(deviceSn);
        return fruDeviceOpt.map(fruDevice -> Response.success((Object)(!ArCardTaskService.INS.isBackArConfigFromFcv(fruDevice.getDevNode()) ? 1 : 0))).orElseGet(() -> Response.fail((String)Constants.Device.NODE_NOT_EXIST));
    }

    @GetMapping(value={"/sandbox/show/{deviceSn}"})
    public Response<Boolean> getDeviceShowSandboxBtn(@PathVariable(value="deviceSn") String deviceSn) {
        Optional<FruDevice> fruDevice = DeviceUtil.INS.findFruDev(deviceSn);
        if (!fruDevice.isPresent()) {
            return Response.fail((String)Constants.Device.NODE_NOT_EXIST);
        }
        String supportVersions = SystemConfig.createSystemConfig().getConfigVlaue("sandbox_close_support_version");
        if (supportVersions == null || fruDevice.get().getDevNode().isFusionCube()) {
            return Response.success((Object)true);
        }
        String productVersion = fruDevice.get().getDevNode().getProductVersion();
        boolean res = Arrays.stream(supportVersions.split(",")).anyMatch(productVersion::contains);
        return Response.success((Object)res);
    }
}

