/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.controller;

import com.huawei.ism.tool.distributed.fru.common.Constants;
import com.huawei.ism.tool.distributed.fru.model.entity.FruDevice;
import com.huawei.ism.tool.distributed.fru.model.entity.TaskConf;
import com.huawei.ism.tool.distributed.fru.model.entity.vo.FruTaskDetailVO;
import com.huawei.ism.tool.distributed.fru.model.entity.vo.TaskReqInfoVO;
import com.huawei.ism.tool.distributed.fru.model.enumz.TaskType;
import com.huawei.ism.tool.distributed.fru.service.task.ItemTask;
import com.huawei.ism.tool.distributed.fru.service.task.ProcessTask;
import com.huawei.ism.tool.distributed.fru.service.task.TaskFactory;
import com.huawei.ism.tool.distributed.fru.service.task.TaskManager;
import com.huawei.ism.tool.distributed.fru.util.DeviceUtil;
import com.huawei.ism.tool.distributed.fru.util.DocUtil;
import com.huawei.ism.tool.distributed.fru.util.ProductUtil;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.service.rest.model.entity.Response;
import com.huawei.ism.tool.service.sanbox.ISandBoxService;
import com.huawei.ism.tool.service.sanbox.SandBoxService;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class ProcessController {
    private static final Logger log = LoggerFactory.getLogger(ProcessController.class);
    private final TaskManager taskManager;
    private final ISandBoxService sandBoxService = new SandBoxService();

    ProcessController(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    @PostMapping(value={"/process/unit/scan"})
    public Response<?> startModuleDataScan(@RequestBody TaskReqInfoVO info) {
        Optional<FruDevice> fruDevice = DeviceUtil.INS.findFruDev(info.getDeviceSn());
        if (!fruDevice.isPresent()) {
            return Response.fail((String)Constants.Task.TASK_NOT_EXIST);
        }
        List<TaskReqInfoVO> taskInfos = info.getModuleIds().stream().map(moduleId -> TaskReqInfoVO.buildQueryTaskInfoByScanTask(info, moduleId, ((FruDevice)fruDevice.get()).getProduct())).collect(Collectors.toList());
        TaskFactory.INS.createTasks(taskInfos).forEach(task -> this.taskManager.submitQueryTask((ProcessTask)task, info));
        return Response.success((Object)"");
    }

    @PutMapping(value={"/process/step/item"})
    public Response<?> startProcessTask(@RequestBody TaskReqInfoVO info) {
        try {
            this.taskManager.clearQueryTask();
            Optional<FruDevice> fruDevice = DeviceUtil.INS.findFruDev(info.getDeviceSn());
            this.sandBoxService.refreshClusterNodeSandbox(fruDevice.get().getDevNode());
            Optional<ProcessTask> task = TaskFactory.INS.createTask(info);
            if (!task.isPresent()) {
                return Response.fail((String)Constants.Task.TASK_NOT_EXIST);
            }
            this.taskManager.submitFruTask(task.get(), info);
            return Response.success((Object)"");
        }
        catch (ToolException e) {
            return Response.fail((String)e.getErrorLocaleDescription());
        }
    }

    @PostMapping(value={"/process/step/item/ignore"})
    public Response<?> ignoreItemTaskAndContinue(@RequestBody TaskReqInfoVO info) {
        Optional<ItemTask> itemTaskOpt = DeviceUtil.INS.findItemTask(info);
        if (!itemTaskOpt.isPresent()) {
            return Response.fail((String)Constants.Task.TASK_NOT_EXIST);
        }
        itemTaskOpt.get().setIgnoreExecute(true);
        return this.startProcessTask(info);
    }

    @GetMapping(value={"/processes/conf"})
    public Response<?> queryFruTaskProcessInfo(TaskReqInfoVO info) {
        Optional<FruDevice> fruDeviceOpt = DeviceUtil.INS.findFruDev(info.getDeviceSn());
        if (!fruDeviceOpt.isPresent()) {
            return Response.fail((String)Constants.Task.TASK_NOT_EXIST);
        }
        List fruTasksConf = fruDeviceOpt.get().getProduct().getModuleId2TaskInfoList().get(info.getModuleId()).stream().filter(taskConf -> taskConf.getType() != TaskType.QUERY_STEP).map(taskConf -> ProductUtil.INS.updateShowTimeAlarm((TaskConf)taskConf, info)).collect(Collectors.toList());
        return Response.success(fruTasksConf);
    }

    @GetMapping(value={"/process/conf"})
    public Response<?> queryProcessConf(TaskReqInfoVO info) {
        Optional<FruDevice> fruDeviceOpt = DeviceUtil.INS.findFruDev(info.getDeviceSn());
        if (!fruDeviceOpt.isPresent()) {
            return Response.fail((String)Constants.Task.TASK_NOT_EXIST);
        }
        TaskConf processTaskConf = fruDeviceOpt.get().getProduct().getModuleId2TaskInfoList().get(info.getModuleId()).stream().filter(taskConf -> taskConf.getId().equals(info.getProcessId())).findFirst().get();
        return Response.success((Object)FruTaskDetailVO.TaskConfRet.buildTaskConfDetailRet(processTaskConf));
    }

    @GetMapping(value={"/processes/detail"})
    public Response<?> queryProcessTaskInfo(TaskReqInfoVO info) {
        Optional<FruDevice> fruDeviceOpt = DeviceUtil.INS.findFruDev(info.getDeviceSn());
        if (!fruDeviceOpt.isPresent()) {
            return Response.fail((String)Constants.Task.TASK_NOT_EXIST);
        }
        return Response.success((Object)FruTaskDetailVO.buildFruTaskDetailsRet(fruDeviceOpt.get(), info));
    }

    @GetMapping(value={"/process/detail"})
    public Response<?> queryProgressDetailInfo(TaskReqInfoVO info) {
        Optional<ProcessTask> taskOpt = DeviceUtil.INS.findProgressTask(info);
        if (!taskOpt.isPresent()) {
            return Response.fail((String)Constants.Task.TASK_NOT_EXIST);
        }
        return Response.success((Object)new FruTaskDetailVO.ProgressDetailsRet(taskOpt.get()));
    }

    @GetMapping(value={"/process/doc"})
    public Response<?> queryModuleReplaceDoc(TaskReqInfoVO info) {
        return Response.success((Object)DocUtil.INS.matchModuleFruDoc(info));
    }

    @DeleteMapping(value={"/processes"})
    public Response<?> deleteProgressTask(@RequestBody TaskReqInfoVO info) {
        Optional<FruDevice> fruDeviceOpt = DeviceUtil.INS.findFruDev(info.getDeviceSn());
        if (!fruDeviceOpt.isPresent()) {
            return Response.fail((String)Constants.Task.TASK_NOT_EXIST);
        }
        FruDevice fruDevice = fruDeviceOpt.get();
        String taskId = TaskFactory.INS.createFruTaskId(fruDevice, info);
        fruDevice.deleteTask(taskId);
        this.taskManager.deleteTask(taskId);
        return Response.success((Object)"");
    }
}

