/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.model.entity;

import com.huawei.ism.tool.distributed.fru.model.entity.FruClusterNode;
import com.huawei.ism.tool.distributed.fru.util.DeviceUtil;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;

public class AuthDevNode {
    private final ClusterNode clusterNode;
    private final FruClusterNode fruClusterNode;
    private final DevNode bmcNode;
    private final DevNode osNode;

    public AuthDevNode(FruClusterNode fruClusterNode) {
        this.fruClusterNode = fruClusterNode;
        this.clusterNode = fruClusterNode.getNode();
        this.bmcNode = DeviceUtil.INS.buildBmcNode(fruClusterNode);
        this.osNode = DeviceUtil.INS.buildOsNode(fruClusterNode);
    }

    public boolean isBothAuthSuccess() {
        return this.fruClusterNode.getClusterNode().getBmcAuthStatusInfo().isAuthSuccess() && this.fruClusterNode.getClusterNode().getOsAuthStatusInfo().isAuthSuccess();
    }

    public boolean isBmcAuthSuccess() {
        return this.fruClusterNode.getClusterNode().getBmcAuthStatusInfo().isAuthSuccess();
    }

    public boolean isOsAuthSuccess() {
        return this.fruClusterNode.getClusterNode().getOsAuthStatusInfo().isAuthSuccess();
    }

    public Integer getNodeId() {
        return this.fruClusterNode.getNodeId();
    }

    public ClusterNode getClusterNode() {
        return this.clusterNode;
    }

    public DevNode getBmcNode() {
        return this.bmcNode;
    }

    public DevNode getOsNode() {
        return this.osNode;
    }
}

