/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.model.entity;

import com.huawei.ism.tool.distributed.fru.model.entity.FruClusterNode;
import com.huawei.ism.tool.distributed.fru.model.entity.Product;
import com.huawei.ism.tool.distributed.fru.model.module.ModuleData;
import com.huawei.ism.tool.distributed.fru.service.task.ProcessTask;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.service.rest.model.entity.BusinessDevice;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class FruDevice {
    private BusinessDevice businessDevice;
    private List<FruClusterNode> fruClusterNodes;
    private Product product;
    private Map<String, List<ModuleData>> dataMap = new HashMap<String, List<ModuleData>>();
    private Map<String, List<ProcessTask>> taskMap = new ConcurrentHashMap<String, List<ProcessTask>>();

    public FruDevice(BusinessDevice devNode, Product product) {
        this.businessDevice = devNode;
        this.product = product;
        this.fruClusterNodes = this.businessDevice.getAuthClusterNodes().stream().map(FruClusterNode::new).collect(Collectors.toList());
    }

    public Optional<FruClusterNode> findTargetFruClusterNodeByIp(String ip) {
        return this.fruClusterNodes.stream().filter(node -> StringUtils.equals((CharSequence)ip, (CharSequence)node.getNode().getManagementIp())).findFirst();
    }

    public DevNode getDevNode() {
        return this.businessDevice.getDevNode();
    }

    public List<ProcessTask> findTargetTask(String taskId) {
        return this.taskMap.getOrDefault(taskId, Collections.emptyList());
    }

    public boolean containsTask(String taskId) {
        return this.taskMap.containsKey(taskId);
    }

    public void registerTask(String taskId, List<ProcessTask> tasks) {
        this.taskMap.put(taskId, tasks);
    }

    public void deleteTask(String taskId) {
        this.taskMap.remove(taskId);
    }

    public BusinessDevice getBusinessDevice() {
        return this.businessDevice;
    }

    public List<FruClusterNode> getFruClusterNodes() {
        return this.fruClusterNodes;
    }

    public Product getProduct() {
        return this.product;
    }

    public Map<String, List<ModuleData>> getDataMap() {
        return this.dataMap;
    }

    public void setBusinessDevice(BusinessDevice businessDevice) {
        this.businessDevice = businessDevice;
    }

    public void setFruClusterNodes(List<FruClusterNode> fruClusterNodes) {
        this.fruClusterNodes = fruClusterNodes;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public void setDataMap(Map<String, List<ModuleData>> dataMap) {
        this.dataMap = dataMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FruDevice)) {
            return false;
        }
        FruDevice other = (FruDevice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BusinessDevice this$businessDevice = this.getBusinessDevice();
        BusinessDevice other$businessDevice = other.getBusinessDevice();
        if (this$businessDevice == null ? other$businessDevice != null : !this$businessDevice.equals(other$businessDevice)) {
            return false;
        }
        List<FruClusterNode> this$fruClusterNodes = this.getFruClusterNodes();
        List<FruClusterNode> other$fruClusterNodes = other.getFruClusterNodes();
        if (this$fruClusterNodes == null ? other$fruClusterNodes != null : !((Object)this$fruClusterNodes).equals(other$fruClusterNodes)) {
            return false;
        }
        Product this$product = this.getProduct();
        Product other$product = other.getProduct();
        if (this$product == null ? other$product != null : !((Object)((Object)this$product)).equals((Object)other$product)) {
            return false;
        }
        Map<String, List<ModuleData>> this$dataMap = this.getDataMap();
        Map<String, List<ModuleData>> other$dataMap = other.getDataMap();
        if (this$dataMap == null ? other$dataMap != null : !((Object)this$dataMap).equals(other$dataMap)) {
            return false;
        }
        Map<String, List<ProcessTask>> this$taskMap = this.getTaskMap();
        Map<String, List<ProcessTask>> other$taskMap = other.getTaskMap();
        return !(this$taskMap == null ? other$taskMap != null : !((Object)this$taskMap).equals(other$taskMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FruDevice;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BusinessDevice $businessDevice = this.getBusinessDevice();
        result = result * 59 + ($businessDevice == null ? 43 : $businessDevice.hashCode());
        List<FruClusterNode> $fruClusterNodes = this.getFruClusterNodes();
        result = result * 59 + ($fruClusterNodes == null ? 43 : ((Object)$fruClusterNodes).hashCode());
        Product $product = this.getProduct();
        result = result * 59 + ($product == null ? 43 : ((Object)((Object)$product)).hashCode());
        Map<String, List<ModuleData>> $dataMap = this.getDataMap();
        result = result * 59 + ($dataMap == null ? 43 : ((Object)$dataMap).hashCode());
        Map<String, List<ProcessTask>> $taskMap = this.getTaskMap();
        result = result * 59 + ($taskMap == null ? 43 : ((Object)$taskMap).hashCode());
        return result;
    }

    public String toString() {
        return "FruDevice(businessDevice=" + this.getBusinessDevice() + ", fruClusterNodes=" + this.getFruClusterNodes() + ", product=" + (Object)((Object)this.getProduct()) + ", dataMap=" + this.getDataMap() + ", taskMap=" + this.getTaskMap() + ")";
    }

    private Map<String, List<ProcessTask>> getTaskMap() {
        return this.taskMap;
    }

    private void setTaskMap(Map<String, List<ProcessTask>> taskMap) {
        this.taskMap = taskMap;
    }
}

