/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.model.entity.vo;

import com.huawei.ism.tool.distributed.fru.model.entity.FruDevice;
import com.huawei.ism.tool.distributed.fru.model.entity.TaskConf;
import com.huawei.ism.tool.distributed.fru.model.entity.TaskDetailInfo;
import com.huawei.ism.tool.distributed.fru.model.entity.vo.TaskReqInfoVO;
import com.huawei.ism.tool.distributed.fru.model.enumz.Status;
import com.huawei.ism.tool.distributed.fru.model.enumz.TaskType;
import com.huawei.ism.tool.distributed.fru.service.task.BasicTask;
import com.huawei.ism.tool.distributed.fru.service.task.ProcessTask;
import com.huawei.ism.tool.distributed.fru.service.task.TaskFactory;
import com.huawei.ism.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FruTaskDetailVO {
    private Status status;
    private String description;
    private List<TaskDetailRet> processList;

    public static FruTaskDetailVO buildFruTaskDetailsRet(FruDevice device, TaskReqInfoVO info) {
        String taskId = TaskFactory.INS.createTaskId(device, info);
        List<ProcessTask> tasks = device.findTargetTask(taskId);
        List<TaskDetailRet> tasksVO = tasks.stream().map(TaskDetailRet::new).collect(Collectors.toList());
        return FruTaskDetailVO.builder().status(FruTaskDetailVO.calcStatus(tasks)).processList(tasksVO).description(FruTaskDetailVO.getInitQueryTaskDesc(device, info, tasks)).build();
    }

    private static String getInitQueryTaskDesc(FruDevice device, TaskReqInfoVO info, List<ProcessTask> tasks) {
        if (TaskFactory.INS.isQueryTask(device.getProduct(), info)) {
            return tasks.stream().map(processTask -> processTask.getDetailInfo().getDescription()).findFirst().orElse("");
        }
        return "";
    }

    private static Status calcStatus(List<ProcessTask> tasks) {
        if (tasks.stream().allMatch(task -> task.getDetailInfo().getStatus() == Status.WAITING)) {
            return Status.WAITING;
        }
        if (tasks.stream().allMatch(BasicTask::isSuccess)) {
            return Status.SUCCESS;
        }
        if (tasks.stream().anyMatch(BasicTask::isFailed) && tasks.stream().anyMatch(task -> task.getTaskConf().getType() == TaskType.QUERY_STEP)) {
            return Status.FAILED;
        }
        return Status.RUNNING;
    }

    private static Status $default$status() {
        return Status.WAITING;
    }

    private static List<TaskDetailRet> $default$processList() {
        return new ArrayList<TaskDetailRet>();
    }

    FruTaskDetailVO(Status status, String description, List<TaskDetailRet> processList) {
        this.status = status;
        this.description = description;
        this.processList = processList;
    }

    public static FruTaskDetailVOBuilder builder() {
        return new FruTaskDetailVOBuilder();
    }

    public Status getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    public List<TaskDetailRet> getProcessList() {
        return this.processList;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setProcessList(List<TaskDetailRet> processList) {
        this.processList = processList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FruTaskDetailVO)) {
            return false;
        }
        FruTaskDetailVO other = (FruTaskDetailVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<TaskDetailRet> this$processList = this.getProcessList();
        List<TaskDetailRet> other$processList = other.getProcessList();
        return !(this$processList == null ? other$processList != null : !((Object)this$processList).equals(other$processList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FruTaskDetailVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<TaskDetailRet> $processList = this.getProcessList();
        result = result * 59 + ($processList == null ? 43 : ((Object)$processList).hashCode());
        return result;
    }

    public String toString() {
        return "FruTaskDetailVO(status=" + (Object)((Object)this.getStatus()) + ", description=" + this.getDescription() + ", processList=" + this.getProcessList() + ")";
    }

    public static class FruTaskDetailVOBuilder {
        private boolean status$set;
        private Status status$value;
        private String description;
        private boolean processList$set;
        private List<TaskDetailRet> processList$value;

        FruTaskDetailVOBuilder() {
        }

        public FruTaskDetailVOBuilder status(Status status) {
            this.status$value = status;
            this.status$set = true;
            return this;
        }

        public FruTaskDetailVOBuilder description(String description) {
            this.description = description;
            return this;
        }

        public FruTaskDetailVOBuilder processList(List<TaskDetailRet> processList) {
            this.processList$value = processList;
            this.processList$set = true;
            return this;
        }

        public FruTaskDetailVO build() {
            Status status$value = this.status$value;
            if (!this.status$set) {
                status$value = FruTaskDetailVO.$default$status();
            }
            List processList$value = this.processList$value;
            if (!this.processList$set) {
                processList$value = FruTaskDetailVO.$default$processList();
            }
            return new FruTaskDetailVO(status$value, this.description, processList$value);
        }

        public String toString() {
            return "FruTaskDetailVO.FruTaskDetailVOBuilder(status$value=" + (Object)((Object)this.status$value) + ", description=" + this.description + ", processList$value=" + this.processList$value + ")";
        }
    }

    public static class ProgressDetailsRet {
        private TaskDetailRet processInfo;
        private List<TaskDetailRet> stepsInfo;
        private Map<String, List<TaskDetailRet>> itemsInfo;

        public ProgressDetailsRet(ProcessTask task) {
            this.processInfo = new TaskDetailRet(task);
            this.stepsInfo = TaskDetailRet.buildTaskDetailRet(task.getChildren());
            this.itemsInfo = task.getChildren().stream().map(stepTask -> new Pair((Object)stepTask.getTaskConf().getId(), TaskDetailRet.buildTaskDetailRet(stepTask.getChildren()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        }

        public TaskDetailRet getProcessInfo() {
            return this.processInfo;
        }

        public List<TaskDetailRet> getStepsInfo() {
            return this.stepsInfo;
        }

        public Map<String, List<TaskDetailRet>> getItemsInfo() {
            return this.itemsInfo;
        }

        public void setProcessInfo(TaskDetailRet processInfo) {
            this.processInfo = processInfo;
        }

        public void setStepsInfo(List<TaskDetailRet> stepsInfo) {
            this.stepsInfo = stepsInfo;
        }

        public void setItemsInfo(Map<String, List<TaskDetailRet>> itemsInfo) {
            this.itemsInfo = itemsInfo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProgressDetailsRet)) {
                return false;
            }
            ProgressDetailsRet other = (ProgressDetailsRet)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TaskDetailRet this$processInfo = this.getProcessInfo();
            TaskDetailRet other$processInfo = other.getProcessInfo();
            if (this$processInfo == null ? other$processInfo != null : !((Object)this$processInfo).equals(other$processInfo)) {
                return false;
            }
            List<TaskDetailRet> this$stepsInfo = this.getStepsInfo();
            List<TaskDetailRet> other$stepsInfo = other.getStepsInfo();
            if (this$stepsInfo == null ? other$stepsInfo != null : !((Object)this$stepsInfo).equals(other$stepsInfo)) {
                return false;
            }
            Map<String, List<TaskDetailRet>> this$itemsInfo = this.getItemsInfo();
            Map<String, List<TaskDetailRet>> other$itemsInfo = other.getItemsInfo();
            return !(this$itemsInfo == null ? other$itemsInfo != null : !((Object)this$itemsInfo).equals(other$itemsInfo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProgressDetailsRet;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TaskDetailRet $processInfo = this.getProcessInfo();
            result = result * 59 + ($processInfo == null ? 43 : ((Object)$processInfo).hashCode());
            List<TaskDetailRet> $stepsInfo = this.getStepsInfo();
            result = result * 59 + ($stepsInfo == null ? 43 : ((Object)$stepsInfo).hashCode());
            Map<String, List<TaskDetailRet>> $itemsInfo = this.getItemsInfo();
            result = result * 59 + ($itemsInfo == null ? 43 : ((Object)$itemsInfo).hashCode());
            return result;
        }

        public String toString() {
            return "FruTaskDetailVO.ProgressDetailsRet(processInfo=" + this.getProcessInfo() + ", stepsInfo=" + this.getStepsInfo() + ", itemsInfo=" + this.getItemsInfo() + ")";
        }
    }

    public static class TaskDetailRet {
        private TaskConf taskConf;
        private TaskDetailInfo detailInfo;

        public TaskDetailRet(BasicTask task) {
            this.taskConf = task.getTaskConf();
            this.detailInfo = task.getDetailInfo();
        }

        public TaskDetailRet(TaskConf conf) {
            this.taskConf = conf;
        }

        static List<TaskDetailRet> buildTaskDetailRet(List<? extends BasicTask> tasks) {
            return tasks.stream().map(TaskDetailRet::new).collect(Collectors.toList());
        }

        public TaskConf getTaskConf() {
            return this.taskConf;
        }

        public TaskDetailInfo getDetailInfo() {
            return this.detailInfo;
        }

        public void setTaskConf(TaskConf taskConf) {
            this.taskConf = taskConf;
        }

        public void setDetailInfo(TaskDetailInfo detailInfo) {
            this.detailInfo = detailInfo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskDetailRet)) {
                return false;
            }
            TaskDetailRet other = (TaskDetailRet)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TaskConf this$taskConf = this.getTaskConf();
            TaskConf other$taskConf = other.getTaskConf();
            if (this$taskConf == null ? other$taskConf != null : !((Object)this$taskConf).equals(other$taskConf)) {
                return false;
            }
            TaskDetailInfo this$detailInfo = this.getDetailInfo();
            TaskDetailInfo other$detailInfo = other.getDetailInfo();
            return !(this$detailInfo == null ? other$detailInfo != null : !((Object)this$detailInfo).equals(other$detailInfo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TaskDetailRet;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TaskConf $taskConf = this.getTaskConf();
            result = result * 59 + ($taskConf == null ? 43 : ((Object)$taskConf).hashCode());
            TaskDetailInfo $detailInfo = this.getDetailInfo();
            result = result * 59 + ($detailInfo == null ? 43 : ((Object)$detailInfo).hashCode());
            return result;
        }

        public String toString() {
            return "FruTaskDetailVO.TaskDetailRet(taskConf=" + this.getTaskConf() + ", detailInfo=" + this.getDetailInfo() + ")";
        }
    }

    public static class TaskConfRet {
        private TaskDetailRet processInfo;
        private List<TaskDetailRet> stepsInfo;
        private Map<String, List<TaskDetailRet>> itemsInfo;

        public static TaskConfRet buildTaskConfDetailRet(TaskConf processConf) {
            TaskConfRet confRet = new TaskConfRet();
            confRet.processInfo = new TaskDetailRet(processConf);
            confRet.stepsInfo = processConf.getChildrenConf().stream().map(TaskDetailRet::new).collect(Collectors.toList());
            confRet.itemsInfo = processConf.getChildrenConf().stream().map(stepConf -> new Pair((Object)stepConf.getId(), stepConf.getChildrenConf().stream().map(TaskDetailRet::new).collect(Collectors.toList()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
            return confRet;
        }

        public TaskDetailRet getProcessInfo() {
            return this.processInfo;
        }

        public List<TaskDetailRet> getStepsInfo() {
            return this.stepsInfo;
        }

        public Map<String, List<TaskDetailRet>> getItemsInfo() {
            return this.itemsInfo;
        }

        public void setProcessInfo(TaskDetailRet processInfo) {
            this.processInfo = processInfo;
        }

        public void setStepsInfo(List<TaskDetailRet> stepsInfo) {
            this.stepsInfo = stepsInfo;
        }

        public void setItemsInfo(Map<String, List<TaskDetailRet>> itemsInfo) {
            this.itemsInfo = itemsInfo;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaskConfRet)) {
                return false;
            }
            TaskConfRet other = (TaskConfRet)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TaskDetailRet this$processInfo = this.getProcessInfo();
            TaskDetailRet other$processInfo = other.getProcessInfo();
            if (this$processInfo == null ? other$processInfo != null : !((Object)this$processInfo).equals(other$processInfo)) {
                return false;
            }
            List<TaskDetailRet> this$stepsInfo = this.getStepsInfo();
            List<TaskDetailRet> other$stepsInfo = other.getStepsInfo();
            if (this$stepsInfo == null ? other$stepsInfo != null : !((Object)this$stepsInfo).equals(other$stepsInfo)) {
                return false;
            }
            Map<String, List<TaskDetailRet>> this$itemsInfo = this.getItemsInfo();
            Map<String, List<TaskDetailRet>> other$itemsInfo = other.getItemsInfo();
            return !(this$itemsInfo == null ? other$itemsInfo != null : !((Object)this$itemsInfo).equals(other$itemsInfo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TaskConfRet;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TaskDetailRet $processInfo = this.getProcessInfo();
            result = result * 59 + ($processInfo == null ? 43 : ((Object)$processInfo).hashCode());
            List<TaskDetailRet> $stepsInfo = this.getStepsInfo();
            result = result * 59 + ($stepsInfo == null ? 43 : ((Object)$stepsInfo).hashCode());
            Map<String, List<TaskDetailRet>> $itemsInfo = this.getItemsInfo();
            result = result * 59 + ($itemsInfo == null ? 43 : ((Object)$itemsInfo).hashCode());
            return result;
        }

        public String toString() {
            return "FruTaskDetailVO.TaskConfRet(processInfo=" + this.getProcessInfo() + ", stepsInfo=" + this.getStepsInfo() + ", itemsInfo=" + this.getItemsInfo() + ")";
        }
    }
}

