/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.service.device;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.distributed.fru.common.Context;
import com.huawei.ism.tool.distributed.fru.model.entity.Product;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import java.util.Objects;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class FruNodeSupport
implements INodeSupport {
    public boolean isNodeSupport(DevNode dev) {
        String model = dev.getDeviceType().toString();
        String version = dev.getProductVersion();
        if (dev.isFusionCube()) {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dev.getIp()) && !StringUtils.isValidIPV4((String)dev.getIp())) {
                return false;
            }
            String scenarioInfo = dev.getScenarioInfo();
            return Context.INS.getSupportProducts().stream().anyMatch(product -> this.isFusionCubeVersionMatch(model, version, scenarioInfo, (Product)((Object)product)));
        }
        return Objects.nonNull(dev.getFusionCubeLoginUser()) || Context.INS.getSupportProducts().stream().anyMatch(product -> model.contains(product.getProductModel()) && version.contains(product.getProductVersion()));
    }

    private boolean isFusionCubeVersionMatch(String model, String version, String scenarioInfo, Product product) {
        return model.contains(product.getProductModel()) && version.contains(product.getProductVersion()) && product.getScenarioInfos().stream().anyMatch(info -> org.apache.commons.lang3.StringUtils.containsIgnoreCase((CharSequence)scenarioInfo, (CharSequence)info));
    }
}

