/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.service.fusioncube.board;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.util.TypeUtils;
import com.huawei.ism.tool.distributed.fru.model.entity.AuthDevNode;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.CommonService;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.board.enums.ServerBoardTypeEnums;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.entity.PageResponse;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.entity.ResultVo;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.entity.board.ArCard;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.entity.board.Boards;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.entity.board.ServerBoard;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.entity.board.base.RfMember;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.entity.board.chassis.RfChassisesResponse;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.entity.board.device.DeviceInfoTo;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.entity.board.device.ExtFeature;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.entity.board.device.SimpleDevice;
import com.huawei.ism.tool.distributed.fru.service.task.FruTasksEnv;
import com.huawei.ism.tool.distributed.fru.util.DeviceUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.rest.FusionCubeConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.service.rest.service.device.RedfishConnectionManager;
import com.huawei.uMate.common.rest.RedfishConnestion;
import com.huawei.uMate.common.rest.RedfishResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerBoardCommonService
extends CommonService {
    private static final Logger log = LoggerFactory.getLogger(ServerBoardCommonService.class);
    protected static final String CHASSIS_URI = "/redfish/v1/Chassis/";
    protected static final String CHASSIS_BOARDS_URI = "/redfish/v1/Chassis/%s/Boards";
    protected static final String SYSTEM_URI = "/redfish/v1/Systems/";
    protected static final String QUERY_STORAGE_POOL_INFO = "/dsware/service/resource/queryStoragePool";
    protected static final String QUERY_DISK_INFO = "/dsware/service/cluster/storagepool/queryNodeDiskInfo?poolId=%s";
    protected static List<DeviceInfoTo> fusionCubeDeviceInfo = new ArrayList<DeviceInfoTo>();
    protected static List<NodeInfo> slot1ManagerIpList = new ArrayList<NodeInfo>();
    protected static Map<String, String> arCardIpMap = new HashMap<String, String>();
    private static final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerBoard> queryServerBoardByType(DevNode bmcNode, ServerBoardTypeEnums type) throws ToolException {
        this.setCaseInsensitiveTrue();
        RedfishConnestion connection = RedfishConnectionManager.INS.getRedFishConnection(bmcNode);
        try {
            String chassisId = this.getChassisId(connection);
            RedfishResult redfishResult = connection.executeGet(String.format(CHASSIS_BOARDS_URI, chassisId));
            if (redfishResult.isSuccess()) {
                Boards boards = (Boards)redfishResult.getResultJSON().getJSONObject("Oem").getJSONObject("Huawei").getJSONObject("Boards").toJavaObject(Boards.class);
                List<String> links = type == ServerBoardTypeEnums.AR_CARD ? boards.getArCard().getLinks().stream().map(RfMember::getOdataId).collect(Collectors.toList()) : boards.getExpansionModule().getLinks().stream().map(RfMember::getOdataId).collect(Collectors.toList());
                List<ServerBoard> list = this.getServerBoard(connection, links, type);
                return list;
            }
            List<ServerBoard> list = Collections.emptyList();
            return list;
        }
        finally {
            RedfishConnectionManager.INS.releaseConn(bmcNode);
        }
    }

    private List<ServerBoard> getServerBoard(RedfishConnestion connection, List<String> links, ServerBoardTypeEnums type) {
        if (CollectionUtils.isEmpty(links)) {
            return Collections.emptyList();
        }
        ArrayList<ServerBoard> serverBoards = new ArrayList<ServerBoard>();
        for (String link : links) {
            RedfishResult redfishResult = connection.executeGet(link);
            if (!redfishResult.isSuccess()) continue;
            ServerBoard serverBoard = type == ServerBoardTypeEnums.AR_CARD ? (ServerBoard)redfishResult.getResultJSON().toJavaObject(ArCard.class) : (ServerBoard)redfishResult.getResultJSON().toJavaObject(ServerBoard.class);
            String health = redfishResult.getResultJSON().getJSONObject("Status").getString("Health");
            if (!StringUtils.equals((CharSequence)health, (CharSequence)"OK")) {
                serverBoard.setStatus(1);
            }
            serverBoards.add(serverBoard);
        }
        return serverBoards;
    }

    protected String getChassisId(RedfishConnestion connection) {
        if (StringUtils.isEmpty((CharSequence)connection.getChassisId())) {
            RfChassisesResponse chassisesResponse;
            RedfishResult redfishResult = connection.executeGet(CHASSIS_URI);
            log.info("Query ChassisId result : {}", (Object)JSON.toJSONString((Object)redfishResult));
            if (redfishResult.isSuccess() && (chassisesResponse = (RfChassisesResponse)redfishResult.getResultJSON().toJavaObject(RfChassisesResponse.class)).getError() == null) {
                RfMember rfMember = this.queryChassisIdInfo(chassisesResponse);
                String[] odataId = rfMember.getOdataId().split("/");
                String chassisId = odataId[odataId.length - 1];
                connection.setChassisId(chassisId);
                return chassisId;
            }
        }
        return connection.getChassisId();
    }

    private RfMember queryChassisIdInfo(RfChassisesResponse rfChassisesResponse) {
        RfMember rfMember = rfChassisesResponse.getMembers().stream().filter(item -> item.getOdataId().contains("Blade")).findFirst().orElse(null);
        if (Objects.isNull(rfMember)) {
            rfMember = rfChassisesResponse.getMembers().get(0);
        }
        return rfMember;
    }

    private void setCaseInsensitiveTrue() {
        TypeUtils.compatibleWithJavaBean = true;
    }

    public List<ServerBoard> queryBoardInfo(FruTasksEnv env, ServerBoardTypeEnums type) throws ToolException {
        this.queryFusionCubeDeviceInfo(env.getCluster());
        if (CollectionUtils.isEmpty(fusionCubeDeviceInfo)) {
            log.error("FUSION_CUBE_DEVICE_INFO is empty");
            return Collections.emptyList();
        }
        ArrayList<ServerBoard> serverBoards = new ArrayList<ServerBoard>();
        try {
            Map<Integer, AuthDevNode> authDevNodeByNodeIdList = DeviceUtil.INS.getAuthDevNodeByNodeIdList(env.getFruDevice(), env.getNodeIdList());
            for (Map.Entry<Integer, AuthDevNode> entry : authDevNodeByNodeIdList.entrySet()) {
                Optional<String> associationId;
                DevNode bmcNode = entry.getValue().getBmcNode();
                DevNode osNode = entry.getValue().getOsNode();
                if (bmcNode == null && !entry.getValue().isBmcAuthSuccess() || !entry.getValue().getClusterNode().isStorageNode() || !(associationId = slot1ManagerIpList.stream().filter(nodeInfo -> nodeInfo.getManagementIp().equals(osNode.getIp())).map(NodeInfo::getAssociationId).findAny()).isPresent()) continue;
                List<ServerBoard> boards = this.queryServerBoardByType(bmcNode, type);
                this.updateBoardsInfo(boards, entry.getValue().getClusterNode().getManagementIp(), associationId.get());
                serverBoards.addAll(boards);
            }
            return serverBoards;
        }
        catch (ToolException e) {
            log.error("queryBoardInfo with moduleId ={} error:", (Object)env.getModuleId(), (Object)e);
            throw e;
        }
    }

    private void updateBoardsInfo(List<? extends ServerBoard> boards, String managementIp, String associationId) {
        CollectionUtils.emptyIfNull(boards).forEach(board -> {
            board.setBelongNodeIp(managementIp);
            board.setAssociationId(associationId);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void queryFusionCubeDeviceInfo(DevNode devNode) throws ToolException {
        Object object = LOCK;
        synchronized (object) {
            if (CollectionUtils.isNotEmpty(fusionCubeDeviceInfo)) {
                log.info("FUSION_CUBE_DEVICE_INFO is inited, return");
                return;
            }
            log.info("queryFusionCubeDeviceInfo enter");
            try {
                FusionCubeConnection connection = RestConnectionManager.getFusionCubeRestConnection((DevNode)devNode);
                JSONObject params = new JSONObject();
                params.put("filterChildDevice", (Object)0);
                params.put("appendFeature", (Object)1);
                params.put("deviceTypes", Arrays.asList("server", "network"));
                ResponseInfo responseInfo = connection.execPost(connection.getDeviceListUrl(), params.toJSONString());
                if (!responseInfo.isSuccess() || !StringUtils.isNotEmpty((CharSequence)responseInfo.getContent())) {
                    log.error("query fusionCube info error");
                    return;
                }
                ResultVo resultVo = (ResultVo)JSONObject.parseObject((String)responseInfo.getContent(), (TypeReference)new TypeReference<ResultVo<PageResponse<DeviceInfoTo>>>(){}, (Feature[])new Feature[0]);
                if (!resultVo.isSuccess() || ((PageResponse)resultVo.getData()).getTotal() <= 0) {
                    log.error("query fusionCube info error");
                    return;
                }
                fusionCubeDeviceInfo = ((PageResponse)resultVo.getData()).getDataList();
                this.handleServerIp();
                this.handleArCardMap();
            }
            finally {
                RestConnectionManager.releaseFusionCubeConnection((DevNode)devNode);
            }
            return;
        }
    }

    private void handleArCardMap() {
        Map<String, String> serialNumber2IpMap = fusionCubeDeviceInfo.stream().filter(device -> StringUtils.equals((CharSequence)"AR-10", (CharSequence)device.getDeviceModel())).map(device -> {
            String serialNumber = device.getExtFeatures().stream().filter(ext -> StringUtils.equals((CharSequence)"serialNumber", (CharSequence)ext.getExtKey())).findFirst().orElseGet(ExtFeature::new).getExtValue();
            return new SimpleDevice(device.getDeviceId(), device.getDeviceIp(), serialNumber, device.getSlot(), device.getAssociationId());
        }).collect(Collectors.toMap(simpleDevice -> simpleDevice.getSlot() + simpleDevice.getAssociationId(), SimpleDevice::getDeviceIp));
        if (MapUtils.isNotEmpty(serialNumber2IpMap)) {
            arCardIpMap = serialNumber2IpMap;
        } else {
            log.error("handleArCardMap error");
        }
    }

    private void handleServerIp() {
        slot1ManagerIpList = fusionCubeDeviceInfo.stream().filter(device -> StringUtils.equals((CharSequence)"DP5410", (CharSequence)device.getDeviceModel()) && StringUtils.equals((CharSequence)"1", (CharSequence)device.getSlot())).map(device -> new NodeInfo(device.getManagementIp(), device.getAssociationId())).collect(Collectors.toList());
    }

    static class NodeInfo {
        private String managementIp;
        private String associationId;

        public NodeInfo(String managementIp, String associationId) {
            this.managementIp = managementIp;
            this.associationId = associationId;
        }

        public String getManagementIp() {
            return this.managementIp;
        }

        public String getAssociationId() {
            return this.associationId;
        }
    }
}

