/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.service.fusioncube.board.arcard;

import com.huawei.ism.tool.distributed.fru.model.entity.FruDevice;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.entity.board.ArCard;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.entity.board.ArCardAuthNode;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.entity.board.ArCardAuthRequestTo;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.rest.model.Either;
import com.huawei.ism.tool.service.rest.model.enumz.Status;
import com.huawei.ism.tool.service.rest.service.device.ClusterAuthServer;
import com.huawei.ism.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArCardAuthService {
    private static final Logger log = LoggerFactory.getLogger(ArCardAuthService.class);
    public static final ArCardAuthService INS = new ArCardAuthService();
    private static Map<String, ArCardAuthNode> arCardAuthNodeMap = new ConcurrentHashMap<String, ArCardAuthNode>();
    private final ExecutorService executor = ClusterAuthServer.INS.getExecutor();

    public synchronized boolean batchAuthArCard(ArCardAuthRequestTo request, FruDevice fruDevice) {
        try {
            List arCardInfo = fruDevice.getDataMap().getOrDefault("arCard", Collections.emptyList()).stream().map(var -> (ArCard)ArCard.class.cast(var)).collect(Collectors.toList());
            arCardInfo.stream().filter(ar -> request.getSn().contains(ar.getSerialNumber())).map(Either.lift(ar -> this.buildOsNodePairByClusterNode((ArCard)ar, request))).filter(Either::isRight).map(Either::getRight).map(Optional::get).forEach(pair -> this.submitTask((Pair<ArCardAuthNode, DevNode>)pair, this::arAuth, this::syncArAuthResult2ArCardAuthNode));
        }
        catch (Exception e) {
            log.error("Start batch ArCard auth failed.", (Throwable)e);
            return false;
        }
        return true;
    }

    private void syncArAuthResult2ArCardAuthNode(TaskResult taskResult, ArCardAuthNode authNode) {
        DevNode arCard = (DevNode)taskResult.getResultObject();
        authNode.setUser(arCard.getLoginUser());
        Status authStatus = Status.SUCCESS;
        String description = "";
        if (taskResult.getResult() == TaskResult.Result.FAILED) {
            authStatus = Status.FAILED;
            description = taskResult.getErrorLocaleDescription();
        }
        authNode.setSshPort(arCard.getPort());
        authNode.setAuthStatus(new ArCardAuthNode.AuthStatusInfo(description, authStatus));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskResult arAuth(Pair<ArCardAuthNode, DevNode> pair) {
        TaskResult taskResult = new TaskResult();
        DevNode node = (DevNode)pair.getValue();
        taskResult.setResultObject((Object)node);
        ((ArCardAuthNode)pair.getKey()).setAuthStatus(new ArCardAuthNode.AuthStatusInfo("", Status.RUNNING));
        try {
            this.connArCard(node);
            taskResult.setResult(TaskResult.Result.SUCCESS);
        }
        catch (ToolException e) {
            log.error("ArCard node {} auth failed.", (Object)node.getIp(), (Object)e);
            taskResult.setResult(TaskResult.Result.FAILED);
            taskResult.setErrorLocaleDescription(e.getErrorLocaleDescription());
        }
        finally {
            SshConnectionManager.releaseConnection((DevNode)node);
        }
        return taskResult;
    }

    private void connArCard(DevNode node) throws ToolException {
        SshConnectionManager.getSshConnection((DevNode)node);
    }

    private CompletableFuture<Void> submitTask(Pair<ArCardAuthNode, DevNode> nodePair, Function<Pair<ArCardAuthNode, DevNode>, TaskResult> function, BiConsumer<TaskResult, ArCardAuthNode> after) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> (TaskResult)function.apply(nodePair), this.executor).exceptionally(exception -> this.buildAuthFailedResult((Throwable)exception, (DevNode)nodePair.getValue()))).thenAccept(result -> after.accept((TaskResult)result, (ArCardAuthNode)nodePair.getKey()));
    }

    private TaskResult buildAuthFailedResult(Throwable exception, DevNode devNode) {
        log.error("ArCard node {} auth exception", (Object)devNode.getIp(), (Object)exception);
        TaskResult authResult = new TaskResult();
        authResult.setResult(TaskResult.Result.FAILED);
        authResult.setResultObject((Object)devNode);
        authResult.setErrorLocaleDescription(ResourceUtil.getStringWithParams((String)"device.cluster.auth.failed", (Object[])new Object[]{devNode.getIp()}));
        return authResult;
    }

    private Pair<ArCardAuthNode, DevNode> buildOsNodePairByClusterNode(ArCard node, ArCardAuthRequestTo request) {
        ArCardAuthNode authNode = arCardAuthNodeMap.getOrDefault(node.getSerialNumber(), new ArCardAuthNode());
        authNode.setUser(request.getUser());
        authNode.setArCard(node);
        DevNode devNode = this.buildArCardAuthNode(node, request);
        authNode.setDevNode(devNode);
        arCardAuthNodeMap.put(node.getSerialNumber(), authNode);
        return new Pair((Object)authNode, (Object)devNode);
    }

    private DevNode buildArCardAuthNode(ArCard arCard, ArCardAuthRequestTo request) {
        DevNode devNode = new DevNode();
        devNode.setIp(arCard.getIp());
        devNode.setDeviceSerialNumber(arCard.getSerialNumber());
        devNode.setLoginUser(request.getUser());
        devNode.setPort(request.getPort());
        return devNode;
    }

    public Optional<ArCardAuthNode> getArCardAuthNode(String sn) {
        return Optional.ofNullable(arCardAuthNodeMap.getOrDefault(sn, null));
    }
}

