/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.service.fusioncube.board.arcard;

import com.alibaba.fastjson.JSON;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.distributed.fru.model.entity.AuthDevNode;
import com.huawei.ism.tool.distributed.fru.model.module.ModuleData;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.board.ServerBoardCommonService;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.board.arcard.ArCardAuthService;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.board.arcard.ArCardConfigBackUp;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.board.arcard.ArCardSshJudge;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.board.enums.ServerBoardTypeEnums;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.entity.board.ArCard;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.entity.board.ArCardAuthNode;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.entity.board.ServerBoard;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.executor.CommandException;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.executor.SessionParameter;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.executor.SshdUtil;
import com.huawei.ism.tool.distributed.fru.service.task.FruTasksEnv;
import com.huawei.ism.tool.distributed.fru.service.task.ItemTask;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.ISshJudge;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.Base64EncodeUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArCardTaskService
extends ServerBoardCommonService {
    private static final Logger log = LoggerFactory.getLogger(ArCardTaskService.class);
    public static final ArCardTaskService INS = new ArCardTaskService();
    private static final Map<Integer, ArCard> arCardMap = new ConcurrentHashMap<Integer, ArCard>();
    private static final List<String> BACK_UP_BLACK_LIST = Arrays.asList("8.1.RC3", "8.1.3", "8.1.RC5", "8.1.RC6");

    public List<String> queryArCardInfo(FruTasksEnv env) throws ToolException {
        List<ServerBoard> serverBoards = super.queryBoardInfo(env, ServerBoardTypeEnums.AR_CARD);
        List<ModuleData> arCards = this.appendArCardIp(serverBoards);
        env.initModuleDataByModuleAndNode(env.getModuleId(), arCards);
        return this.getSuccessTaskResult();
    }

    private List<ModuleData> appendArCardIp(List<ServerBoard> boards) {
        ArrayList<ModuleData> moduleDatas = new ArrayList<ModuleData>(boards);
        log.info("appendArCardIp enter");
        if (MapUtils.isNotEmpty((Map)arCardIpMap)) {
            moduleDatas.clear();
            List<ArCard> arCards = boards.stream().map(ArCard.class::cast).collect(Collectors.toList());
            arCards.forEach(arCard -> {
                String arIp = arCardIpMap.getOrDefault(arCard.getCardNo() + arCard.getAssociationId(), "");
                log.info("Ar card IP {}", (Object)arIp);
                arCard.setIp(arIp);
            });
            moduleDatas.addAll(arCards);
        }
        return moduleDatas;
    }

    public List<String> initArCardPreInfo(FruTasksEnv env) {
        ModuleData data = env.getData();
        log.info("initArCardPreInfo : {}", (Object)JSON.toJSONString((Object)data));
        if (data instanceof ArCard) {
            ArCard arCard = (ArCard)ArCard.class.cast(data);
            arCardMap.put(arCard.getCardNo(), arCard);
        }
        return this.getSuccessTaskResult();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isBackArConfigFromFcv(DevNode devNode) {
        if (!devNode.isFusionCube()) return false;
        if (!BACK_UP_BLACK_LIST.stream().noneMatch(devNode.getProductVersion()::contains)) return false;
        return true;
    }

    public List<String> backUpArCardConfig(FruTasksEnv env) {
        ModuleData data = env.getData();
        log.info("backUpArCardConfig : {}", (Object)JSON.toJSONString((Object)data));
        this.updateProgress(10.0, env.getCurrentTask());
        ArCard arCard = (ArCard)ArCard.class.cast(data);
        DevNode devNode = env.getFruDevice().getDevNode();
        String localPath = ArCardConfigBackUp.getHomeDir() + File.separator + arCard.getIdentifier() + "_config.cfg";
        SessionParameter parameter = this.getSessionParameter(devNode);
        if (this.isBackArConfigFromFcv(devNode)) {
            return this.backUpArCardConfigFromFcv(parameter, arCard, localPath, devNode);
        }
        return this.backUpArCardConfigFromArCard(env, arCard, devNode, localPath, parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private List<String> backUpArCardConfigFromArCard(FruTasksEnv env, ArCard arCard, DevNode devNode, String localPath, SessionParameter parameter) {
        Optional<ArCardAuthNode> authNode = ArCardAuthService.INS.getArCardAuthNode(arCard.getSerialNumber());
        if (!authNode.isPresent()) {
            return this.getNotInvolvedTaskResult();
        }
        ICliConnection sshConnection = null;
        try {
            List<String> list;
            Object object;
            SshdUtil sshdUtil;
            block23: {
                block24: {
                    sshdUtil = SshdUtil.getSshdUtil(parameter, null, true);
                    object = null;
                    sshConnection = SshConnectionManager.getSshConnection((DevNode)authNode.get().getDevNode(), (ISshJudge)new ArCardSshJudge());
                    this.saveConfig(sshConnection);
                    this.enableSftpServer(sshConnection, authNode.get().getDevNode().getLoginUser().getUserName());
                    this.updateProgress(50.0, env.getCurrentTask());
                    sshdUtil.execute("su - root", "password:");
                    sshdUtil.execute(Base64EncodeUtils.decode((String)devNode.getRootUser().getPassword()), "root");
                    sshdUtil.execute("cd /home/manageromm");
                    String result = sshdUtil.execute("sftp " + authNode.get().getDevNode().getLoginUser().getUserName() + "@" + arCard.getIp(), Duration.ofSeconds(5L), "password:", "(yes/no/[fingerprint])?");
                    result = this.confirmFingerprintIfNeed(sshdUtil, result);
                    if (this.checkNeedInputPassword(result)) {
                        sshdUtil.execute(authNode.get().getDevNode().getLoginUser().getPassword(), "sftp>");
                    }
                    sshdUtil.execute("get config.cfg", Duration.ofSeconds(5L), "sftp>");
                    sshdUtil.execute("exit", "root");
                    sshdUtil.execute("chown manageromm:manageromm config.cfg");
                    sshdUtil.execute("chmod +r config.cfg");
                    this.updateProgress(75.0, env.getCurrentTask());
                    this.downloadArCardConfig(parameter, localPath);
                    sshdUtil.execute("rm -f config.cfg");
                    env.getCurrentTask().updateSuggestion(ResourceUtil.getStringWithParams((String)"item.back_up_ar_config.success", (Object[])new Object[]{localPath}));
                    list = this.getSuccessTaskResult();
                    if (sshdUtil == null) break block23;
                    if (object == null) break block24;
                    try {
                        sshdUtil.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    break block23;
                }
                sshdUtil.close();
            }
            SshConnectionManager.releaseConnection((ICliConnection)sshConnection);
            return list;
            catch (Throwable throwable) {
                try {
                    try {
                        object = throwable;
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (sshdUtil != null) {
                            if (object != null) {
                                try {
                                    sshdUtil.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)object).addSuppressed(throwable3);
                                }
                            } else {
                                sshdUtil.close();
                            }
                        }
                        throw throwable2;
                    }
                }
                catch (FileNotFoundException e) {
                    log.error("backUpArCardConfig method may have file not found");
                    object = this.getNotInvolvedTaskResult();
                    SshConnectionManager.releaseConnection(sshConnection);
                    return object;
                }
                catch (IsmException | CommandException | IOException e) {
                    log.error("sftp download arCard config fail: ", e);
                    object = this.getNotInvolvedTaskResult();
                    return object;
                }
                catch (ToolException e) {
                    log.error("Failed to connect to device.", (Throwable)e);
                    object = this.getNotInvolvedTaskResult();
                    return object;
                    {
                        catch (Throwable throwable4) {
                            throw throwable4;
                        }
                    }
                }
            }
        }
        finally {
            SshConnectionManager.releaseConnection(sshConnection);
        }
    }

    /*
     * Exception decompiling
     */
    private List<String> backUpArCardConfigFromFcv(SessionParameter parameter, ArCard arCard, String localPath, DevNode devNode) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void copyConfig(ArCard arCard, DevNode devNode, SshdUtil sshdUtil) throws CommandException {
        sshdUtil.execute("su - root", "password:");
        sshdUtil.execute(Base64EncodeUtils.decode((String)devNode.getRootUser().getPassword()), "root");
        sshdUtil.executeWithLog("rm -f /home/manageromm/ar_config.cfg");
        String findFileCmd = "find /home/manageromm -name ar_config.cfg";
        String findRes = sshdUtil.executeWithLog(findFileCmd);
        if (findRes.replace(findFileCmd, "").contains("ar_config.cfg")) {
            log.error("delete ar_config.cfg failed, find res is : {}", (Object)findRes);
            throw new CommandException("failed to delete ar_config.cfg");
        }
        String cpCmd = String.format(Locale.ENGLISH, "cp -f /repo/backup/ar_backup/%s/config.cfg /home/manageromm/ar_config.cfg", arCard.getIp());
        sshdUtil.executeWithLog(cpCmd);
        sshdUtil.executeWithLog("cd /home/manageromm/");
        sshdUtil.executeWithLog("chown manageromm:manageromm ar_config.cfg");
        sshdUtil.executeWithLog("chmod +r ar_config.cfg");
        findRes = sshdUtil.executeWithLog(findFileCmd);
        if (!findRes.replace(findFileCmd, "").contains("ar_config.cfg")) {
            log.error("copy ar_config.cfg failed. find res is: {}", (Object)findRes);
            throw new CommandException("failed to copy ar_config.cfg");
        }
    }

    private SessionParameter getSessionParameter(DevNode devNode) {
        return SessionParameter.builder().ip(devNode.getIp()).port(22).username(devNode.getFusionCubeLoginUser().getUserName()).password(devNode.getFusionCubeLoginUser().getPassword()).build();
    }

    private void enableSftpServer(ICliConnection sshConnection, String username) throws ToolException {
        sshConnection.execCmd("sys");
        sshConnection.execCmd("aaa");
        sshConnection.execCmd(String.format("local-user %s service-type terminal ssh ftp http", username));
        sshConnection.execCmd("sftp server enable");
        sshConnection.execCmd("aaa");
        sshConnection.execCmd("quit");
    }

    private void downloadArCardConfig(SessionParameter parameter, String localPath) throws IOException {
        try (SshdUtil sftpUtil = SshdUtil.getSftpUtil(parameter);){
            sftpUtil.download("config.cfg", localPath);
            log.info("download arCardConfig success");
        }
    }

    private String confirmFingerprintIfNeed(SshdUtil sshdUtil, String result) throws IOException {
        if (StringUtils.containsIgnoreCase((CharSequence)result, (CharSequence)"(yes/no/[fingerprint])?")) {
            return sshdUtil.execute("yes", "password:");
        }
        return result;
    }

    private boolean checkNeedInputPassword(String result) {
        return StringUtils.containsIgnoreCase((CharSequence)result, (CharSequence)"password:");
    }

    private void updateProgress(double progress, ItemTask currentTask) {
        currentTask.updateProgress(progress);
    }

    private void saveConfig(ICliConnection connection) throws ToolException {
        connection.execCmd("sys");
        String result = connection.execCmd("save config.cfg");
        result = this.confirmIfNeed(connection, result);
        result = this.confirmIfNeed(connection, result);
        connection.execCmd("quit");
    }

    private String confirmIfNeed(ICliConnection connection, String result) throws ToolException {
        if (StringUtils.containsAnyIgnoreCase((CharSequence)result, (CharSequence[])new CharSequence[]{"y/n", "yes/no"})) {
            return connection.execCmd("Y");
        }
        return result;
    }

    public List<String> queryReplaceArCardInfo(FruTasksEnv env) throws ToolException {
        ModuleData data = env.getData();
        log.info("queryReplaceArCardInfo : {}", (Object)JSON.toJSONString((Object)data));
        if (data instanceof ArCard) {
            ArCard arCard = (ArCard)ArCard.class.cast(data);
            AuthDevNode authDevNode = new AuthDevNode(env.getFruDevice().findTargetFruClusterNodeByIp(arCard.getBelongNodeIp()).get());
            List<ServerBoard> arCards = this.queryServerBoardByType(authDevNode.getBmcNode(), ServerBoardTypeEnums.AR_CARD);
            Optional<ServerBoard> newArCardInfo = arCards.stream().filter(card -> card.getCardNo() == arCard.getCardNo()).findAny();
            if (newArCardInfo.isPresent()) {
                ArCard oldArCard = arCardMap.getOrDefault(newArCardInfo.get().getCardNo(), new ArCard());
                if (!StringUtils.equals((CharSequence)oldArCard.getSerialNumber(), (CharSequence)newArCardInfo.get().getSerialNumber())) {
                    log.info("ArCard replace success, new ArCard info : {}", (Object)JSON.toJSONString((Object)newArCardInfo.get()));
                    newArCardInfo.get().setBelongNodeIp(arCard.getBelongNodeIp());
                    env.setDataAfterReplace(newArCardInfo.get());
                    return this.getSuccessTaskResult();
                }
                return this.getFailedTaskResult(ResourceUtil.getString((String)"found.same.replace.arCard"));
            }
            return this.getFailedTaskResult(ResourceUtil.getString((String)"not.found.replace.arCard"));
        }
        log.error("current data : {} is not arCard", (Object)env.getModuleId());
        return this.getFailedTaskResult(ResourceUtil.getString((String)"not.found.replace.arCard"));
    }
}

