/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.service.fusioncube.board.cascade;

import com.huawei.ism.tool.distributed.fru.model.entity.AuthDevNode;
import com.huawei.ism.tool.distributed.fru.model.module.ModuleData;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.board.ServerBoardCommonService;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.board.cascade.IbmcSshJudge;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.board.enums.ServerBoardTypeEnums;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.entity.board.ServerBoard;
import com.huawei.ism.tool.distributed.fru.service.task.FruTasksEnv;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.ISshJudge;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CascadeBoardTaskService
extends ServerBoardCommonService {
    private static final Logger log = LoggerFactory.getLogger(CascadeBoardTaskService.class);
    public static final CascadeBoardTaskService INS = new CascadeBoardTaskService();
    public static final Map<Integer, ServerBoard> cascadeBoardInfo = new HashMap<Integer, ServerBoard>();

    public List<String> queryCascadeBoardInfo(FruTasksEnv env) throws ToolException {
        List<ServerBoard> serverBoards = this.queryBoardInfo(env, ServerBoardTypeEnums.EXPANSION_MODULE);
        this.appendCascadeBoardSerialNumber(serverBoards, env);
        ArrayList<ModuleData> data = new ArrayList<ModuleData>(serverBoards);
        env.initModuleDataByModuleAndNode(env.getModuleId(), data);
        return this.getSuccessTaskResult();
    }

    private void appendCascadeBoardSerialNumber(List<ServerBoard> serverBoards, FruTasksEnv env) throws ToolException {
        if (CollectionUtils.isEmpty(serverBoards)) {
            log.info("serverBoards is empty");
            return;
        }
        Map<Integer, ServerBoard> boardMap = serverBoards.stream().filter(board -> StringUtils.isEmpty((CharSequence)board.getSerialNumber())).collect(Collectors.toMap(ServerBoard::getCardNo, board -> board, (oldValue, newValue) -> newValue));
        if (Objects.isNull(boardMap) || boardMap.isEmpty()) {
            log.info("cascade board has serialnumber, do not need query");
            return;
        }
        DevNode bmcNode = env.getBmcNode();
        if (Objects.isNull(bmcNode)) {
            String belongIp = serverBoards.get(0).getBelongNodeIp();
            AuthDevNode authDevNode = new AuthDevNode(env.getFruDevice().findTargetFruClusterNodeByIp(belongIp).get());
            bmcNode = authDevNode.getBmcNode();
        }
        bmcNode.setPort(22);
        ICliConnection sshConnection = SshConnectionManager.getSshConnection((DevNode)bmcNode, (ISshJudge)new IbmcSshJudge());
        sshConnection.execCmd("maint_debug_cli");
        String result = sshConnection.execCmd("getprop ExpElabel-7.BoardSerialNumber");
        String boardSerialNumber = this.parseBoardSerialNumber(result);
        if (boardMap.containsKey(0)) {
            boardMap.get(0).setSerialNumber(boardSerialNumber);
        }
        result = sshConnection.execCmd("getprop ExpElabel-8.BoardSerialNumber");
        boardSerialNumber = this.parseBoardSerialNumber(result);
        if (boardMap.containsKey(1)) {
            boardMap.get(1).setSerialNumber(boardSerialNumber);
        }
        sshConnection.execCmd("bye");
    }

    private String parseBoardSerialNumber(String result) {
        if (StringUtils.isEmpty((CharSequence)result)) {
            return "";
        }
        String[] split = StringUtils.split((String)result, (String)"\r\n");
        if (Objects.isNull(split) || split.length < 2) {
            return "";
        }
        return split[1];
    }

    public List<String> initCascadePreInfo(FruTasksEnv env) {
        ModuleData data = env.getData();
        if (data instanceof ServerBoard) {
            ServerBoard serverBoard = (ServerBoard)ServerBoard.class.cast(data);
            cascadeBoardInfo.put(serverBoard.getCardNo(), serverBoard);
        }
        return this.getSuccessTaskResult();
    }

    public List<String> queryReplaceCascadeInfo(FruTasksEnv env) throws ToolException {
        int cardNo;
        ModuleData data = env.getData();
        List<ServerBoard> boards = this.queryServerBoardByType(env.getBmcNode(), ServerBoardTypeEnums.EXPANSION_MODULE);
        this.appendCascadeBoardSerialNumber(boards, env);
        if (!cascadeBoardInfo.isEmpty() && data instanceof ServerBoard && cascadeBoardInfo.containsKey(cardNo = ((ServerBoard)ServerBoard.class.cast(data)).getCardNo())) {
            ServerBoard board = cascadeBoardInfo.get(cardNo);
            Optional<ServerBoard> first = boards.stream().filter(currentBoard -> currentBoard.getCardNo() == cardNo && !currentBoard.getSerialNumber().equals(board.getSerialNumber())).findFirst();
            if (first.isPresent()) {
                first.get().setBelongNodeIp(board.getBelongNodeIp());
                env.setDataAfterReplace(first.get());
                return this.getSuccessTaskResult();
            }
        }
        return this.getFailedTaskResult(ResourceUtil.getString((String)"replace.cascade.notfound"));
    }
}

