/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.service.fusioncube.disk;

import com.alibaba.fastjson.JSON;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.distributed.fru.model.module.ModuleData;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.CommonService;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.entity.disk.NvmeDiskInfo;
import com.huawei.ism.tool.distributed.fru.service.task.FruTasksEnv;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NvmeDiskPowerService
extends CommonService {
    private static final Logger log = LoggerFactory.getLogger(NvmeDiskPowerService.class);
    public static final NvmeDiskPowerService INS = new NvmeDiskPowerService();
    private static final String QUERY_NVME_DISK_INFO_COMMAND = "/opt/dsware/agent/tool/dsware_agent_tool --op query_disk";
    private static final String SET_TIME_COMMAND = "nvme admin-passthru /dev/%s \u2013o 0xc5 -6 0x020000 -7 1 -8 1";
    private static final String POWER_OFF_DISK = "echo 0 > /sys/bus/pci/slots/%s/power";
    private static final String POWER_ON_DISK = "echo 1 > /sys/bus/pci/slots/%s/power";
    private static final String CACHE_DISK_REPLACE_TYPE = "CACHE_DISK_REPLACE_TYPE";
    private static final Map<Integer, Integer> SLOT_DIR_MAP = new HashMap<Integer, Integer>();

    public List<String> restartNvmeDisk(FruTasksEnv env) throws ToolException {
        ModuleData oldDisk = env.getData();
        ModuleData newDisk = env.getDataAfterReplace();
        log.info("restartNvmeDisk with oldDisk : {} , newDisk : {}", (Object)JSON.toJSONString((Object)oldDisk), (Object)JSON.toJSONString((Object)newDisk));
        String replaceType = env.getEnv().getOrDefault(CACHE_DISK_REPLACE_TYPE, "OFFLINE").toString();
        log.info("replaceType : {}", (Object)replaceType);
        if (StringUtils.equals((CharSequence)"OFFLINE", (CharSequence)replaceType)) {
            log.info("offline disk is not involved");
            return this.getNotInvolvedTaskResult();
        }
        DevNode devNode = env.getDswareNode();
        ICliConnection sshConnection = SshConnectionManager.getSshConnection((DevNode)devNode);
        String result = sshConnection.execCmd(QUERY_NVME_DISK_INFO_COMMAND);
        List<NvmeDiskInfo> nvmeDiskInfos = this.parseNvmeDiskInfo(result);
        if (CollectionUtils.isEmpty(nvmeDiskInfos)) {
            log.error("Query Nvme disk info error");
            return this.getFailedTaskResult(ResourceUtil.getString((String)"not.found.nvme.disk.info"));
        }
        for (NvmeDiskInfo var : nvmeDiskInfos) {
            this.setTimeAndReStart(var, sshConnection);
        }
        return this.getSuccessTaskResult();
    }

    private void setTimeAndReStart(NvmeDiskInfo nvmeDiskInfo, ICliConnection sshConnection) throws ToolException {
        sshConnection.execCmd(String.format(SET_TIME_COMMAND, nvmeDiskInfo.getDevSign()));
        sshConnection.execCmd(String.format(POWER_OFF_DISK, SLOT_DIR_MAP.get(nvmeDiskInfo.getSlotNo())));
        sshConnection.execCmd(String.format(POWER_ON_DISK, SLOT_DIR_MAP.get(nvmeDiskInfo.getSlotNo())));
    }

    private List<NvmeDiskInfo> parseNvmeDiskInfo(String result) {
        if (StringUtils.isEmpty((CharSequence)result)) {
            return Collections.emptyList();
        }
        String[] split = StringUtils.split((String)result, (String)"\n");
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : split) {
            if (!StringUtils.contains((CharSequence)line, (CharSequence)"disk_sn=")) continue;
            lines.add(line.trim());
        }
        return lines.stream().map(NvmeDiskInfo::build).filter(Optional::isPresent).filter(Objects::nonNull).map(Optional::get).filter(var -> var.getDiskType() == 8).collect(Collectors.toList());
    }

    static {
        SLOT_DIR_MAP.put(0, 2);
        SLOT_DIR_MAP.put(1, 1);
        SLOT_DIR_MAP.put(2, 12);
        SLOT_DIR_MAP.put(3, 11);
    }
}

