/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.service.fusioncube.executor;

import com.huawei.ism.tool.distributed.fru.service.fusioncube.executor.CommandException;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.EnumSet;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.util.io.IoUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InteractiveRemoteShellExecutor
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(InteractiveRemoteShellExecutor.class);
    private static final String DEFAULT_LINE_SEPARATOR = IoUtils.EOL;
    private final PipedInputStream pis;
    private final PipedOutputStream pos = new PipedOutputStream();
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final ByteArrayOutputStream err = new ByteArrayOutputStream();
    private final ChannelShell shellChannel;
    private final Duration duration;

    public InteractiveRemoteShellExecutor(ChannelShell shellChannel, Duration duration) throws IOException {
        this.pis = new PipedInputStream(this.pos);
        this.duration = duration;
        this.shellChannel = shellChannel;
        this.shellChannel.setPtyType("vt220");
        this.shellChannel.setUsePty(true);
        this.shellChannel.setIn((InputStream)this.pis);
        this.shellChannel.setOut((OutputStream)this.out);
        this.shellChannel.setErr((OutputStream)this.err);
        this.shellChannel.open().verify(Duration.ofSeconds(5L), new CancelOption[0]);
    }

    public InteractiveRemoteShellExecutor(ChannelShell shellChannel) throws IOException {
        this(shellChannel, Duration.ofMillis(200L));
    }

    public InteractiveRemoteShellExecutor command(String command) {
        return this.command(command, DEFAULT_LINE_SEPARATOR);
    }

    public InteractiveRemoteShellExecutor command(String command, String lineSep) {
        this.write(this.pos, command, lineSep);
        return this;
    }

    public String expected(String ... expected) {
        return this.expected(this.duration, expected);
    }

    public String expected(Duration duration, String ... expected) {
        String output = this.readAvailable(duration);
        if (!StringUtils.isAllEmpty((CharSequence[])expected) && !StringUtils.containsAnyIgnoreCase((CharSequence)output, (CharSequence[])expected)) {
            throw new CommandException("Expected error");
        }
        return output;
    }

    public InteractiveRemoteShellExecutor input(String interactiveInfo) {
        this.write(this.pos, interactiveInfo, DEFAULT_LINE_SEPARATOR);
        return this;
    }

    public InteractiveRemoteShellExecutor input(String interactiveInfo, String lineSep) {
        this.write(this.pos, interactiveInfo, lineSep);
        return this;
    }

    public String getOutput() {
        return this.getOutput(this.duration);
    }

    public String getOutput(Duration duration) {
        return this.readAvailable(duration);
    }

    public void releasePipedStream() {
        this.releasePipedStream(this.duration);
    }

    public void releasePipedStream(Duration duration) {
        this.readAvailable(duration);
    }

    @Override
    public void close() throws IOException {
        if (Objects.nonNull(this.pis)) {
            this.pis.close();
        }
        if (Objects.nonNull(this.pos)) {
            this.pos.close();
        }
        if (Objects.nonNull(this.out)) {
            this.out.close();
        }
        if (Objects.nonNull(this.err)) {
            this.err.close();
        }
        if (Objects.nonNull(this.shellChannel)) {
            this.shellChannel.close();
        }
    }

    private void write(PipedOutputStream os, String msg, String lineSep) {
        try {
            os.write((msg + lineSep).getBytes(StandardCharsets.UTF_8));
            os.flush();
        }
        catch (IOException e) {
            log.error("Write inner command exception:", (Throwable)e);
            throw new CommandException("Write inner command exception.");
        }
    }

    private String readAvailable(Duration duration) {
        this.shellChannel.waitFor(EnumSet.of(ClientChannelEvent.STDOUT_DATA), duration);
        String outPut = this.out.toString();
        this.out.reset();
        return outPut;
    }
}

