/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.service.fusioncube.executor;

import com.huawei.ism.tool.distributed.fru.service.fusioncube.executor.SshHostKeyTo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.sshd.client.config.hosts.KnownHostEntry;
import org.apache.sshd.client.keyverifier.KnownHostsServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ModifiedServerKeyAcceptor;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshKeyServerKeyVerifier
implements ServerKeyVerifier,
ModifiedServerKeyAcceptor {
    private static final Logger log = LoggerFactory.getLogger(SshKeyServerKeyVerifier.class);
    private final ServerKeyVerifier delegate;
    private final SshHostKeyTo sshHostKeyTo;
    private ModifiedServerKeyAcceptor modKeyAcceptor;

    public SshKeyServerKeyVerifier(ServerKeyVerifier delegate, SshHostKeyTo sshHostKeyTo) {
        this.delegate = delegate;
        this.sshHostKeyTo = sshHostKeyTo;
    }

    public boolean acceptModifiedServerKey(ClientSession clientSession, SocketAddress remoteAddress, KnownHostEntry entry, PublicKey expected, PublicKey actual) throws Exception {
        ModifiedServerKeyAcceptor acceptor = this.getModKeyAcceptor();
        if (acceptor != null) {
            return acceptor.acceptModifiedServerKey(clientSession, remoteAddress, entry, expected, actual);
        }
        return false;
    }

    public boolean verifyServerKey(ClientSession clientSession, SocketAddress remoteAddress, PublicKey serverKey) {
        try {
            List<KnownHostsServerKeyVerifier.HostEntryPair> knowHostKeyPairs = this.getHostEntryPairs(clientSession, this.sshHostKeyTo);
            Optional<KnownHostsServerKeyVerifier.HostEntryPair> match = this.findKnowHostEntry(clientSession, remoteAddress, knowHostKeyPairs);
            if (!match.isPresent()) {
                log.info("The ssh request HostKey was not in the database. Let's check if accept unknown host key.");
                return false;
            }
            KnownHostEntry queryKnownHostEntry = match.get().getHostEntry();
            PublicKey expected = match.get().getServerKey();
            if (KeyUtils.compareKeys((PublicKey)expected, (PublicKey)serverKey)) {
                return this.acceptKnownHostEntry(clientSession, remoteAddress, serverKey, queryKnownHostEntry);
            }
        }
        catch (FileNotFoundException e) {
            log.error("verifyServerKey method may have file not found");
        }
        catch (IOException | GeneralSecurityException e) {
            log.error("verifyServerKey error: ", (Throwable)e);
        }
        return false;
    }

    private List<KnownHostsServerKeyVerifier.HostEntryPair> getHostEntryPairs(ClientSession clientSession, SshHostKeyTo sshHostKeyTo) throws GeneralSecurityException, IOException {
        KnownHostEntry knownHostEntry;
        ArrayList<KnownHostsServerKeyVerifier.HostEntryPair> knowHostKeyPairs = new ArrayList<KnownHostsServerKeyVerifier.HostEntryPair>();
        if (sshHostKeyTo != null && (knownHostEntry = KnownHostEntry.parseKnownHostEntry((String)sshHostKeyTo.getSshHostKey())) != null) {
            AuthorizedKeyEntry authEntry = (AuthorizedKeyEntry)ValidateUtils.checkNotNull((Object)knownHostEntry.getKeyEntry(), (String)"No key extracted from %s", (Object)knownHostEntry);
            PublicKey key = authEntry.resolvePublicKey((SessionContext)clientSession, PublicKeyEntryResolver.IGNORING);
            knowHostKeyPairs.add(new KnownHostsServerKeyVerifier.HostEntryPair(knownHostEntry, key));
        }
        return knowHostKeyPairs;
    }

    protected boolean acceptKnownHostEntry(ClientSession clientSession, SocketAddress remoteAddress, PublicKey serverKey, KnownHostEntry entry) throws IOException {
        if (entry == null) {
            return false;
        }
        if ("revoked".equals(entry.getMarker())) {
            log.debug("acceptKnownHostEntry({})[{}] key={}-{} marked as {}", new Object[]{clientSession, remoteAddress, KeyUtils.getKeyType((Key)serverKey), KeyUtils.getFingerPrint((PublicKey)serverKey), entry.getMarker()});
            return false;
        }
        return true;
    }

    private Optional<KnownHostsServerKeyVerifier.HostEntryPair> findKnowHostEntry(ClientSession clientSession, SocketAddress remoteAddress, List<KnownHostsServerKeyVerifier.HostEntryPair> knowHostKeyPairs) {
        if (CollectionUtils.isEmpty(knowHostKeyPairs)) {
            return Optional.empty();
        }
        TreeSet<SshdSocketAddress> candidates = new TreeSet<SshdSocketAddress>(SshdSocketAddress.BY_HOST_AND_PORT);
        candidates.add(SshdSocketAddress.toSshdSocketAddress((SocketAddress)remoteAddress));
        SocketAddress connectAddress = clientSession.getConnectAddress();
        candidates.add(SshdSocketAddress.toSshdSocketAddress((SocketAddress)connectAddress));
        if (CollectionUtils.isEmpty(candidates)) {
            return Optional.empty();
        }
        for (KnownHostsServerKeyVerifier.HostEntryPair knowHostKeyPair : knowHostKeyPairs) {
            KnownHostEntry hostEntry = knowHostKeyPair.getHostEntry();
            for (SshdSocketAddress candidate : candidates) {
                if (!hostEntry.isHostMatch(candidate.getHostName(), candidate.getPort())) continue;
                return Optional.ofNullable(knowHostKeyPair);
            }
        }
        return Optional.empty();
    }

    public ServerKeyVerifier getDelegate() {
        return this.delegate;
    }

    public SshHostKeyTo getSshHostKeyTo() {
        return this.sshHostKeyTo;
    }

    public ModifiedServerKeyAcceptor getModKeyAcceptor() {
        return this.modKeyAcceptor;
    }

    public void setModKeyAcceptor(ModifiedServerKeyAcceptor modKeyAcceptor) {
        this.modKeyAcceptor = modKeyAcceptor;
    }
}

