/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.service.fusioncube.executor;

import com.huawei.ism.tool.distributed.fru.service.fusioncube.executor.CommandException;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.executor.InteractiveRemoteShellExecutor;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.executor.SessionParameter;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.executor.SshHostKeyTo;
import com.huawei.ism.tool.distributed.fru.service.fusioncube.executor.SshKeyServerKeyVerifier;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.auth.keyboard.UserAuthKeyboardInteractiveFactory;
import org.apache.sshd.client.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.keyverifier.AcceptAllServerKeyVerifier;
import org.apache.sshd.client.keyverifier.RejectAllServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.BuiltinFactory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.kex.BuiltinDHFactories;
import org.apache.sshd.common.mac.BuiltinMacs;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.apache.sshd.sftp.client.fs.SftpPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshdUtil
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(SshdUtil.class);
    private static final Duration DEFAULT_TIMEOUT = Duration.ofMinutes(1L);
    private static final char LINUX_FILE_SEPARATOR = '/';
    private static final int SSH_PORT = 22;
    private final SessionParameter sessionParameter;
    private final SshHostKeyTo sshHostKeyTo;
    private ClientSession session;
    private InteractiveRemoteShellExecutor executor;
    private boolean isInitExecutor;
    private boolean isInitSftpClient;
    private SftpFileSystem fileSystem;

    public SshdUtil(SessionParameter sessionParameter, SshHostKeyTo sshHostKeyTo, boolean isInitExecutor, boolean isInitSftpClient) throws IOException {
        this.sessionParameter = sessionParameter;
        this.sshHostKeyTo = sshHostKeyTo;
        this.session = this.getClientSession();
        this.isInitExecutor = isInitExecutor;
        if (this.isInitExecutor) {
            this.doCreateExecutor();
        }
        this.isInitSftpClient = isInitSftpClient;
        if (this.isInitSftpClient) {
            this.doCreateFileSystem();
        }
    }

    private void doCreateFileSystem() throws IOException {
        if (Objects.nonNull(this.session)) {
            this.fileSystem = SftpClientFactory.instance().createSftpFileSystem(this.session);
        }
    }

    private void doCreateExecutor() throws IOException {
        if (this.session != null) {
            ChannelShell shell = this.session.createShellChannel();
            this.executor = new InteractiveRemoteShellExecutor(shell);
        }
    }

    private SshClient generateSshClient() {
        SshClient sshClient = SshClient.setUpDefaultClient();
        ArrayList<Object> userAuthFactories = new ArrayList<Object>();
        userAuthFactories.add(UserAuthPasswordFactory.INSTANCE);
        userAuthFactories.add(UserAuthKeyboardInteractiveFactory.INSTANCE);
        sshClient.setUserAuthFactories(userAuthFactories);
        sshClient.start();
        if (Objects.nonNull(this.sshHostKeyTo) && this.sshHostKeyTo.getIsVerifySshHostKey().booleanValue()) {
            log.info("The public key acknowledgment switch was on");
            log.info("Remote host was {}, port was {}", (Object)this.sessionParameter.getIp(), (Object)this.sessionParameter.getPort());
            sshClient.setServerKeyVerifier((ServerKeyVerifier)new SshKeyServerKeyVerifier((ServerKeyVerifier)RejectAllServerKeyVerifier.INSTANCE, this.sshHostKeyTo));
        } else {
            log.info("The public key acknowledgment switch was off");
            sshClient.setServerKeyVerifier((ServerKeyVerifier)AcceptAllServerKeyVerifier.INSTANCE);
        }
        return sshClient;
    }

    private ClientSession getClientSession() throws IOException {
        SshClient sshClient = this.generateSshClient();
        this.setKey(sshClient);
        ClientSession clientSession = (ClientSession)((ConnectFuture)sshClient.connect(this.sessionParameter.getUsername(), this.sessionParameter.getIp(), this.sessionParameter.getPort() == 0 ? 22 : this.sessionParameter.getPort()).verify(DEFAULT_TIMEOUT, new CancelOption[0])).getSession();
        if (StringUtils.isNotEmpty((CharSequence)this.sessionParameter.getPassword())) {
            clientSession.addPasswordIdentity(this.sessionParameter.getPassword());
        }
        clientSession.auth().verify(DEFAULT_TIMEOUT, new CancelOption[0]);
        return clientSession;
    }

    private void setKey(SshClient sshClient) {
        BuiltinDHFactories.ParseResult keyExchangeResult = BuiltinDHFactories.parseDHFactoriesList((String)BuiltinDHFactories.VALUES.stream().map(BuiltinDHFactories::getName).collect(Collectors.joining(",")));
        List keyExchangeFactories = NamedFactory.setUpTransformedFactories((boolean)false, (Collection)keyExchangeResult.getParsedFactories(), (Function)ClientBuilder.DH2KEX);
        sshClient.setKeyExchangeFactories(keyExchangeFactories);
        BuiltinSignatures.ParseResult signatureResult = BuiltinSignatures.parseSignatureList((String)BuiltinSignatures.VALUES.stream().map(BuiltinSignatures::getName).collect(Collectors.joining(",")));
        List signatureFactories = BuiltinFactory.setUpFactories((boolean)false, (Collection)signatureResult.getParsedFactories());
        sshClient.setSignatureFactories(signatureFactories);
        BuiltinMacs.ParseResult macResult = BuiltinMacs.parseMacsList((String)BuiltinMacs.VALUES.stream().map(BuiltinMacs::getName).collect(Collectors.joining(",")));
        List macFactories = BuiltinFactory.setUpFactories((boolean)false, (Collection)macResult.getParsedFactories());
        sshClient.setMacFactories(macFactories);
    }

    public static SshdUtil getSshdUtil(SessionParameter sessionParameter, SshHostKeyTo sshHostKeyTo, boolean isInitExecutor) {
        try {
            return new SshdUtil(sessionParameter, sshHostKeyTo, isInitExecutor, false);
        }
        catch (IOException e) {
            log.error("getSshdUtil fail : ", (Throwable)e);
            throw new CommandException(e.getMessage());
        }
    }

    public static SshdUtil getSftpUtil(SessionParameter sessionParameter) {
        try {
            return new SshdUtil(sessionParameter, null, false, true);
        }
        catch (IOException e) {
            log.error("getSftpUtil fail : ", (Throwable)e);
            throw new CommandException(e.getMessage());
        }
    }

    public String execute(String command) {
        return this.execute(command, Duration.ofMillis(200L));
    }

    public String executeWithLog(String command) {
        log.info("Execute cmd: {}", (Object)command);
        String res = this.execute(command);
        log.info("Response is: \n {}", (Object)res);
        return res;
    }

    public String execute(String command, Duration duration) {
        return this.execute(command, duration, "");
    }

    public String execute(String command, String ... expected) {
        return this.execute(command, Duration.ofMillis(200L), expected);
    }

    public String execute(String command, Duration duration, String ... expected) {
        if (Objects.isNull(this.session) || Objects.isNull(this.executor)) {
            throw new IllegalArgumentException("session is null");
        }
        this.executor.releasePipedStream();
        this.executor.command(command);
        return this.executor.expected(duration, expected);
    }

    public void downloadByFileName(String remoteFolder, String fileName, String localFolder) throws IOException {
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{remoteFolder, fileName})) {
            log.error("Remote path was empty.");
            throw new IllegalArgumentException("Remote path was empty.");
        }
        if (Objects.isNull(this.fileSystem)) {
            log.error("fileSystem is null");
            throw new IllegalArgumentException("fileSystem is null.");
        }
        Path local = Paths.get(this.resolveLocalPath(localFolder), new String[0]).normalize().toAbsolutePath();
        SftpPath remoteDir = (SftpPath)((SftpPath)((SftpPath)this.fileSystem.getPath(remoteFolder, new String[0])).normalize()).toAbsolutePath();
        if (!Files.exists((Path)remoteDir, new LinkOption[0])) {
            throw new IllegalArgumentException("Remote path was not exist.");
        }
        this.checkLocalPath(local, remoteDir);
        try (Stream<Path> stream = Files.walk((Path)remoteDir, 1, new FileVisitOption[0]);){
            List matchFiles = stream.filter(Files::isReadable).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> StringUtils.contains((CharSequence)file.getFileName().toString(), (CharSequence)fileName)).collect(Collectors.toList());
            for (Path path : matchFiles) {
                this.download(path.toString(), localFolder + File.separator + path.getFileName());
            }
        }
        catch (FileNotFoundException e) {
            log.error("remote path {} not exist ", (Object)remoteDir);
        }
        catch (IOException e) {
            log.error("remote path {} read error", (Object)remoteDir, (Object)e);
        }
    }

    public void download(String remotePath, String localPath) throws IOException {
        if (StringUtils.isEmpty((CharSequence)remotePath)) {
            log.error("Remote path was empty.");
            throw new IllegalArgumentException("Remote path was empty.");
        }
        if (Objects.isNull(this.fileSystem)) {
            log.error("fileSystem is null");
            throw new IllegalArgumentException("fileSystem is null.");
        }
        Path local = Paths.get(this.resolveLocalPath(localPath), new String[0]).normalize().toAbsolutePath();
        SftpPath remote = (SftpPath)((SftpPath)((SftpPath)this.fileSystem.getPath(remotePath, new String[0])).normalize()).toAbsolutePath();
        if (!Files.exists((Path)remote, new LinkOption[0])) {
            log.error("remote file is not exist");
            return;
        }
        this.checkLocalPath(local, remote);
        if (Files.isRegularFile((Path)remote, new LinkOption[0])) {
            Files.copy((Path)remote, local, StandardCopyOption.REPLACE_EXISTING);
        } else {
            this.transferRemoteDir(local, this.fileSystem, remote);
        }
    }

    private void checkLocalPath(Path local, SftpPath remote) {
        if (Files.isDirectory((Path)remote, new LinkOption[0]) && Files.exists(local, new LinkOption[0]) && Files.isRegularFile(local, new LinkOption[0])) {
            throw new IllegalArgumentException("Error remote path.The local path was file.But remote path was dir.");
        }
    }

    private String resolveLocalPath(String localPath) {
        String userHome = System.getProperty("user.home");
        if (GenericUtils.isEmpty((CharSequence)localPath)) {
            return userHome;
        }
        if (OsUtils.isWin32() ? localPath.length() >= 2 && localPath.charAt(1) == ':' : localPath.charAt(0) == '/') {
            return localPath;
        }
        return userHome + File.separator + localPath.replace('/', File.separatorChar);
    }

    private void transferRemoteDir(Path local, SftpFileSystem fileSystem, SftpPath remoteDir) throws IOException {
        if (Files.isDirectory((Path)remoteDir, new LinkOption[0])) {
            try (DirectoryStream<Path> paths = Files.newDirectoryStream((Path)remoteDir);){
                Files.createDirectories(local, new FileAttribute[0]);
                for (Path path : paths) {
                    String fileName = path.getFileName().toString();
                    Path localPath = local.resolve(fileName);
                    this.transferRemoteDir(localPath, fileSystem, (SftpPath)fileSystem.getPath(remoteDir.toString() + '/' + fileName, new String[0]));
                }
            }
        } else if (Files.isRegularFile((Path)remoteDir, new LinkOption[0])) {
            Files.copy((Path)remoteDir, local, StandardCopyOption.REPLACE_EXISTING);
        } else {
            log.info("Other file was skipped.");
        }
    }

    @Override
    public void close() throws IOException {
        if (Objects.nonNull(this.executor)) {
            this.executor.close();
        }
        if (Objects.nonNull(this.fileSystem) && this.fileSystem.isOpen()) {
            this.fileSystem.close();
        }
        if (Objects.nonNull(this.session) && this.session.isOpen()) {
            this.session.close();
        }
    }

    public SessionParameter getSessionParameter() {
        return this.sessionParameter;
    }

    public SshHostKeyTo getSshHostKeyTo() {
        return this.sshHostKeyTo;
    }

    public ClientSession getSession() {
        return this.session;
    }

    public InteractiveRemoteShellExecutor getExecutor() {
        return this.executor;
    }

    public boolean isInitExecutor() {
        return this.isInitExecutor;
    }

    public boolean isInitSftpClient() {
        return this.isInitSftpClient;
    }

    public SftpFileSystem getFileSystem() {
        return this.fileSystem;
    }
}

