/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.service.parser;

import com.huawei.ism.tool.distributed.fru.model.entity.doc.DocConf;
import com.huawei.ism.tool.distributed.fru.model.entity.doc.DocRoute;
import com.huawei.ism.tool.distributed.fru.model.entity.doc.ItemDocConf;
import com.huawei.ism.tool.distributed.fru.model.entity.doc.ModuleDocConf;
import com.huawei.ism.tool.distributed.fru.service.parser.IXmlParser;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocRouteParser
implements IXmlParser<Optional<DocRoute>> {
    private static final Logger log = LoggerFactory.getLogger(DocRouteParser.class);
    public static final DocRouteParser INS = new DocRouteParser();
    private static final String PRODUCT_ENUM_XPATH = "root/productEnum/enum";
    private static final String DOC_ROUTE_XPATH = "root/docs/doc";
    private static final String ITEM_DOC_XPATH = "root/itemDocs/itemDoc";
    private static final String TAG_ARG_ID = "id";
    private static final String TAG_ARG_LINK_EN = "linkEn";
    private static final String TAG_ARG_LINK_ZH = "linkZh";
    private static final String TAG_ARG_ROOT_DIR = "rootDir";
    private static final String TAG_ARG_SERVER = "server";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<DocRoute> parse(@NotNull File docRouteFile) {
        try (FileInputStream fio = new FileInputStream(docRouteFile);){
            Document doc = XmlUtils.parseDocument((InputStream)fio);
            Optional<DocRoute> optional = Optional.of(new DocRoute(this.parseModuleDocsConf(doc, this.initProductEnum(doc)), this.parseItemGuides(doc)));
            return optional;
        }
        catch (IOException e) {
            log.error("Parse module doc route failed.");
            return Optional.empty();
        }
    }

    private List<ItemDocConf> parseItemGuides(Document doc) {
        NodeList itemDocs = XmlUtils.searchNodeByExp((Document)doc, (String)ITEM_DOC_XPATH);
        if (itemDocs == null) {
            log.warn("product item doc not exist");
            return Collections.emptyList();
        }
        return IntStream.range(0, itemDocs.getLength()).mapToObj(itemDocs::item).filter(itemDoc -> itemDoc instanceof Element).map(itemDoc -> (Element)itemDoc).map(this::generateItemDocConf).collect(Collectors.toList());
    }

    private ItemDocConf generateItemDocConf(Element itemDoc) {
        NodeList docs = itemDoc.getChildNodes();
        List<DocConf> docConfs = IntStream.range(0, docs.getLength()).mapToObj(docs::item).filter(doc -> doc instanceof Element).map(doc -> (Element)doc).map(this::generateSingleDocConf).collect(Collectors.toList());
        return new ItemDocConf(itemDoc.getAttribute(TAG_ARG_ID), docConfs);
    }

    private DocConf generateSingleDocConf(Element doc) {
        return DocConf.builder().id(doc.getAttribute(TAG_ARG_ID)).rootDir(doc.getAttribute(TAG_ARG_ROOT_DIR)).linkEn(doc.getAttribute(TAG_ARG_LINK_EN)).linkZh(doc.getAttribute(TAG_ARG_LINK_ZH)).build();
    }

    private Map<String, List<String>> initProductEnum(Document doc) {
        NodeList nodeList = XmlUtils.searchNodeByExp((Document)doc, (String)PRODUCT_ENUM_XPATH);
        if (nodeList == null) {
            log.warn("product enum not exist");
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> enumId2NodeType = new HashMap<String, List<String>>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node enumNode = nodeList.item(i);
            if (!(enumNode instanceof Element)) continue;
            Element enumEle = (Element)enumNode;
            String id = enumEle.getAttribute(TAG_ARG_ID);
            enumId2NodeType.put(id, Arrays.asList(enumEle.getTextContent().trim().split(",")));
        }
        return enumId2NodeType;
    }

    private List<ModuleDocConf> parseModuleDocsConf(Document doc, Map<String, List<String>> enumId2NodeType) {
        NodeList nodeList = XmlUtils.searchNodeByExp((Document)doc, (String)DOC_ROUTE_XPATH);
        if (nodeList == null) {
            log.warn("Doc tag not exist");
        }
        ArrayList<ModuleDocConf> modulesDocConf = new ArrayList<ModuleDocConf>();
        for (int i = 0; i < Objects.requireNonNull(nodeList).getLength(); ++i) {
            Node docNode = nodeList.item(i);
            if (!(docNode instanceof Element)) continue;
            modulesDocConf.add(this.parseDocConf((Element)docNode, enumId2NodeType));
        }
        return modulesDocConf;
    }

    private ModuleDocConf parseDocConf(Element docNode, Map<String, List<String>> enumId2NodeType) {
        String rootDir = docNode.getAttribute(TAG_ARG_ROOT_DIR);
        String id = docNode.getAttribute(TAG_ARG_ID);
        String linkEn = docNode.getAttribute(TAG_ARG_LINK_EN);
        String linkZh = docNode.getAttribute(TAG_ARG_LINK_ZH);
        List<DocConf> serverDocConfList = this.parseServerConf(docNode, enumId2NodeType);
        serverDocConfList.forEach(conf -> conf.setRootDir(rootDir));
        return ModuleDocConf.builder().moduleId(id).rootDir(rootDir).defaultDocConf(DocConf.builder().linkZh(linkZh).linkEn(linkEn).rootDir(rootDir).build()).serversConf(serverDocConfList).build();
    }

    private List<DocConf> parseServerConf(Element docEle, Map<String, List<String>> enumId2NodeType) {
        return XmlUtils.getChildren((Element)docEle, (String)TAG_ARG_SERVER).stream().map(serverEle -> DocConf.builder().id(serverEle.getAttribute(TAG_ARG_ID)).linkEn(serverEle.getAttribute(TAG_ARG_LINK_EN)).linkZh(serverEle.getAttribute(TAG_ARG_LINK_ZH)).supportNodeType(enumId2NodeType.getOrDefault(serverEle.getAttribute(TAG_ARG_ID), Collections.emptyList())).build()).collect(Collectors.toList());
    }
}

