/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.service.parser;

import com.huawei.ism.tool.distributed.fru.model.entity.Product;
import com.huawei.ism.tool.distributed.fru.model.entity.TaskConf;
import com.huawei.ism.tool.distributed.fru.model.module.Module;
import com.huawei.ism.tool.distributed.fru.service.parser.IXmlParser;
import com.huawei.ism.tool.distributed.fru.service.parser.ProductParser;
import com.huawei.ism.tool.distributed.fru.service.parser.TaskConfParser;
import com.huawei.ism.tool.distributed.fru.util.ProductUtil;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.service.rest.model.Either;
import com.huawei.ism.tool.service.rest.model.entity.BaseProduct;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductInitiator {
    private static final Logger log = LoggerFactory.getLogger(ProductInitiator.class);

    public List<Product> init(File rootDir) throws ToolException, IOException {
        Map<String, List<Product>> productRootPath2Products = this.initProducts(rootDir);
        TaskConfParser processParser = new TaskConfParser();
        ((Stream)productRootPath2Products.keySet().stream().parallel()).map(productRootPath2Products::get).forEach(products -> this.initAndBindTask2Product((List<Product>)products, processParser));
        return productRootPath2Products.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private Map<String, List<Product>> initProducts(File rootDir) throws IOException {
        ProductParser productParser = new ProductParser();
        return ((List)productParser.parse(rootDir)).stream().collect(Collectors.groupingByConcurrent(BaseProduct::getProductRootPath));
    }

    private boolean initAndBindTask2Product(List<Product> productList, IXmlParser<List<TaskConf>> processParser) {
        ConcurrentMap<String, List<TaskConf>> processesInfos = this.initModuleTaskInfo(processParser, productList);
        productList.forEach(product -> this.bindTaskInfo2Product(processesInfos, (Product)((Object)product)));
        return true;
    }

    private void bindTaskInfo2Product(ConcurrentMap<String, List<TaskConf>> processesInfos, Product product) {
        product.getSupportModules().stream().map(Module::getId).map(processesInfos::get).forEach(taskInfos -> product.getModuleId2TaskInfoList().put(((TaskConf)taskInfos.get(0)).getModuleId(), (List<TaskConf>)taskInfos));
    }

    private ConcurrentMap<String, List<TaskConf>> initModuleTaskInfo(IXmlParser<List<TaskConf>> processParser, List<Product> productList) {
        ResourceBundle bundle = productList.get(0).getResBundle();
        String rootPath = productList.get(0).getProductRootPath();
        return productList.stream().map(Product::getSupportModules).flatMap(Collection::stream).distinct().map(module -> new File(rootPath, module.getProcessFileName())).map(Either.lift(processParser::parse)).map(Either::getRight).filter(Optional::isPresent).map(Optional::get).flatMap(Collection::stream).peek(taskInfo -> this.initTaskConfRes(bundle, (TaskConf)taskInfo)).collect(Collectors.groupingByConcurrent(TaskConf::getModuleId));
    }

    private void initTaskConfRes(ResourceBundle bundle, TaskConf conf) {
        conf.setName(ProductUtil.INS.getTaskName(bundle, conf));
        conf.setDescription(ProductUtil.INS.getTaskDescription(bundle, conf));
        conf.setSuggestion(ProductUtil.INS.getTaskSuggestion(bundle, conf));
        if (conf.getChildrenConf() != null) {
            conf.getChildrenConf().stream().forEach(subConf -> this.initTaskConfRes(bundle, (TaskConf)subConf));
        }
    }
}

