/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.service.parser;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.distributed.fru.model.entity.Product;
import com.huawei.ism.tool.distributed.fru.model.module.Module;
import com.huawei.ism.tool.distributed.fru.service.parser.IXmlParser;
import com.huawei.ism.tool.distributed.fru.util.ProductUtil;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import com.huawei.ism.tool.service.rest.model.Either;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProductParser
implements IXmlParser {
    private static final Logger log = LoggerFactory.getLogger(ProductParser.class);
    private static final String PRODUCT_XML = "products.xml";
    private static final String SUPPORT_MODEL_TAG = "productName";
    private static final String SUPPORT_VERSION_TAG = "supportTypes";
    private static final String SUPPORT_SCENARIO_INFO_TAG = "scenarioInfo";
    private static final String SUPPORT_MODULES_TAG = "supportModules/module";
    private static final String PRODUCT_XPATH = "products/product";
    private final String curLang = ApplicationContext.getInstance().getCurrentLanguage().getLanguage();
    private final String resFileName = String.format(Locale.ENGLISH, "resource_%s.properties", this.curLang);

    public List<Product> parse(@NotNull File rootDir) {
        File[] productDirs = rootDir.listFiles();
        if (productDirs == null) {
            log.warn("Current package dir {} 's sub dir is null", (Object)rootDir);
            return Collections.emptyList();
        }
        return ((Stream)Arrays.stream(productDirs).filter(File::isDirectory).parallel()).map(Either.lift(this::parseProducts)).filter(Either::isRight).map(Either::getRight).map(Optional::get).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Product> parseProducts(File productDir) throws IOException {
        File resDir = new File(productDir, "res");
        if (!resDir.exists()) {
            log.warn("Current package dir {} 's res dir is not exist.", (Object)productDir);
            return Collections.emptyList();
        }
        File productFile = new File(productDir, PRODUCT_XML);
        ArrayList<Product> products = new ArrayList<Product>();
        PropertyResourceBundle bundle = this.initRes(productDir);
        try (FileInputStream fio = new FileInputStream(productFile);){
            Document doc = XmlUtils.parseDocument((InputStream)fio);
            NodeList nodeList = XmlUtils.searchNodeByExp((Document)doc, (String)PRODUCT_XPATH);
            if (nodeList == null) {
                log.warn("Product.xml not exist");
                List<Product> list = Collections.emptyList();
                return list;
            }
            String productRootPath = FilePathUtils.getCanonicalPath((File)productDir);
            int i = 0;
            while (i < nodeList.getLength()) {
                Node node = nodeList.item(i);
                if (node instanceof Element) {
                    products.addAll(this.parseOneProductConfig(productRootPath, (Element)node, bundle));
                }
                ++i;
            }
            return products;
        }
        catch (FileNotFoundException e) {
            log.warn("Product.xml not exist");
            return Collections.emptyList();
        }
    }

    private PropertyResourceBundle initRes(File productDir) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(new File(productDir, "res" + File.separator + this.resFileName).toPath(), new OpenOption[0]));){
            PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(bis);
            return propertyResourceBundle;
        }
    }

    private List<Product> parseOneProductConfig(String productRootPath, Element productEle, ResourceBundle bundle) {
        String supportModel = XmlUtils.getChild((Element)productEle, (String)SUPPORT_MODEL_TAG).getTextContent().trim();
        String supportVersion = XmlUtils.getChild((Element)productEle, (String)SUPPORT_VERSION_TAG).getTextContent().trim();
        Element scenarioInfoChild = XmlUtils.getChild((Element)productEle, (String)SUPPORT_SCENARIO_INFO_TAG);
        List<Object> scenarioInfos = Collections.emptyList();
        if (scenarioInfoChild != null) {
            scenarioInfos = Arrays.asList(scenarioInfoChild.getTextContent().trim().split(","));
        }
        List<Module> modules = this.initModules(productEle, bundle);
        List finalScenarioInfos = scenarioInfos;
        return Arrays.stream(supportVersion.split(",")).map(version -> ((Product.ProductBuilder)((Object)((Object)((Product.ProductBuilder)((Object)((Object)((Product.ProductBuilder)((Product.ProductBuilder)((Product.ProductBuilder)((Product.ProductBuilder)Product.builder().productModel(supportModel)).productRootPath(productRootPath)).productVersion(version.trim())).resBundle(bundle)).supportModules(modules)))).scenarioInfos(finalScenarioInfos)))).build()).collect(Collectors.toList());
    }

    private List<Module> initModules(Element productEle, ResourceBundle bundle) {
        NodeList nodeList = XmlUtils.searchNodeByExp((Element)productEle, (String)SUPPORT_MODULES_TAG);
        ArrayList<Module> modules = new ArrayList<Module>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element moduleEle = (Element)node;
            String id = moduleEle.getAttribute("id");
            String processFile = moduleEle.getAttribute("process");
            modules.add(Module.builder().id(id).name(ProductUtil.INS.getModuleName(bundle, id)).processFileName(processFile).build());
        }
        return modules;
    }
}

