/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.service.parser;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.distributed.fru.model.entity.TaskConf;
import com.huawei.ism.tool.distributed.fru.model.enumz.TaskType;
import com.huawei.ism.tool.distributed.fru.service.parser.IXmlParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TaskConfParser
implements IXmlParser {
    private static final Logger log = LoggerFactory.getLogger(TaskConfParser.class);
    private static final String PROCESS_XPATH = "processes/process";
    private static final String STEP_TAG = "step";
    private static final String ITEM_TAG = "item";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<TaskConf> parse(@NotNull File file) throws IOException {
        try (FileInputStream fio = new FileInputStream(file);){
            Document doc = XmlUtils.parseDocument((InputStream)fio);
            List<TaskConf> list = this.parseProcess(doc, file.getParent());
            return list;
        }
        catch (FileNotFoundException e) {
            log.error("Task conf {} do not exist.", (Object)file.getName());
            throw new IOException("Parse task conf error.");
        }
        catch (Exception e) {
            log.error("Parse task conf {} error.", (Object)file.getName(), (Object)e);
        }
        throw new IOException("Parse task conf error.");
    }

    private List<TaskConf> parseProcess(Document doc, String modulePath) {
        String moduleId = this.getAttributeOrDefault(doc.getDocumentElement(), "id", "");
        NodeList nodeList = XmlUtils.searchNodeByExp((Document)doc, (String)PROCESS_XPATH);
        ArrayList<TaskConf> processInfos = new ArrayList<TaskConf>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            TaskConf processInfo = this.buildTaskInfo(element);
            processInfo.setLevel("process");
            processInfo.setModuleId(moduleId);
            processInfo.setResourceKey(String.join((CharSequence)".", moduleId, processInfo.getLevel(), processInfo.getId()));
            processInfo.setChildrenConf(this.parseStep(element, moduleId, modulePath + File.separator + ITEM_TAG));
            processInfos.add(processInfo);
        }
        return processInfos;
    }

    private List<TaskConf> parseStep(Element root, String moduleId, String itemPath) {
        NodeList nodeList = XmlUtils.searchNodeByExp((Element)root, (String)STEP_TAG);
        ArrayList<TaskConf> stepInfos = new ArrayList<TaskConf>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            TaskConf stepInfo = this.buildTaskInfo(element);
            stepInfo.setLevel(STEP_TAG);
            stepInfo.setResourceKey(String.join((CharSequence)".", moduleId, stepInfo.getLevel(), stepInfo.getId()));
            stepInfo.setChildrenConf(this.parseItem(element, itemPath));
            stepInfos.add(stepInfo);
        }
        return stepInfos;
    }

    private List<TaskConf> parseItem(Element root, String itemPath) {
        NodeList nodeList = XmlUtils.searchNodeByExp((Element)root, (String)ITEM_TAG);
        ArrayList<TaskConf> itemInfos = new ArrayList<TaskConf>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            TaskConf taskConf = this.buildTaskInfo(element);
            taskConf.setLevel(ITEM_TAG);
            if ("execute".equals(taskConf.getExecuteMethod())) {
                taskConf.setResourceKey(String.join((CharSequence)".", taskConf.getLevel(), taskConf.getId()));
            } else {
                taskConf.setResourceKey(String.join((CharSequence)".", taskConf.getLevel(), taskConf.getId(), taskConf.getExecuteMethod()));
            }
            taskConf.setScriptPath(itemPath);
            itemInfos.add(taskConf);
        }
        return itemInfos;
    }

    private TaskConf buildTaskInfo(Element element) {
        return TaskConf.builder().id(this.getAttributeOrDefault(element, "id", "")).executeMethod(this.getAttributeOrDefault(element, "executeMethod", "execute")).type(TaskType.of(this.getAttributeOrDefault(element, "type", ""))).preFilters(this.parseFilter(element, "filter")).postFilters(this.parseFilter(element, "postFilter")).showTimeAlarm(Boolean.parseBoolean(this.getAttributeOrDefault(element, "showTimeAlarm", "false"))).recommendTime(Integer.parseInt(this.getAttributeOrDefault(element, "recommendTime", "3"))).supportIgnore(Boolean.parseBoolean(this.getAttributeOrDefault(element, "supportIgnore", "false"))).build();
    }

    private List<String> parseFilter(Element element, String filterType) {
        String filters = this.getAttributeOrDefault(element, filterType, "");
        if (StringUtils.isNULLStr((String)filters)) {
            return Collections.emptyList();
        }
        return Arrays.asList(filters.split(","));
    }

    private String getAttributeOrDefault(Element element, String key, String defaultValue) {
        Optional<Node> node = Optional.ofNullable(element.getAttributes().getNamedItem(key));
        if (node.isPresent()) {
            return node.get().getNodeValue();
        }
        return defaultValue;
    }
}

