/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.service.task;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.distributed.fru.common.Constants;
import com.huawei.ism.tool.distributed.fru.model.entity.FruDevice;
import com.huawei.ism.tool.distributed.fru.model.entity.TaskConf;
import com.huawei.ism.tool.distributed.fru.model.entity.TaskDetailInfo;
import com.huawei.ism.tool.distributed.fru.model.entity.vo.TaskReqInfoVO;
import com.huawei.ism.tool.distributed.fru.model.enumz.Status;
import com.huawei.ism.tool.distributed.fru.service.task.FruTasksEnv;
import com.huawei.ism.tool.distributed.fru.service.task.ITaskFilter;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicTask
extends Observable
implements Observer {
    private static final Logger log = LoggerFactory.getLogger(BasicTask.class);
    protected Status status = Status.WAITING;
    protected double progress = 0.0;
    protected String description;
    protected String suggestion;
    protected List<ITaskFilter<FruDevice, BasicTask>> preFilters = new ArrayList<ITaskFilter<FruDevice, BasicTask>>();
    protected List<ITaskFilter<FruDevice, BasicTask>> backFilters = new ArrayList<ITaskFilter<FruDevice, BasicTask>>();
    protected TaskConf taskConf;
    protected String beginTime = "";
    protected String endTime = "";
    protected boolean ignoreExecute = false;
    protected FruTasksEnv env;
    protected TaskDetailInfo detailInfo;
    protected String currentSubItemId;
    protected List<? extends BasicTask> children;
    protected String resultJson;

    protected BasicTask(FruTasksEnv env, TaskConf info) {
        this.env = env;
        this.taskConf = info;
    }

    public void init(TaskReqInfoVO info) {
        if (info == null) {
            this.initAll();
        } else {
            this.initTarget(info);
        }
    }

    protected void init() {
        this.progress = 0.0;
        this.status = Status.WAITING;
        this.description = "";
        this.suggestion = "";
        this.currentSubItemId = "";
        this.endTime = "";
        this.syncData2StatusInfo();
    }

    protected void initAll() {
        this.init();
        if (null != this.children) {
            this.children.forEach(BasicTask::initAll);
        }
    }

    protected void initTarget(TaskReqInfoVO info) {
        throw new AbstractMethodError("should impl this method.");
    }

    public boolean isFinished() {
        return this.isSuccess() || this.isFailed();
    }

    public boolean isSuccess() {
        return Arrays.asList(Status.PASS, Status.SUCCESS, Status.NOT_INVOLVED, Status.IGNORE, Status.ALREADY_CONFIRM).contains((Object)this.status);
    }

    public boolean isFailed() {
        return Arrays.asList(Status.NOT_PASS, Status.FAILED).contains((Object)this.status);
    }

    public boolean isWaitingConfirm() {
        return this.status == Status.WAITING_CONFIRM;
    }

    public boolean isRunning() {
        return Arrays.asList(Status.RUNNING, Status.WAITING_CONFIRM).contains((Object)this.status);
    }

    public boolean isWaiting() {
        return Status.WAITING.equals((Object)this.status);
    }

    public boolean filter(List<String> filters) {
        return filters.stream().map(Constants.FilterRoute::findFilter).allMatch(filter -> {
            boolean result = filter.filter(this.env.getFruDevice(), this);
            if (!result) {
                log.info("Hit filter {} .", (Object)filter.getClass().getSimpleName());
            }
            return result;
        });
    }

    public boolean next() {
        return false;
    }

    @Override
    public void update(Observable obs, Object arg) {
        this.updateProgress();
        this.updateStatus();
        this.updateDescription();
        this.notifyObs();
    }

    public boolean execute() throws ToolException {
        throw new AbstractMethodError("Sub-class should impl this method.");
    }

    boolean canNotExecute() {
        return !Status.WAITING.equals((Object)this.status);
    }

    protected void notifyObs() {
        this.syncData2StatusInfo();
        this.setChanged();
        this.notifyObservers();
    }

    protected String getTime() {
        return StringUtils.formatDate((Object)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
    }

    private synchronized void syncData2StatusInfo() {
        this.detailInfo = TaskDetailInfo.builder().beginTime(this.beginTime).endTime(this.endTime).progress(this.progress).description(this.description).suggestion(this.suggestion).status(this.status).resultJson(this.resultJson).currentSubItemId(this.currentSubItemId).build();
    }

    protected void updateProgress() {
        if (this.children == null || this.children.isEmpty()) {
            return;
        }
        this.progress = this.children.stream().mapToDouble(BasicTask::getProgress).sum() / (double)this.children.size();
    }

    protected void updateDescription() {
        if (CollectionUtil.isEmpty(this.children)) {
            return;
        }
        if (this.children.size() == 1) {
            this.description = this.children.get((int)0).description;
        }
    }

    protected void updateStatus() {
        if (this.children == null) {
            return;
        }
        if (this.children.stream().allMatch(BasicTask::isSuccess)) {
            this.status = Status.SUCCESS;
            return;
        }
        if (this.isFailedByChildren()) {
            this.status = Status.FAILED;
            return;
        }
        if (this.children.stream().anyMatch(BasicTask::isRunning)) {
            this.status = Status.RUNNING;
            return;
        }
        if (this.children.stream().allMatch(BasicTask::isWaiting)) {
            this.status = Status.WAITING;
            return;
        }
        if (this.children.stream().allMatch(task -> task.isSuccess() || task.isWaiting())) {
            this.status = Status.RUNNING;
            return;
        }
    }

    protected boolean isFailedByChildren() {
        return this.children.stream().anyMatch(BasicTask::isFailed);
    }

    public Optional<? extends BasicTask> findChildTaskById(String id) {
        if (this.children == null) {
            return Optional.empty();
        }
        return this.children.stream().filter((? super T childTask) -> childTask.getTaskConf().getId().equals(id)).findFirst();
    }

    BasicTask() {
    }

    public double getProgress() {
        return this.progress;
    }

    public List<ITaskFilter<FruDevice, BasicTask>> getPreFilters() {
        return this.preFilters;
    }

    public List<ITaskFilter<FruDevice, BasicTask>> getBackFilters() {
        return this.backFilters;
    }

    public TaskConf getTaskConf() {
        return this.taskConf;
    }

    public void setIgnoreExecute(boolean ignoreExecute) {
        this.ignoreExecute = ignoreExecute;
    }

    public boolean isIgnoreExecute() {
        return this.ignoreExecute;
    }

    public FruTasksEnv getEnv() {
        return this.env;
    }

    public TaskDetailInfo getDetailInfo() {
        return this.detailInfo;
    }

    public void setChildren(List<? extends BasicTask> children) {
        this.children = children;
    }

    public List<? extends BasicTask> getChildren() {
        return this.children;
    }
}

