/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.service.task;

import com.huawei.ism.tool.distributed.fru.common.Context;
import com.huawei.ism.tool.distributed.fru.model.entity.FruDevice;
import com.huawei.ism.tool.distributed.fru.model.module.ModuleData;
import com.huawei.ism.tool.distributed.fru.service.task.ItemTask;
import com.huawei.ism.tool.distributed.fru.util.DocUtil;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.tool.service.rest.service.device.RedfishConnectionManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FruTasksEnv {
    private static final Logger log = LoggerFactory.getLogger(FruTasksEnv.class);
    private String taskId;
    private final FruDevice fruDevice;
    private final JythonExecuter executor;
    private final String moduleId;
    private final DevNode node;
    private final DevNode bmcNode;
    private List<Integer> nodeIdList;
    private final DevNode cluster;
    private final ClusterNode clusterNode;
    private final DevNode dswareNode;
    private final List<DevNode> fsmNodeList;
    private final ModuleData data;
    private ModuleData dataAfterReplace;
    private final Context context = Context.INS;
    private ItemTask currentTask;
    private boolean needTerminate = false;
    private final Map<String, Object> env = new ConcurrentHashMap<String, Object>();

    public String getItemDocLink(String docId) {
        return DocUtil.INS.getItemDocUrl(this.currentTask.taskConf.getId(), docId);
    }

    public void initModuleData(List<ModuleData> data) {
        this.fruDevice.getDataMap().put(this.moduleId, data);
    }

    public void initModuleDataByModuleId(String moduleId, List<ModuleData> data) {
        this.fruDevice.getDataMap().put(moduleId, data);
    }

    public void initModuleDataByModuleAndNode(String moduleId, List<ModuleData> data) {
        List involveNodes = data.stream().map(ModuleData::getBelongCusterNodeIp).collect(Collectors.toList());
        this.fruDevice.getDataMap().get(moduleId).removeIf(singleData -> involveNodes.contains(singleData.getBelongCusterNodeIp()));
        if (this.fruDevice.getDataMap().get(moduleId).isEmpty()) {
            this.fruDevice.getDataMap().put(moduleId, new ArrayList());
        }
        this.fruDevice.getDataMap().get(moduleId).addAll(data);
    }

    public List<? extends ModuleData> getAllModuleData() {
        return this.fruDevice.getDataMap().get(this.moduleId);
    }

    public void releaseConn() {
        this.releaseSsh(this.node);
        this.releaseRedfishNoException();
        this.releaseSsh(this.dswareNode);
        if (this.fsmNodeList != null) {
            this.fsmNodeList.forEach(this::releaseSsh);
        }
        this.releaseRestConnNoException();
    }

    private void releaseRedfishNoException() {
        if (this.bmcNode == null) {
            return;
        }
        try {
            log.info("Try release conn for {}.", (Object)this.bmcNode.getIp());
            RedfishConnectionManager.INS.releaseConn(this.bmcNode);
        }
        catch (Exception e) {
            log.error("Release redfish conn for {} failed.", (Object)this.bmcNode.getIp(), (Object)e);
        }
    }

    private void releaseRestConnNoException() {
        try {
            log.info("Try release conn for {}.", (Object)this.cluster.getIp());
            RestConnectionManager.releaseConn((DevNode)this.cluster);
        }
        catch (Exception e) {
            log.error("Release rest conn for {} failed.", (Object)this.cluster.getIp(), (Object)e);
        }
    }

    private void releaseSsh(DevNode node) {
        if (node == null) {
            return;
        }
        log.info("Try release conn for {}.", (Object)node.getIp());
        SshConnectionManager.releaseConnection((DevNode)node);
    }

    public String getWorkPath() {
        return ApplicationContext.getInstance().getWorkPath();
    }

    public String getTaskResultKey() {
        return this.currentTask.taskConf.getResultKey();
    }

    public String getTaskSelectKey() {
        return this.currentTask.taskConf.getSelectKey();
    }

    public String getTaskResultValue() {
        return (String)this.getEnv().get(this.currentTask.taskConf.getResultKey());
    }

    public void clearTaskUserSelectEnv() {
        this.currentTask.taskConf.getUserSelectKeys().forEach(this.getEnv()::remove);
    }

    FruTasksEnv(String taskId, FruDevice fruDevice, JythonExecuter executor, String moduleId, DevNode node, DevNode bmcNode, List<Integer> nodeIdList, DevNode cluster, ClusterNode clusterNode, DevNode dswareNode, List<DevNode> fsmNodeList, ModuleData data, ModuleData dataAfterReplace, ItemTask currentTask, boolean needTerminate) {
        this.taskId = taskId;
        this.fruDevice = fruDevice;
        this.executor = executor;
        this.moduleId = moduleId;
        this.node = node;
        this.bmcNode = bmcNode;
        this.nodeIdList = nodeIdList;
        this.cluster = cluster;
        this.clusterNode = clusterNode;
        this.dswareNode = dswareNode;
        this.fsmNodeList = fsmNodeList;
        this.data = data;
        this.dataAfterReplace = dataAfterReplace;
        this.currentTask = currentTask;
        this.needTerminate = needTerminate;
    }

    public static FruTasksEnvBuilder builder() {
        return new FruTasksEnvBuilder();
    }

    public String getTaskId() {
        return this.taskId;
    }

    public FruDevice getFruDevice() {
        return this.fruDevice;
    }

    public JythonExecuter getExecutor() {
        return this.executor;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public DevNode getNode() {
        return this.node;
    }

    public DevNode getBmcNode() {
        return this.bmcNode;
    }

    public List<Integer> getNodeIdList() {
        return this.nodeIdList;
    }

    public DevNode getCluster() {
        return this.cluster;
    }

    public ClusterNode getClusterNode() {
        return this.clusterNode;
    }

    public DevNode getDswareNode() {
        return this.dswareNode;
    }

    public List<DevNode> getFsmNodeList() {
        return this.fsmNodeList;
    }

    public ModuleData getData() {
        return this.data;
    }

    public ModuleData getDataAfterReplace() {
        return this.dataAfterReplace;
    }

    public Context getContext() {
        return this.context;
    }

    public ItemTask getCurrentTask() {
        return this.currentTask;
    }

    public Map<String, Object> getEnv() {
        return this.env;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setNodeIdList(List<Integer> nodeIdList) {
        this.nodeIdList = nodeIdList;
    }

    public void setDataAfterReplace(ModuleData dataAfterReplace) {
        this.dataAfterReplace = dataAfterReplace;
    }

    public void setCurrentTask(ItemTask currentTask) {
        this.currentTask = currentTask;
    }

    public boolean isNeedTerminate() {
        return this.needTerminate;
    }

    public void setNeedTerminate(boolean needTerminate) {
        this.needTerminate = needTerminate;
    }

    public static class FruTasksEnvBuilder {
        private String taskId;
        private FruDevice fruDevice;
        private JythonExecuter executor;
        private String moduleId;
        private DevNode node;
        private DevNode bmcNode;
        private List<Integer> nodeIdList;
        private DevNode cluster;
        private ClusterNode clusterNode;
        private DevNode dswareNode;
        private List<DevNode> fsmNodeList;
        private ModuleData data;
        private ModuleData dataAfterReplace;
        private ItemTask currentTask;
        private boolean needTerminate;

        FruTasksEnvBuilder() {
        }

        public FruTasksEnvBuilder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public FruTasksEnvBuilder fruDevice(FruDevice fruDevice) {
            this.fruDevice = fruDevice;
            return this;
        }

        public FruTasksEnvBuilder executor(JythonExecuter executor) {
            this.executor = executor;
            return this;
        }

        public FruTasksEnvBuilder moduleId(String moduleId) {
            this.moduleId = moduleId;
            return this;
        }

        public FruTasksEnvBuilder node(DevNode node) {
            this.node = node;
            return this;
        }

        public FruTasksEnvBuilder bmcNode(DevNode bmcNode) {
            this.bmcNode = bmcNode;
            return this;
        }

        public FruTasksEnvBuilder nodeIdList(List<Integer> nodeIdList) {
            this.nodeIdList = nodeIdList;
            return this;
        }

        public FruTasksEnvBuilder cluster(DevNode cluster) {
            this.cluster = cluster;
            return this;
        }

        public FruTasksEnvBuilder clusterNode(ClusterNode clusterNode) {
            this.clusterNode = clusterNode;
            return this;
        }

        public FruTasksEnvBuilder dswareNode(DevNode dswareNode) {
            this.dswareNode = dswareNode;
            return this;
        }

        public FruTasksEnvBuilder fsmNodeList(List<DevNode> fsmNodeList) {
            this.fsmNodeList = fsmNodeList;
            return this;
        }

        public FruTasksEnvBuilder data(ModuleData data) {
            this.data = data;
            return this;
        }

        public FruTasksEnvBuilder dataAfterReplace(ModuleData dataAfterReplace) {
            this.dataAfterReplace = dataAfterReplace;
            return this;
        }

        public FruTasksEnvBuilder currentTask(ItemTask currentTask) {
            this.currentTask = currentTask;
            return this;
        }

        public FruTasksEnvBuilder needTerminate(boolean needTerminate) {
            this.needTerminate = needTerminate;
            return this;
        }

        public FruTasksEnv build() {
            return new FruTasksEnv(this.taskId, this.fruDevice, this.executor, this.moduleId, this.node, this.bmcNode, this.nodeIdList, this.cluster, this.clusterNode, this.dswareNode, this.fsmNodeList, this.data, this.dataAfterReplace, this.currentTask, this.needTerminate);
        }

        public String toString() {
            return "FruTasksEnv.FruTasksEnvBuilder(taskId=" + this.taskId + ", fruDevice=" + this.fruDevice + ", executor=" + this.executor + ", moduleId=" + this.moduleId + ", node=" + this.node + ", bmcNode=" + this.bmcNode + ", nodeIdList=" + this.nodeIdList + ", cluster=" + this.cluster + ", clusterNode=" + this.clusterNode + ", dswareNode=" + this.dswareNode + ", fsmNodeList=" + this.fsmNodeList + ", data=" + this.data + ", dataAfterReplace=" + this.dataAfterReplace + ", currentTask=" + this.currentTask + ", needTerminate=" + this.needTerminate + ")";
        }
    }
}

