/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.service.task;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.distributed.fru.common.Constants;
import com.huawei.ism.tool.distributed.fru.model.entity.TaskConf;
import com.huawei.ism.tool.distributed.fru.model.entity.vo.TaskReqInfoVO;
import com.huawei.ism.tool.distributed.fru.model.enumz.Status;
import com.huawei.ism.tool.distributed.fru.model.enumz.TaskType;
import com.huawei.ism.tool.distributed.fru.model.module.ModuleData;
import com.huawei.ism.tool.distributed.fru.service.ignore.IgnoreService;
import com.huawei.ism.tool.distributed.fru.service.task.BasicTask;
import com.huawei.ism.tool.distributed.fru.service.task.FruTasksEnv;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemTask
extends BasicTask {
    private static final Logger log = LoggerFactory.getLogger(ItemTask.class);
    private final Map<TaskType, Function<List<Object>, ItemTask>> retHandlerRoute = new ConcurrentHashMap<TaskType, Function<List<Object>, ItemTask>>();
    private final Map<TaskType, Supplier<List<Object>>> invokeHandle = new ConcurrentHashMap<TaskType, Supplier<List<Object>>>();
    private final Map<TaskType, Consumer<ItemTask>> failedHandle = new ConcurrentHashMap<TaskType, Consumer<ItemTask>>();

    public ItemTask(FruTasksEnv env, TaskConf info) {
        super(env, info);
        this.invokeHandle.put(TaskType.USER_CONTROL_STEP, this::invokeDirectReturnSuccess);
        this.invokeHandle.put(TaskType.DEFAULT, this::invoke);
        this.retHandlerRoute.put(TaskType.QUERY_STEP, this::handleQueryRet);
        this.retHandlerRoute.put(TaskType.DEFAULT, this::handCheckItemRet);
        this.retHandlerRoute.put(TaskType.CHECK_STEP, this::handCheckItemRet);
        this.retHandlerRoute.put(TaskType.USER_CONTROL_STEP, this::handCheckItemRet);
        this.retHandlerRoute.put(TaskType.UPDATE, this::handUpdateRet);
        this.retHandlerRoute.put(TaskType.USER_SELECT_ITEM, this::handUserSelectItemRet);
        this.failedHandle.put(TaskType.USER_SELECT_ITEM, this::handUserSelectFailed);
        this.failedHandle.put(TaskType.DEFAULT, this::handCheckItemFailed);
    }

    @Override
    protected void init() {
        this.beginTime = "";
        super.init();
    }

    @Override
    protected void initTarget(TaskReqInfoVO info) {
        if (!this.taskConf.getId().equals(info.getItemId())) {
            return;
        }
        this.init();
    }

    @Override
    public boolean execute() {
        try {
            this.prepare();
            if (IgnoreService.canIgnoreItem(this) || this.isIgnoreExecute()) {
                this.setIgnoreExecute(false);
                this.status = Status.IGNORE;
            } else {
                this.handleRet(this.invokeHandle.getOrDefault((Object)this.taskConf.getType(), this.invokeHandle.get((Object)TaskType.DEFAULT)).get());
            }
        }
        catch (Exception e) {
            log.error("Execute task error.", (Throwable)e);
            this.fail(Constants.Task.TASK_EXEC_EXCEPTION, Constants.Task.TASK_EXEC_SUGGESTION);
        }
        finally {
            this.progress = 100.0;
            this.endTime = this.getTime();
            this.notifyObs();
        }
        if (this.isFailed()) {
            this.failedHandle.getOrDefault((Object)this.taskConf.getType(), this.failedHandle.get((Object)TaskType.DEFAULT)).accept(this);
        }
        return this.next();
    }

    private void prepare() {
        this.status = Status.RUNNING;
        this.beginTime = this.getTime();
        this.endTime = "";
        this.notifyObs();
        this.env.setCurrentTask(this);
    }

    private List<Object> invoke() {
        try {
            this.compileScript();
            return this.env.getExecutor().invokeFunction(this.taskConf.getExecuteMethod(), new Object[]{this.env});
        }
        catch (ToolException e) {
            log.error("Execute script error. {} ", (Object)e.getErrorLocaleDescription(), (Object)e);
            if ("error.info".equals(e.getErrorId())) {
                this.fail(Constants.Task.TASK_EXEC_EXCEPTION, Constants.Task.TASK_EXEC_SUGGESTION);
            } else {
                this.fail(e.getErrorLocaleDescription(), Constants.Task.TASK_EXEC_SUGGESTION);
            }
        }
        catch (Exception e) {
            log.error("Execute script error.", (Throwable)e);
            this.fail(Constants.Task.TASK_EXEC_EXCEPTION, Constants.Task.TASK_EXEC_SUGGESTION);
        }
        return Collections.emptyList();
    }

    private List<Object> invokeDirectReturnSuccess() {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add((Object)Status.SUCCESS);
        objects.add("");
        return objects;
    }

    private void handleRet(List<Object> retData) {
        this.retHandlerRoute.getOrDefault((Object)this.taskConf.getType(), this.retHandlerRoute.get((Object)TaskType.DEFAULT)).apply(retData);
    }

    private void handUserSelectFailed(ItemTask itemTask) {
        IgnoreService.writeAbnormalItemInfo(itemTask);
        this.getEnv().clearTaskUserSelectEnv();
    }

    private void handCheckItemFailed(ItemTask itemTask) {
        IgnoreService.writeAbnormalItemInfo(itemTask);
    }

    private ItemTask handUserSelectItemRet(List<Object> retData) {
        this.handCheckItemRet(retData);
        this.resultJson = this.getEnv().getTaskResultValue();
        return this;
    }

    private ItemTask handCheckItemRet(List<Object> retData) {
        if (retData == null || retData.isEmpty()) {
            log.error("Ret is empty or null.");
            return this;
        }
        this.status = Status.valueOf(retData.get(0).toString());
        this.description = retData.get(1).toString();
        if (this.isFailed() && StringUtils.isNULLStr((String)this.suggestion)) {
            this.suggestion = this.taskConf.getSuggestion();
        }
        return this;
    }

    private ItemTask handUpdateRet(List<Object> retData) {
        if (retData == null || retData.isEmpty()) {
            log.error("Ret is empty or null.");
            return this;
        }
        this.status = Status.valueOf(retData.get(0).toString());
        if (!this.isSuccess()) {
            this.description = retData.get(1).toString();
            return this;
        }
        this.description = this.map2Json(this.env.getDataAfterReplace());
        if ("cacheDisk".equals(this.env.getModuleId())) {
            return this;
        }
        List<ModuleData> data = this.env.getFruDevice().getDataMap().get(this.env.getModuleId());
        data.remove(this.env.getData());
        data.add(this.env.getDataAfterReplace());
        return this;
    }

    private String map2Json(Object data) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            log.error("Map data 2 json failed.");
            return "{}";
        }
    }

    private ItemTask handleQueryRet(List<Object> retData) {
        if (retData == null || retData.isEmpty()) {
            log.error("Query ret is empty or null.");
            return this;
        }
        this.status = Status.valueOf(retData.get(0).toString());
        this.description = retData.get(1).toString();
        return this;
    }

    @Override
    public boolean next() {
        if (this.isWaitingConfirm()) {
            return false;
        }
        List<String> postFilter = this.taskConf.getPostFilters();
        if (postFilter == null || postFilter.isEmpty()) {
            return true;
        }
        return this.filter(postFilter);
    }

    private void compileScript() throws FileNotFoundException {
        this.env.getExecutor().compileScript(new File(this.taskConf.getScriptPath() + File.separator + this.taskConf.getId() + ".py"));
    }

    public void updateProgress(double pro) {
        if (this.progress >= pro) {
            log.warn("Invalid progress, cur {} ,new {}.", (Object)this.progress, (Object)pro);
            return;
        }
        this.progress = Math.min(pro, 100.0);
        this.notifyObs();
    }

    public void updateSuggestion(String suggestion) {
        this.suggestion = suggestion;
    }

    public void updateProgress(double pro, String msg) {
        this.description = msg;
        this.updateProgress(pro);
    }

    private void fail(String errMsg, String suggestion) {
        this.description = errMsg;
        this.suggestion = suggestion;
        this.progress = 100.0;
        this.status = Status.FAILED;
        this.notifyObs();
    }

    public static Logger getLogger() {
        return log;
    }

    public static ItemTaskBuilder builder() {
        return new ItemTaskBuilder();
    }

    public static class ItemTaskBuilder {
        private FruTasksEnv env;
        private TaskConf info;

        ItemTaskBuilder() {
        }

        public ItemTaskBuilder env(FruTasksEnv env) {
            this.env = env;
            return this;
        }

        public ItemTaskBuilder info(TaskConf info) {
            this.info = info;
            return this;
        }

        public ItemTask build() {
            return new ItemTask(this.env, this.info);
        }

        public String toString() {
            return "ItemTask.ItemTaskBuilder(env=" + this.env + ", info=" + this.info + ")";
        }
    }
}

