/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.service.task;

import com.huawei.ism.tool.distributed.fru.common.Constants;
import com.huawei.ism.tool.distributed.fru.model.entity.TaskConf;
import com.huawei.ism.tool.distributed.fru.model.entity.vo.TaskReqInfoVO;
import com.huawei.ism.tool.distributed.fru.service.task.BasicTask;
import com.huawei.ism.tool.distributed.fru.service.task.FruTasksEnv;
import com.huawei.ism.tool.distributed.fru.service.task.ITask;
import com.huawei.ism.tool.distributed.fru.service.task.StepTask;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessTask
extends BasicTask
implements ITask {
    private static final Logger log = LoggerFactory.getLogger(ProcessTask.class);

    public ProcessTask(FruTasksEnv env, TaskConf info) {
        super(env, info);
    }

    @Override
    protected void initTarget(TaskReqInfoVO info) {
        if (!this.taskConf.getId().equals(info.getProcessId())) {
            return;
        }
        this.init();
        this.children.forEach(subTask -> subTask.initTarget(info));
    }

    public boolean execute(TaskReqInfoVO info) throws ToolException {
        String targetStep = info.getStepId();
        Optional<BasicTask> stepTask = this.children.stream().filter((? super T step) -> step.getTaskConf().getId().equals(targetStep)).findFirst();
        if (!stepTask.isPresent()) {
            throw new ToolException(Constants.Task.TASK_NOT_EXIST, false);
        }
        this.currentSubItemId = ((StepTask)stepTask.get()).getTaskConf().getId();
        return ((StepTask)stepTask.get()).execute(info);
    }

    @Override
    public boolean execute() {
        try {
            for (BasicTask stepTask : this.children) {
                if (stepTask.canNotExecute()) continue;
                return stepTask.execute();
            }
            return true;
        }
        catch (ToolException e) {
            log.error("Task exec failed.", (Throwable)e);
            return false;
        }
    }

    @Override
    public String getTaskId() {
        return this.env.getTaskId();
    }

    public static ProcessTaskBuilder builder() {
        return new ProcessTaskBuilder();
    }

    public static class ProcessTaskBuilder {
        private FruTasksEnv env;
        private TaskConf info;

        ProcessTaskBuilder() {
        }

        public ProcessTaskBuilder env(FruTasksEnv env) {
            this.env = env;
            return this;
        }

        public ProcessTaskBuilder info(TaskConf info) {
            this.info = info;
            return this;
        }

        public ProcessTask build() {
            return new ProcessTask(this.env, this.info);
        }

        public String toString() {
            return "ProcessTask.ProcessTaskBuilder(env=" + this.env + ", info=" + this.info + ")";
        }
    }
}

