/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.service.task;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.distributed.fru.common.Constants;
import com.huawei.ism.tool.distributed.fru.model.entity.TaskConf;
import com.huawei.ism.tool.distributed.fru.model.entity.vo.TaskReqInfoVO;
import com.huawei.ism.tool.distributed.fru.service.task.BasicTask;
import com.huawei.ism.tool.distributed.fru.service.task.FruTasksEnv;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepTask
extends BasicTask {
    private static final Logger log = LoggerFactory.getLogger(StepTask.class);

    public StepTask(FruTasksEnv env, TaskConf info) {
        super(env, info);
    }

    @Override
    protected void initTarget(TaskReqInfoVO info) {
        if (!this.taskConf.getId().equals(info.getStepId())) {
            return;
        }
        this.init();
        if (StringUtils.isNULLStr((String)info.getItemId())) {
            log.info("Init all sub-item task.");
            this.children.forEach(BasicTask::initAll);
        } else {
            this.children.forEach(subTask -> subTask.initTarget(info));
        }
    }

    @Override
    public boolean execute() throws ToolException {
        TaskReqInfoVO reqInfo = new TaskReqInfoVO();
        reqInfo.setItemId("");
        return this.execute(reqInfo);
    }

    public boolean execute(TaskReqInfoVO info) throws ToolException {
        Optional<? extends BasicTask> itemTaskOpt = this.findFirstExecutedItem(info);
        if (!itemTaskOpt.isPresent()) {
            log.warn("Can not find task {}", (Object)info);
            throw new ToolException(Constants.Task.TASK_NOT_EXIST, false);
        }
        for (int i = this.children.indexOf(itemTaskOpt.get()); i < this.children.size(); ++i) {
            BasicTask itemTask = (BasicTask)this.children.get(i);
            if (itemTask.canNotExecute()) {
                log.info("Task {} can not execute,jump it.", (Object)itemTask.getTaskConf().getId());
                continue;
            }
            this.currentSubItemId = itemTask.getTaskConf().getId();
            log.info("Task {} start execute.", (Object)itemTask.getTaskConf().getId());
            if (!itemTask.execute()) {
                log.info("Item {} execute failed,stop execute.", (Object)itemTask.getTaskConf());
                return false;
            }
            log.info("Task {} end execute.", (Object)itemTask.getTaskConf().getId());
        }
        return true;
    }

    private Optional<? extends BasicTask> findFirstExecutedItem(TaskReqInfoVO reqInfo) {
        if (StringUtils.isNULLStr((String)reqInfo.getItemId())) {
            return this.children.stream().filter((? super T itemTask) -> !itemTask.isSuccess()).peek(BasicTask::init).findFirst();
        }
        return this.children.stream().filter((? super T itemTask) -> itemTask.getTaskConf().getId().equals(reqInfo.getItemId())).findFirst();
    }

    @Override
    protected boolean isFailedByChildren() {
        return this.children.stream().anyMatch(item -> item.isFailed() && this.isChildHasSuccessNext((BasicTask)item)) || this.children.stream().anyMatch(BasicTask::isFailed) && this.children.stream().allMatch(BasicTask::isFinished);
    }

    private boolean isChildHasSuccessNext(BasicTask item) {
        List<String> postFilters = item.getTaskConf().getPostFilters();
        if (postFilters == null || postFilters.isEmpty()) {
            return false;
        }
        return postFilters.stream().anyMatch(Constants.FilterRoute::isSuccessContinue);
    }

    public static StepTaskBuilder builder() {
        return new StepTaskBuilder();
    }

    public static class StepTaskBuilder {
        private FruTasksEnv env;
        private TaskConf info;

        StepTaskBuilder() {
        }

        public StepTaskBuilder env(FruTasksEnv env) {
            this.env = env;
            return this;
        }

        public StepTaskBuilder info(TaskConf info) {
            this.info = info;
            return this;
        }

        public StepTask build() {
            return new StepTask(this.env, this.info);
        }

        public String toString() {
            return "StepTask.StepTaskBuilder(env=" + this.env + ", info=" + this.info + ")";
        }
    }
}

