/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.service.task;

import com.huawei.ism.tool.distributed.fru.common.Constants;
import com.huawei.ism.tool.distributed.fru.model.entity.FruClusterNode;
import com.huawei.ism.tool.distributed.fru.model.entity.FruDevice;
import com.huawei.ism.tool.distributed.fru.model.entity.Product;
import com.huawei.ism.tool.distributed.fru.model.entity.TaskConf;
import com.huawei.ism.tool.distributed.fru.model.entity.vo.TaskReqInfoVO;
import com.huawei.ism.tool.distributed.fru.model.enumz.TaskType;
import com.huawei.ism.tool.distributed.fru.model.module.ModuleData;
import com.huawei.ism.tool.distributed.fru.service.task.FruTasksEnv;
import com.huawei.ism.tool.distributed.fru.service.task.ItemTask;
import com.huawei.ism.tool.distributed.fru.service.task.ProcessTask;
import com.huawei.ism.tool.distributed.fru.service.task.StepTask;
import com.huawei.ism.tool.distributed.fru.util.DeviceUtil;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.tool.service.rest.model.Either;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Observer;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.python.core.Py;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskFactory {
    private static final Logger log = LoggerFactory.getLogger(TaskFactory.class);
    public static final TaskFactory INS = new TaskFactory();

    public Optional<ProcessTask> createTask(TaskReqInfoVO info) throws ToolException {
        Optional<FruDevice> fruDevice = DeviceUtil.INS.findFruDev(info.getDeviceSn());
        if (!fruDevice.isPresent()) {
            log.error("Can not find target device {} .", (Object)info.getDeviceSn());
            return Optional.empty();
        }
        if (this.isQueryTask(fruDevice.get().getProduct(), info)) {
            return this.createModuleQueryTask(fruDevice.get(), info);
        }
        return this.createFruTask(fruDevice.get(), info);
    }

    public boolean isQueryTask(Product product, TaskReqInfoVO info) {
        return this.findTargetQueryTaskConf(product, info).isPresent();
    }

    private Optional<TaskConf> findTargetQueryTaskConf(Product product, TaskReqInfoVO info) {
        return this.findQueryTaskConf(product, info).filter(taskConf -> info.getProcessId().equals(taskConf.getId())).findFirst();
    }

    public Stream<TaskConf> findQueryTaskConf(Product product, TaskReqInfoVO info) {
        return product.getModuleId2TaskInfoList().getOrDefault(info.getModuleId(), Collections.emptyList()).stream().filter(taskConf -> taskConf.getType().equals((Object)TaskType.QUERY_STEP));
    }

    private synchronized Optional<ProcessTask> createFruTask(FruDevice device, TaskReqInfoVO info) {
        Optional<ModuleData> targetData = DeviceUtil.INS.findModuleData(info);
        if (!targetData.isPresent()) {
            log.info("Can not find module data {}.", (Object)info);
            return Optional.empty();
        }
        String taskId = this.createTaskId(device, info);
        if (device.containsTask(taskId)) {
            log.info("Exist task : {} , task info {} .", (Object)taskId, (Object)info);
            Optional<ProcessTask> targetTask = this.getTargetProcessTask(info, device.findTargetTask(taskId));
            targetTask.ifPresent(task -> {
                task.init(info);
                task.getEnv().getEnv().putAll(info.getUserSelect());
            });
            return targetTask;
        }
        log.info("Create fru tasks : {} with task info {}.", (Object)taskId, (Object)info);
        List<ProcessTask> tasks = this.createFruProcessesTask(info.getModuleId(), this.createFruEnv(info));
        device.registerTask(taskId, tasks);
        return this.getTargetProcessTask(info, tasks);
    }

    private synchronized Optional<ProcessTask> createModuleQueryTask(FruDevice device, TaskReqInfoVO info) throws ToolException {
        String taskId = this.createTaskId(device, info);
        if (device.containsTask(taskId)) {
            log.info("Exist task : {} , task info {} .", (Object)taskId, (Object)info);
            ProcessTask processTask = device.findTargetTask(taskId).get(0);
            processTask.getEnv().setNodeIdList(info.getNodeIds());
            this.checkTaskIsRunning(processTask);
            processTask.init(null);
            return Optional.of(processTask);
        }
        ProcessTask queryTask = this.createProcessTask(info, this.createQueryEnv(info));
        log.info("Create fru tasks : {} with task info {}.", (Object)taskId, (Object)info);
        device.registerTask(taskId, Collections.singletonList(queryTask));
        device.getDataMap().put(info.getModuleId(), Collections.emptyList());
        return Optional.of(queryTask);
    }

    private Optional<ProcessTask> getTargetProcessTask(TaskReqInfoVO info, List<ProcessTask> tasks) {
        return tasks.stream().filter(task -> task.getTaskConf().getId().equals(info.getProcessId())).findFirst();
    }

    private void checkTaskIsRunning(ProcessTask processTask) throws ToolException {
        if (processTask.isRunning()) {
            log.info("Target task is running status,can not re-start.");
            throw new ToolException("fru.task.exist.waring");
        }
    }

    private List<ProcessTask> createFruProcessesTask(String moduleId, FruTasksEnv env) {
        return env.getFruDevice().getProduct().getModuleId2TaskInfoList().get(moduleId).stream().filter(taskInfo -> taskInfo.getType() != TaskType.QUERY_STEP).map(processTaskInfo -> ProcessTask.builder().env(env).info((TaskConf)processTaskInfo).build()).peek(processTask -> processTask.setChildren(this.createStepTask(processTask.getTaskConf(), env, (Observer)processTask))).collect(Collectors.toList());
    }

    private ProcessTask createProcessTask(TaskReqInfoVO info, FruTasksEnv env) {
        TaskConf processTaskConf = env.getFruDevice().getProduct().getModuleId2TaskInfoList().get(info.getModuleId()).stream().filter(taskInfo -> taskInfo.getId().equals(info.getProcessId())).findFirst().get();
        ProcessTask processTask = ProcessTask.builder().env(env).info(processTaskConf).build();
        processTask.setChildren(this.createStepTask(processTaskConf, env, processTask));
        return processTask;
    }

    private List<StepTask> createStepTask(TaskConf processTaskConf, FruTasksEnv env, Observer obs) {
        return processTaskConf.getChildrenConf().stream().map(stepInfo -> StepTask.builder().info((TaskConf)stepInfo).env(env).build()).peek(stepInfo -> stepInfo.addObserver(obs)).peek(stepTask -> stepTask.setChildren(stepTask.getTaskConf().getChildrenConf().stream().map(itemInfo -> ItemTask.builder().info((TaskConf)itemInfo).env(env).build()).peek(itemTask -> itemTask.addObserver((Observer)stepTask)).collect(Collectors.toList()))).collect(Collectors.toList());
    }

    public String createTaskId(FruDevice device, TaskReqInfoVO info) {
        if (this.isQueryTask(device.getProduct(), info)) {
            return this.createQueryTaskId(device, info);
        }
        return this.createFruTaskId(device, info);
    }

    public String createFruTaskId(FruDevice device, TaskReqInfoVO info) {
        return device.getDevNode().getDeviceSerialNumber() + "_" + info.getModuleId() + "_" + info.getDataId();
    }

    public String createQueryTaskId(FruDevice device, TaskReqInfoVO info) {
        return device.getDevNode().getDeviceSerialNumber() + "_" + info.getModuleId();
    }

    public FruTasksEnv createFruEnv(TaskReqInfoVO info) {
        FruDevice device = DeviceUtil.INS.findFruDev(info.getDeviceSn()).get();
        FruClusterNode node = DeviceUtil.INS.findClusterNodeByModuleDataId(info).get();
        Optional<ModuleData> targetData = DeviceUtil.INS.findModuleData(info);
        ModuleData data = null;
        if (targetData.isPresent()) {
            data = targetData.get();
        }
        FruTasksEnv env = FruTasksEnv.builder().cluster(device.getDevNode()).bmcNode(DeviceUtil.INS.buildBmcNode(node)).dswareNode(DeviceUtil.INS.buildDswareNode(device)).fsmNodeList(DeviceUtil.INS.buildFsmNodeList(device)).node(DeviceUtil.INS.buildOsNode(node)).clusterNode(node.getClusterNode().getNode()).moduleId(info.getModuleId()).taskId(this.createTaskId(device, info)).executor(new JythonExecuter(Collections.singletonList(new File(Constants.PACKAGE_ROOT_DIR).getParentFile()), Py.getSystemState())).fruDevice(device).data(data).build();
        env.getEnv().putAll(info.getUserSelect());
        return env;
    }

    public FruTasksEnv createQueryEnv(TaskReqInfoVO info) {
        FruDevice device = DeviceUtil.INS.findFruDev(info.getDeviceSn()).get();
        return FruTasksEnv.builder().moduleId(info.getModuleId()).cluster(device.getDevNode()).nodeIdList(info.getNodeIds()).taskId(this.createTaskId(device, info)).executor(new JythonExecuter(Collections.singletonList(new File(Constants.PACKAGE_ROOT_DIR).getParentFile()), Py.getSystemState())).fruDevice(device).build();
    }

    public List<ProcessTask> createTasks(List<TaskReqInfoVO> taskInfos) {
        return taskInfos.stream().map(Either.lift(this::createTask)).filter(Either::isRight).map(Either::getRight).map(Optional::get).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private TaskFactory() {
    }
}

