/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.service.task;

import com.huawei.ism.tool.distributed.fru.model.entity.FruDevice;
import com.huawei.ism.tool.distributed.fru.model.entity.vo.TaskReqInfoVO;
import com.huawei.ism.tool.distributed.fru.model.enumz.TaskType;
import com.huawei.ism.tool.distributed.fru.service.task.BasicTask;
import com.huawei.ism.tool.distributed.fru.service.task.IToolTaskObserver;
import com.huawei.ism.tool.distributed.fru.service.task.ProcessTask;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TaskManager
implements IToolTaskObserver {
    private static final Logger log = LoggerFactory.getLogger(TaskManager.class);
    private final Map<String, ProcessTask> runningTaskMap = new ConcurrentHashMap<String, ProcessTask>();
    private final ExecutorService fruTaskExecutor = Executors.newSingleThreadExecutor();
    private final ExecutorService queryService = Executors.newFixedThreadPool(10);

    public CompletableFuture<Boolean> submitFruTask(ProcessTask task, TaskReqInfoVO info) throws ToolException {
        log.info("Submit task {} .", (Object)info);
        this.waitForQueryTaskFinished();
        this.runningTaskMap.putIfAbsent(task.getTaskId(), task);
        return CompletableFuture.supplyAsync(() -> {
            try {
                return task.execute(info);
            }
            catch (ToolException e) {
                log.error("Execute task {} error.", (Object)info, (Object)e);
                return false;
            }
        }, this.fruTaskExecutor).whenComplete((ret, ex) -> this.taskFinalHandle(task, (Throwable)ex));
    }

    public void clearQueryTask() {
        this.runningTaskMap.values().stream().filter(processTask -> processTask.getTaskConf().getType() == TaskType.QUERY_STEP).forEach(processTask -> processTask.getEnv().setNeedTerminate(true));
    }

    public boolean hasRunningQueryTask() {
        return this.runningTaskMap.values().stream().anyMatch(processTask -> processTask.getTaskConf().getType() == TaskType.QUERY_STEP);
    }

    public CompletableFuture<Boolean> submitQueryTask(ProcessTask task, TaskReqInfoVO info) {
        log.info("Submit task {} .", (Object)info);
        this.runningTaskMap.putIfAbsent(task.getTaskId(), task);
        return CompletableFuture.supplyAsync(task::execute, this.queryService).whenComplete((ret, ex) -> this.taskFinalHandle(task, (Throwable)ex));
    }

    private void taskFinalHandle(ProcessTask task, Throwable ex) {
        FruDevice fruDevice;
        if (ex != null) {
            log.error("Exec task {} err.", (Object)task.getTaskId(), (Object)ex);
        }
        if (!task.isRunning()) {
            this.deleteTask(task.getTaskId());
        }
        if (!this.hasRunningTask(fruDevice = task.getEnv().getFruDevice())) {
            log.info("Task {} finish and Has no other task running for {} ", (Object)task.getTaskId(), (Object)fruDevice.getDevNode().getIp());
            task.getEnv().releaseConn();
        }
    }

    private void waitForQueryTaskFinished() throws ToolException {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 120000L && this.hasRunningQueryTask()) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                throw new ToolException("fru.task.clean.query.task.failed");
            }
        }
        if (this.hasRunningQueryTask()) {
            throw new ToolException("fru.task.clean.query.task.failed");
        }
    }

    private synchronized boolean hasRunningTask(FruDevice fruDevice) {
        String sn = fruDevice.getDevNode().getDeviceSerialNumber();
        return this.runningTaskMap.keySet().stream().filter(key -> key.contains(sn)).map(this.runningTaskMap::get).filter(Objects::nonNull).map(BasicTask::getChildren).flatMap(Collection::stream).anyMatch(BasicTask::isRunning);
    }

    @Override
    public boolean hasRunningTask() {
        return this.runningTaskMap.values().stream().anyMatch(BasicTask::isRunning);
    }

    public void deleteTask(String taskId) {
        this.runningTaskMap.remove(taskId);
    }
}

