/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.util;

import com.huawei.ism.tool.distributed.fru.common.Context;
import com.huawei.ism.tool.distributed.fru.model.entity.AuthDevNode;
import com.huawei.ism.tool.distributed.fru.model.entity.FruClusterNode;
import com.huawei.ism.tool.distributed.fru.model.entity.FruDevice;
import com.huawei.ism.tool.distributed.fru.model.entity.TaskDetailInfo;
import com.huawei.ism.tool.distributed.fru.model.entity.vo.ModuleDataInfoVO;
import com.huawei.ism.tool.distributed.fru.model.entity.vo.TaskReqInfoVO;
import com.huawei.ism.tool.distributed.fru.model.enumz.Status;
import com.huawei.ism.tool.distributed.fru.model.module.Module;
import com.huawei.ism.tool.distributed.fru.model.module.ModuleData;
import com.huawei.ism.tool.distributed.fru.service.task.ItemTask;
import com.huawei.ism.tool.distributed.fru.service.task.ProcessTask;
import com.huawei.ism.tool.distributed.fru.service.task.TaskFactory;
import com.huawei.ism.tool.distributed.fru.util.ProductUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DeviceUtil {
    private static final Logger log = LoggerFactory.getLogger(DeviceUtil.class);
    public static final DeviceUtil INS = new DeviceUtil();
    private final Context context = Context.INS;

    public Optional<FruDevice> findFruDev(String sn) {
        return Optional.ofNullable(this.context.getSn2FruDevMap().get(sn));
    }

    public Optional<FruClusterNode> findClusterNodeByIp(String deviceSn, String ip) {
        Optional<FruDevice> device = this.findFruDev(deviceSn);
        if (!device.isPresent()) {
            log.warn("Can not find device {} ", (Object)deviceSn);
            return Optional.empty();
        }
        return device.get().findTargetFruClusterNodeByIp(ip);
    }

    public Optional<FruClusterNode> findClusterNodeByModuleDataId(TaskReqInfoVO info) {
        Optional<FruDevice> fruDeviceOpt = this.findFruDev(info.getDeviceSn());
        if (!fruDeviceOpt.isPresent()) {
            log.warn("Can not find device {} ", (Object)info.getDeviceSn());
            return Optional.empty();
        }
        Optional<ModuleData> dataOpt = this.findModuleData(info.getModuleId(), info.getDataId(), fruDeviceOpt);
        if (!dataOpt.isPresent()) {
            log.warn("Can not find module {} data {} ", (Object)info.getModuleId(), (Object)info.getDataId());
            return Optional.empty();
        }
        return this.findClusterNodeByIp(info.getDeviceSn(), dataOpt.get().getBelongCusterNodeIp());
    }

    public DevNode buildBmcNode(FruClusterNode node) {
        if (!node.getClusterNode().getBmcAuthStatusInfo().isAuthSuccess()) {
            return null;
        }
        DevNode devNode = new DevNode();
        devNode.setIp(node.getNode().getBmcIp());
        devNode.setProductModel(node.getNode().getModel());
        devNode.setLoginUser(node.getClusterNode().getBmcUser());
        devNode.setPort(node.getClusterNode().getRedfishPort());
        return devNode;
    }

    public DevNode buildDswareNode(FruDevice fruDevice) {
        FruClusterNode fsmFruClusterNode = fruDevice.getFruClusterNodes().stream().filter(FruClusterNode::isManagerNode).findFirst().get();
        DevNode fsmNode = this.buildOsNode(fsmFruClusterNode);
        fsmNode.setDeviceSerialNumber(fsmNode.getDeviceSerialNumber() + "dsware");
        return fsmNode;
    }

    public List<DevNode> buildFsmNodeList(FruDevice fruDevice) {
        return fruDevice.getFruClusterNodes().stream().filter(FruClusterNode::isManagerNode).map(this::buildOsNode).collect(Collectors.toList());
    }

    public DevNode buildOsNode(FruClusterNode node) {
        DevNode devNode = new DevNode();
        devNode.setIp(node.getNode().getManagementIp());
        devNode.setProductModel(node.getNode().getModel());
        devNode.setLoginUser(node.getClusterNode().getOsUser());
        devNode.setRootUser(node.getClusterNode().getOsRootUser());
        devNode.setPort(node.getClusterNode().getSshPort());
        devNode.setMiniSystem(node.getClusterNode().isMinisystem());
        devNode.setSshForwardList(node.getNode().getSshForwardList());
        devNode.setSandboxOpen(this.isSandboxOpen(node));
        return devNode;
    }

    private boolean isSandboxOpen(FruClusterNode node) {
        return node.getClusterNode().getNode().getSandboxStatus().getCode() == 0;
    }

    public Optional<ModuleData> findModuleData(TaskReqInfoVO info) {
        return this.findModuleData(info.getModuleId(), info.getDataId(), this.findFruDev(info.getDeviceSn()));
    }

    private Optional<ModuleData> findModuleData(String moduleId, String dataId, Optional<FruDevice> fruDeviceOpt) {
        return fruDeviceOpt.get().getDataMap().get(moduleId).stream().filter(data -> data.getIdentifier().equals(dataId)).findFirst();
    }

    public List<ModuleDataInfoVO.CountRet> countStatisticsInfo(ModuleDataInfoVO.CountReq info, FruDevice fruDevice) {
        return info.getModuleIds().stream().map(id -> this.buildModuleData(info.getNodeIds(), fruDevice, (String)id)).collect(Collectors.toList());
    }

    private ModuleDataInfoVO.CountRet buildModuleData(List<Integer> nodeIds, FruDevice fruDevice, String id) {
        Module module = ProductUtil.INS.findModule(fruDevice, id);
        Status status = Status.WAITING;
        String description = "";
        String taskId = fruDevice.getDevNode().getDeviceSerialNumber() + "_" + module.getId();
        if (fruDevice.containsTask(taskId)) {
            TaskDetailInfo detailInfo = fruDevice.findTargetTask(taskId).get(0).getDetailInfo();
            status = detailInfo.getStatus();
            description = detailInfo.getDescription();
        }
        List<ModuleData> moduleData = this.findTargetNodesModuleData(fruDevice, module.getId(), nodeIds);
        int faultNum = (int)moduleData.stream().filter(ModuleData::hasFault).count();
        int subHealthNum = (int)moduleData.stream().filter(ModuleData::isSubHealth).count();
        int unknownNum = (int)moduleData.stream().filter(ModuleData::isUnknown).count();
        int normalNum = (int)moduleData.stream().filter(ModuleData::isNormal).count();
        return ModuleDataInfoVO.CountRet.builder().moduleId(module.getId()).moduleName(module.getName()).status(status).description(description).faultNum(faultNum).notHealthNum(subHealthNum).unknownNum(unknownNum).normalNum(normalNum).build();
    }

    public List<ModuleData> findTargetNodesModuleData(FruDevice fruDevice, String moduleId, List<Integer> nodeIds) {
        return fruDevice.getDataMap().getOrDefault(moduleId, Collections.emptyList()).stream().filter(data -> nodeIds.contains(fruDevice.findTargetFruClusterNodeByIp(data.getBelongCusterNodeIp()).get().getNode().getId())).collect(Collectors.toList());
    }

    public Optional<ProcessTask> findProgressTask(TaskReqInfoVO info) {
        Optional<FruDevice> deviceOpt = this.findFruDev(info.getDeviceSn());
        return deviceOpt.flatMap(device -> device.findTargetTask(TaskFactory.INS.createTaskId((FruDevice)device, info)).stream().filter(task -> task.getTaskConf().getId().equals(info.getProcessId())).findFirst());
    }

    public Optional<ItemTask> findItemTask(TaskReqInfoVO info) {
        return this.findProgressTask(info).flatMap(processTask -> processTask.findChildTaskById(info.getStepId())).flatMap(stepTask -> stepTask.findChildTaskById(info.getItemId())).map(basicTask -> (ItemTask)basicTask);
    }

    public List<Integer> findNodeIdsWhichHasFaultModule(FruDevice fruDevice) {
        return fruDevice.getDataMap().values().stream().flatMap(Collection::stream).filter(data -> !data.isNormal()).map(data -> fruDevice.findTargetFruClusterNodeByIp(data.getBelongCusterNodeIp()).get().getNode().getId()).distinct().collect(Collectors.toList());
    }

    public Map<Integer, AuthDevNode> getAuthDevNodeByNodeIdList(FruDevice fruDevice, List<Integer> nodeIdList) {
        return fruDevice.getFruClusterNodes().stream().filter(fruClusterNode -> nodeIdList.contains(fruClusterNode.getNodeId())).map(AuthDevNode::new).collect(Collectors.toMap(AuthDevNode::getNodeId, authDevNode -> authDevNode, (node1, node2) -> node1));
    }
}

