/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.util;

import com.huawei.ism.tool.distributed.fru.common.Context;
import com.huawei.ism.tool.distributed.fru.model.entity.FruClusterNode;
import com.huawei.ism.tool.distributed.fru.model.entity.FruDevice;
import com.huawei.ism.tool.distributed.fru.model.entity.doc.DocConf;
import com.huawei.ism.tool.distributed.fru.model.entity.doc.DocRoute;
import com.huawei.ism.tool.distributed.fru.model.entity.doc.ItemDocConf;
import com.huawei.ism.tool.distributed.fru.model.entity.doc.ModuleDocConf;
import com.huawei.ism.tool.distributed.fru.model.entity.vo.DocInfoVo;
import com.huawei.ism.tool.distributed.fru.model.entity.vo.TaskReqInfoVO;
import com.huawei.ism.tool.distributed.fru.service.parser.DocRouteParser;
import com.huawei.ism.tool.distributed.fru.util.DeviceUtil;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocUtil {
    private static final Logger log = LoggerFactory.getLogger(DocUtil.class);
    public static final DocUtil INS = new DocUtil();

    public DocInfoVo matchModuleFruDoc(TaskReqInfoVO info) {
        Optional<FruClusterNode> node = DeviceUtil.INS.findClusterNodeByModuleDataId(info);
        Optional<FruDevice> fruDev = DeviceUtil.INS.findFruDev(info.getDeviceSn());
        DocConf conf = fruDev.get().getDevNode().isFusionCube() ? this.matchFusionCubeDoc(node.get(), info.getModuleId()) : this.matchDoc(node.get(), info.getModuleId());
        String url = this.getDocUrlByLanguage(conf, ApplicationContext.getInstance().isEnglishEnv());
        return DocInfoVo.builder().nodeModel(node.get().getNode().getModel()).ip(node.get().getNode().getManagementIp()).docUrl(url).build();
    }

    private DocConf matchFusionCubeDoc(FruClusterNode node, String moduleId) {
        String nodeType = node.getNode().getModel();
        ModuleDocConf conf = Context.INS.getFusionCubeModuleDocConf().get(moduleId);
        Optional<DocConf> targetDocConf = conf.getServersConf().stream().filter(serverDocConf -> serverDocConf.getSupportNodeType().contains(nodeType)).findFirst();
        if (!targetDocConf.isPresent()) {
            log.warn("Node {} type {} Can not match target doc,use default.", (Object)node.getNode().getManagementIp(), (Object)nodeType);
            return conf.getDefaultDocConf();
        }
        return targetDocConf.get();
    }

    public String getDocUrlByLanguage(DocConf conf, boolean isEnglishEnv) {
        if (isEnglishEnv) {
            return Paths.get("doc", conf.getRootDir(), "en", conf.getLinkEn()).toString();
        }
        return Paths.get("doc", conf.getRootDir(), "zh", conf.getLinkZh()).toString();
    }

    public DocConf matchDoc(FruClusterNode node, String moduleId) {
        String nodeType = node.getNode().getModel();
        ModuleDocConf conf = Context.INS.getModuleDocConf().get(moduleId);
        Optional<DocConf> targetDocConf = conf.getServersConf().stream().filter(serverDocConf -> serverDocConf.getSupportNodeType().contains(nodeType)).findFirst();
        if (!targetDocConf.isPresent()) {
            log.warn("Node {} type {} Can not match target doc,use default.", (Object)node.getNode().getManagementIp(), (Object)nodeType);
            return conf.getDefaultDocConf();
        }
        return targetDocConf.get();
    }

    public List<String> getSupportNodeModelsOfTargetModuleDoc(String moduleId) {
        return Context.INS.getModuleDocConf().get(moduleId).getServersConf().stream().map(DocConf::getSupportNodeType).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public String getItemDocUrl(String itemId, String docId) {
        return Context.INS.getItemDocConf().get(itemId).getDocs().stream().filter(doc -> Objects.equals(doc.getId(), docId)).findFirst().map(docConf -> this.getDocUrlByLanguage((DocConf)docConf, ApplicationContext.getInstance().isEnglishEnv())).orElse("");
    }

    public void parseAndSaveDocRoute(File docRouteFile) {
        ((Optional)DocRouteParser.INS.parse(docRouteFile)).ifPresent(this::saveDocRouteToContext);
    }

    public void parseAndSaveFusionCubeDocRoute(File docRouteFile) {
        ((Optional)DocRouteParser.INS.parse(docRouteFile)).ifPresent(this::saveFusionCubeDocRouteToContext);
    }

    private void saveFusionCubeDocRouteToContext(DocRoute docRoute) {
        Context.INS.setFusionCubeModuleDocConf(docRoute.getModuleDocConfs().stream().collect(Collectors.toMap(ModuleDocConf::getModuleId, Function.identity())));
        Context.INS.setFusionCubeItemDocConf(docRoute.getItemDocConfs().stream().collect(Collectors.toMap(ItemDocConf::getItemId, Function.identity())));
    }

    private void saveDocRouteToContext(DocRoute docRoute) {
        Context.INS.setModuleDocConf(docRoute.getModuleDocConfs().stream().collect(Collectors.toMap(ModuleDocConf::getModuleId, Function.identity())));
        Context.INS.setItemDocConf(docRoute.getItemDocConfs().stream().collect(Collectors.toMap(ItemDocConf::getItemId, Function.identity())));
    }
}

