/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.distributed.fru.common.Constants;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.rest.FusionCubeConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.python.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FusionCubeNodeTypeSupportUtil {
    private static final Logger log = LoggerFactory.getLogger(FusionCubeNodeTypeSupportUtil.class);
    private static final String SUPPORT_FILE = "support_type.xml";
    private static final String PATH = "fusion_cube";
    private static final String SUPPORT_FILE_PATH = Constants.PACKAGE_ROOT_DIR + File.separator + "fusion_cube" + File.separator + "support_type.xml";
    private static final Set<String> SUPPORT_TYPE = Sets.newHashSet();
    private static final FusionCubeNodeTypeSupportUtil INS = new FusionCubeNodeTypeSupportUtil();

    private FusionCubeNodeTypeSupportUtil() {
        this.init();
    }

    public static FusionCubeNodeTypeSupportUtil getInstance() {
        return INS;
    }

    private void init() {
        File file = new File(SUPPORT_FILE_PATH);
        if (!file.exists()) {
            log.info("support file not exits");
            return;
        }
        try (FileInputStream fl = new FileInputStream(file);){
            Document document = XmlUtils.parseDocument((InputStream)fl);
            NodeList supportType = XmlUtils.searchNodeByExp((Document)document, (String)"supportType");
            this.getSupportType(supportType);
        }
        catch (IOException e) {
            log.error("support file input error");
        }
    }

    private void getSupportType(NodeList supportType) {
        for (int i = 0; i < supportType.getLength(); ++i) {
            Node item = supportType.item(i);
            if (!(item instanceof Element)) continue;
            SUPPORT_TYPE.addAll(Arrays.stream(item.getTextContent().split(",")).map(String::trim).collect(Collectors.toSet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSupport(DevNode devNode, String managementIp) throws ToolException {
        try {
            JSONObject content;
            FusionCubeConnection connection = RestConnectionManager.getFusionCubeRestConnection((DevNode)devNode);
            JSONObject params = new JSONObject();
            params.put("filterChildDevice", (Object)0);
            params.put("appendFeature", (Object)1);
            params.put("deviceTypes", Arrays.asList("server", "network"));
            ResponseInfo responseInfo = connection.execPost(connection.getDeviceListUrl(), params.toString());
            if (responseInfo.isSuccess() && StringUtils.isNotEmpty((CharSequence)responseInfo.getContent()) && StringUtils.equals((CharSequence)"0", (CharSequence)(content = JSON.parseObject((String)responseInfo.getContent())).getString("code"))) {
                String deviceModel = this.getDeviceModel(responseInfo.getContent(), managementIp);
                boolean bl = SUPPORT_TYPE.contains(deviceModel);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            RestConnectionManager.releaseFusionCubeConnection((DevNode)devNode);
        }
    }

    private String getDeviceModel(String content, String managementIp) {
        JSONArray array = JSON.parseObject((String)content).getJSONObject("data").getJSONArray("dataList");
        for (int i = 0; i < array.size(); ++i) {
            if (!managementIp.equals(array.getJSONObject(i).getString("managementIp"))) continue;
            return array.getJSONObject(i).getString("deviceModel");
        }
        return "";
    }
}

