/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.devicemanager.entity.ProductUniqueIdConfig;
import com.huawei.ism.tool.distributed.fru.common.Constants;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.service.rest.service.device.RedfishConnectionManager;
import com.huawei.uMate.common.rest.RedfishConnestion;
import com.huawei.uMate.common.rest.RedfishResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.python.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeTypeSupportUtil {
    private static final Logger log = LoggerFactory.getLogger(NodeTypeSupportUtil.class);
    private static final String SUPPORT_FILE = "support_type.xml";
    private static final String PATH = "fusion_storage";
    private static final String SUPPORT_FILE_PATH = Constants.PACKAGE_ROOT_DIR + File.separator + "fusion_storage" + File.separator + "support_type.xml";
    private static final Set<String> SUPPORT_TYPE = Sets.newHashSet();
    public static final NodeTypeSupportUtil INS = new NodeTypeSupportUtil();

    protected NodeTypeSupportUtil() {
        this.init();
    }

    private void init() {
        File file = new File(SUPPORT_FILE_PATH);
        if (!file.exists()) {
            log.info("support file not exits");
            return;
        }
        try (FileInputStream fl = new FileInputStream(file);){
            Document document = XmlUtils.parseDocument((InputStream)fl);
            NodeList supportType = XmlUtils.searchNodeByExp((Document)document, (String)"supportType");
            this.getSupportType(supportType);
        }
        catch (IOException e) {
            log.error("support file input error");
        }
    }

    private void getSupportType(NodeList supportType) {
        for (int i = 0; i < supportType.getLength(); ++i) {
            Node item = supportType.item(i);
            if (!(item instanceof Element)) continue;
            SUPPORT_TYPE.addAll(Arrays.stream(item.getTextContent().split(",")).map(String::trim).collect(Collectors.toSet()));
        }
    }

    public boolean isSupport(DevNode devNode) throws ToolException {
        try {
            String productUniqueId = this.getProductUniqueIdByRedfish(devNode);
            return SUPPORT_TYPE.contains(this.getTypeId(productUniqueId));
        }
        catch (ToolException e) {
            RedfishConnectionManager.INS.releaseConn(devNode);
            log.error("redfish request error", (Throwable)e);
            throw e;
        }
    }

    private String getProductUniqueIdByRedfish(DevNode devNode) throws ToolException {
        RedfishConnestion redFishConnection = this.getRedfishConnestion(devNode);
        String resourceUri = this.getResourceUri(redFishConnection);
        RedfishResult result = redFishConnection.request("GET", resourceUri, new HashMap(), new HashMap(), null);
        String productUniqueId = this.getProductUidFromResult(result);
        log.info("productUniqueId:{}", (Object)productUniqueId);
        return productUniqueId;
    }

    private String getResourceUri(RedfishConnestion redFishConnection) throws ToolException {
        RedfishResult result = redFishConnection.request("GET", "/redfish/v1/Managers", new HashMap(), new HashMap(), null);
        this.checkResultStatus(result);
        JSONArray members = result.getResultJSON().getJSONArray("Members");
        for (int i = 0; i < members.size(); ++i) {
            JSONObject jsonObject = members.getJSONObject(i);
            String resourceUri = jsonObject.getString("@odata.id");
            if (StringUtils.isNULLStr((String)resourceUri)) continue;
            log.info("resource uri:{}", (Object)resourceUri);
            return resourceUri;
        }
        log.info("managers result:{}", (Object)result.getResultJSON());
        throw new ToolException("resource not found");
    }

    protected RedfishConnestion getRedfishConnestion(DevNode devNode) throws ToolException {
        return RedfishConnectionManager.INS.getRedFishConnection(devNode);
    }

    @NotNull
    private String getTypeId(String productUniqueId) {
        Optional typeIdByUid = ProductUniqueIdConfig.INS.getTypeIdByUid(productUniqueId);
        return typeIdByUid.orElse("");
    }

    private String getProductUidFromResult(RedfishResult result) throws ToolException {
        this.checkResultStatus(result);
        JSONObject oem = result.getResultJSON().getJSONObject("Oem");
        for (String s : oem.keySet()) {
            JSONObject jsonObject = oem.getJSONObject(s);
            String productUniqueID = jsonObject.getString("ProductUniqueID");
            if (StringUtils.isNULLStr((String)productUniqueID)) continue;
            return productUniqueID;
        }
        return "";
    }

    private void checkResultStatus(RedfishResult result) throws ToolException {
        if (!"200".equals(result.getStatusCode())) {
            log.error("redfish error:{}", (Object)result.getErrorMsg());
            throw new ToolException("redfish request error");
        }
    }
}

