/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.distributed.fru.util;

import com.huawei.ism.tool.distributed.fru.common.Context;
import com.huawei.ism.tool.distributed.fru.model.entity.FruClusterNode;
import com.huawei.ism.tool.distributed.fru.model.entity.FruDevice;
import com.huawei.ism.tool.distributed.fru.model.entity.Product;
import com.huawei.ism.tool.distributed.fru.model.entity.TaskConf;
import com.huawei.ism.tool.distributed.fru.model.entity.vo.TaskReqInfoVO;
import com.huawei.ism.tool.distributed.fru.model.module.Module;
import com.huawei.ism.tool.distributed.fru.util.DeviceUtil;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.service.rest.model.entity.BaseProduct;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class ProductUtil {
    private static final Logger log = LoggerFactory.getLogger(ProductUtil.class);
    public static final ProductUtil INS = new ProductUtil();

    public String getModuleName(ResourceBundle bundle, String moduleId) {
        return this.getScriptString(bundle, moduleId);
    }

    public String getTaskName(ResourceBundle bundle, TaskConf info) {
        return this.getScriptString(bundle, String.join((CharSequence)".", info.getResourceKey(), "name"));
    }

    public String getTaskDescription(ResourceBundle bundle, TaskConf info) {
        String key = String.join((CharSequence)".", info.getResourceKey(), "description");
        if (bundle.containsKey(key)) {
            return bundle.getString(key);
        }
        return "--";
    }

    public String getTaskSuggestion(ResourceBundle bundle, TaskConf info) {
        String key = String.join((CharSequence)".", info.getResourceKey(), "suggestion");
        if (bundle.containsKey(key)) {
            return bundle.getString(key);
        }
        return "--";
    }

    public String getScriptString(FruDevice device, String key) {
        return this.getScriptString(device.getProduct().getResBundle(), key);
    }

    public String getScriptString(ResourceBundle bundle, String key) {
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            log.warn("Can not find res {} .", (Object)key);
            return "--";
        }
    }

    public Module findModule(FruDevice device, String moduleId) {
        return device.getProduct().getSupportModules().stream().filter(module -> module.getId().equals(moduleId)).findFirst().get();
    }

    public Product matchProductByDev(DevNode node) {
        return Context.INS.getSupportProducts().stream().filter(product -> product.getProductModel().equals(node.getDeviceType().toString())).filter(product -> node.getProductVersion().contains(product.getProductVersion())).sorted(Comparator.comparing(BaseProduct::getProductVersion)).findFirst().get();
    }

    public List<Module> getAllSupportModules() {
        return Context.INS.getSupportProducts().stream().map(Product::getSupportModules).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    public List<Module> getDsStorageSupportModules() {
        return Context.INS.getSupportProducts().stream().filter(product -> !product.getProductModel().contains(ItDeviceType.FUSIONCUBE.getName())).map(Product::getSupportModules).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    public void updateSpecificConf(TaskConf taskConf, String level, String id, Consumer<TaskConf> update) {
        if (!StringUtils.equals((CharSequence)taskConf.getLevel(), (CharSequence)level)) {
            taskConf.getChildrenConf().forEach(task -> this.updateSpecificConf((TaskConf)task, level, id, update));
        }
        if (!StringUtils.equals((CharSequence)taskConf.getId(), (CharSequence)id)) {
            return;
        }
        update.accept(taskConf);
    }

    public TaskConf updateShowTimeAlarm(TaskConf sourceConf, TaskReqInfoVO info) {
        Optional<FruClusterNode> node = DeviceUtil.INS.findClusterNodeByModuleDataId(info);
        if (node.isPresent() && node.get().getNode().isPacificNode()) {
            return sourceConf;
        }
        TaskConf targetConf = TaskConf.builder().build();
        BeanUtils.copyProperties((Object)sourceConf, (Object)targetConf);
        INS.updateSpecificConf(targetConf, "step", "fruOperation", conf -> conf.setShowTimeAlarm(false));
        return targetConf;
    }
}

