/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common.resourcemanager;

import com.huawei.ism.common.bean.DeviceContext;
import com.huawei.ism.common.bean.ProductModelType;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.util.Assert;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class SpecsManager {
    private static final String SPERATOR = ".";
    private static ConcurrentHashMap<String, String> resourcesMap = new ConcurrentHashMap();

    private SpecsManager() {
    }

    public static void loadSpecsFile(String fileName) {
        Assert.notNull(fileName);
        Locale selectedLocale = ResourceManager.getLocale();
        ResourceBundle bundle = ResourceBundle.getBundle(fileName, selectedLocale);
        if (null == bundle) {
            return;
        }
        Set<String> keySet = bundle.keySet();
        for (String key : keySet) {
            resourcesMap.put(key, bundle.getString(key));
        }
    }

    public static int getSpecsBy(String deviceID, String key, DeviceContext deviceContext) {
        ProductModelType productModel;
        String resKey;
        String value;
        if (null == deviceContext) {
            String value2 = resourcesMap.get(key);
            return Integer.valueOf(value2);
        }
        String version = deviceContext.getProductVersion();
        if (version.length() > 8) {
            version = version.substring(0, 8);
        }
        if (null == (value = resourcesMap.get(resKey = (productModel = deviceContext.getDeviceModelType()).toString() + SPERATOR + version + SPERATOR + "SPECS" + SPERATOR + key))) {
            return 0;
        }
        return Integer.valueOf(value.trim());
    }
}

