/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tlv;

import com.huawei.ism.common.bean.Event;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.connection.TLVConnection;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.model.IMOKey;
import com.huawei.ism.model.MO;
import com.huawei.ism.model.MOKeyManager;
import com.huawei.ism.model.MOType;
import com.huawei.ism.model.QueryCondition;
import com.huawei.ism.model.UUID;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tlv.TLVMOMsg;
import com.huawei.ism.tlv.TLVMsgDefine;
import com.huawei.ism.tlv.TLVTag;
import com.huawei.ism.tlv.bean.DataPackage;
import com.huawei.ism.tlv.bean.MessageHead;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.tlv.bean.Record;
import com.huawei.ism.tlv.docoder.ParamType;
import com.huawei.ism.tlv.lang.IsmInteger;
import com.huawei.ism.tlv.lang.SignedInt32;
import com.huawei.ism.tlv.lang.SignedInt64;
import com.huawei.ism.tlv.lang.UnsignedInt16;
import com.huawei.ism.tlv.lang.UnsignedInt32;
import com.huawei.ism.tlv.lang.UnsignedInt64;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.util.ByteUtil;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TLVUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TLVUtils.class);

    private TLVUtils() {
    }

    public static MO record2MO(Record record, TLVMsgDefine metaData, String deviceID, MOType moType, TLVTag idTag) {
        int paramIndex = idTag.getParamIndex();
        Object paramValue = record.getParamValue(paramIndex);
        String idStr = paramValue != null ? paramValue.toString() : null;
        MO mo = new MO(deviceID, moType, idStr);
        Map<Object, Object> propertyMap = TLVUtils.record2Map(record, metaData);
        for (Map.Entry<Object, Object> entry : propertyMap.entrySet()) {
            mo.setProperty(entry.getKey(), entry.getValue());
        }
        mo.setMOType(moType);
        return mo;
    }

    public static Map<Integer, TLVTag> toTLVTagMap(List<IMOKey> mokeys) {
        HashMap<Integer, TLVTag> map = new HashMap<Integer, TLVTag>(0);
        if (mokeys == null) {
            return map;
        }
        TLVTag tag = null;
        for (IMOKey imoKey : mokeys) {
            if (!(imoKey instanceof TLVTag)) continue;
            tag = (TLVTag)imoKey;
            map.put(tag.getParamIndex(), tag);
        }
        return map;
    }

    public static Map<String, TLVTag> toTLVTagNameMap(List<IMOKey> mokeys) {
        HashMap<String, TLVTag> map = new HashMap<String, TLVTag>(0);
        if (mokeys == null) {
            return map;
        }
        TLVTag tag = null;
        for (IMOKey imoKey : mokeys) {
            if (!(imoKey instanceof TLVTag)) continue;
            tag = (TLVTag)imoKey;
            map.put(tag.getTagName(), tag);
        }
        return map;
    }

    public static MO record2MO(Record record, TLVMOMsg metaData, String deviceID) {
        MO mo = null;
        try {
            if (record == null) {
                LOGGER.error("record is null.");
                return null;
            }
            TLVUtils.checkParam(record, TLVMOMsg.ID);
            String idStr = record.getParamStrValue(TLVMOMsg.ID.getParamIndex());
            TLVUtils.checkParam(record, TLVMOMsg.TYPE);
            int typeValue = record.getParamIntValue(TLVMOMsg.TYPE.getParamIndex()) == null ? 0 : record.getParamIntValue(TLVMOMsg.TYPE.getParamIndex()).intValue();
            mo = new MO(deviceID, typeValue, idStr);
            IsmInteger parentType = record.getParamIntValue(TLVMOMsg.PARENTTYPE.getParamIndex());
            if (parentType != null) {
                int parenttypeValue = parentType.intValue();
                TLVUtils.checkParam(record, TLVMOMsg.PARENTID);
                String parentidStr = record.getParamStrValue(TLVMOMsg.PARENTID.getParamIndex());
                UUID parentUUID = new UUID(deviceID, parenttypeValue, parentidStr);
                mo.setParentUUID(parentUUID);
            }
            Map<Object, Object> propertyMap = TLVUtils.record2Map(record, metaData);
            for (Map.Entry<Object, Object> entry : propertyMap.entrySet()) {
                mo.setProperty(entry.getKey(), entry.getValue());
            }
        }
        catch (Throwable e) {
            LOGGER.error("record.getParamIntValue() is return null!");
            return null;
        }
        return mo;
    }

    private static void checkParam(Record record, TLVTag tlvTag) {
        Param param = record.getParam(tlvTag.getParamIndex());
        if (param == null) {
            throw new IsmException("record lack param " + tlvTag.toString() + " " + record.toString());
        }
    }

    public static MO record2MO(Record record, List<IMOKey> mokeys, String deviceID) {
        MO mo = null;
        try {
            TLVUtils.checkParam(record, TLVMOMsg.ID);
            String idStr = record.getParamStrValue(TLVMOMsg.ID.getParamIndex());
            TLVUtils.checkParam(record, TLVMOMsg.TYPE);
            int typeValue = record.getParamIntValue(TLVMOMsg.TYPE.getParamIndex()).intValue();
            mo = new MO(deviceID, typeValue, idStr);
            IsmInteger parentType = record.getParamIntValue(TLVMOMsg.PARENTTYPE.getParamIndex());
            if (parentType != null) {
                int parenttypeValue = parentType.intValue();
                TLVUtils.checkParam(record, TLVMOMsg.PARENTID);
                String parentidStr = record.getParamStrValue(TLVMOMsg.PARENTID.getParamIndex());
                UUID parentUUID = new UUID(deviceID, parenttypeValue, parentidStr);
                mo.setParentUUID(parentUUID);
            }
            Map<IMOKey, Object> propertyMap = TLVUtils.record2Map(record, mokeys);
            for (Map.Entry<IMOKey, Object> entry : propertyMap.entrySet()) {
                mo.setProperty(entry.getKey(), entry.getValue());
            }
        }
        catch (Throwable e) {
            LOGGER.error("record.getParamIntValue() is return null!");
            return null;
        }
        return mo;
    }

    public static Map<Object, Object> record2Map(Record record, TLVMsgDefine metaData) {
        if (null == record || record.getFieldCount() == 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>(0);
        TLVTag tagAsKey = null;
        Object retObj = null;
        for (Param param : record.getParams()) {
            tagAsKey = metaData.getTag(param.getIndex());
            if (tagAsKey == null) continue;
            retObj = null;
            try {
                retObj = TLVUtils.getRepresentValue(param);
            }
            catch (JSONException e) {
                LOGGER.error("", (Throwable)e);
                retObj = "";
            }
            result.put(tagAsKey, retObj);
        }
        return result;
    }

    public static Map<IMOKey, Object> record2Map(Record record, List<IMOKey> mokeys) {
        if (null == record || record.getFieldCount() == 0) {
            return Collections.EMPTY_MAP;
        }
        Map<Integer, TLVTag> metaData = TLVUtils.toTLVTagMap(mokeys);
        HashMap<IMOKey, Object> result = new HashMap<IMOKey, Object>(0);
        Object retObj = null;
        TLVTag tagAsKey = null;
        for (Param param : record.getParams()) {
            tagAsKey = metaData.get(param.getIndex());
            if (tagAsKey == null) continue;
            retObj = null;
            try {
                retObj = TLVUtils.getRepresentValue(param);
            }
            catch (JSONException e) {
                LOGGER.error("param:" + param.getIndex() + " in :" + record, (Throwable)e);
                retObj = "";
            }
            result.put(tagAsKey, retObj);
        }
        return result;
    }

    public static Param representValue2Param(TLVTag tag, Object value) {
        if (value == null || tag == null) {
            return null;
        }
        ParamType paramType = tag.getParamType();
        if (ParamType.STRING == paramType) {
            return new Param(tag.getParamIndex(), paramType, (String)value);
        }
        if (ParamType.UNSIGN_INT == paramType || ParamType.SIGN_INT == paramType) {
            return new Param(tag.getParamIndex(), paramType, (IsmInteger)value);
        }
        if (ParamType.ARRAY == paramType) {
            String str = ((JSONArray)value).toString();
            return new Param(tag.getParamIndex(), paramType, str);
        }
        if (ParamType.JSON == paramType) {
            String str = ((JSONObject)value).toString();
            return new Param(tag.getParamIndex(), paramType, str);
        }
        if (ParamType.BOOL == paramType) {
            boolean bool = (Boolean)value;
            if (bool) {
                return new Param(tag.getParamIndex(), paramType, (IsmInteger)new UnsignedInt32(1));
            }
            return new Param(tag.getParamIndex(), paramType, (IsmInteger)new UnsignedInt32(0));
        }
        if (ParamType.ENUM == paramType) {
            int intvalue = (Integer)value;
            return new Param(tag.getParamIndex(), paramType, (IsmInteger)new UnsignedInt32(intvalue));
        }
        if (ParamType.TIME == paramType) {
            Date date = (Date)value;
            return new Param(tag.getParamIndex(), paramType, (IsmInteger)new SignedInt64(date.getTime()));
        }
        return null;
    }

    private static Object getRepresentValue(Param param) throws JSONException {
        Object value = param.getValue();
        if (value == null) {
            return null;
        }
        ParamType paramType = param.getType();
        return TLVUtils.getRepresentValueDegred1(value, paramType);
    }

    private static Object getRepresentValueDegred1(Object value, ParamType paramType) throws JSONException {
        if (ParamType.STRING == paramType || ParamType.UNSIGN_INT == paramType || ParamType.SIGN_INT == paramType) {
            return value;
        }
        if (ParamType.ARRAY == paramType) {
            return new JSONArray((String)value);
        }
        if (ParamType.JSON == paramType) {
            return new JSONObject((String)value);
        }
        if (ParamType.BOOL == paramType) {
            return TLVUtils.getRepresentValueDegred(value);
        }
        if (ParamType.ENUM == paramType) {
            int enumValue = ((Number)value).intValue();
            return enumValue;
        }
        if (ParamType.TIME == paramType) {
            return new Date(((Number)value).longValue());
        }
        if (ParamType.MEMORY == paramType) {
            return value;
        }
        return null;
    }

    private static Object getRepresentValueDegred(Object value) {
        int boolValue = ((Number)value).intValue();
        if (boolValue > 0) {
            return true;
        }
        return false;
    }

    public static List<MO> record2MO(List<Record> recordList, TLVMsgDefine metaData, String deviceID, MOType moType, TLVTag idTag) {
        ArrayList<MO> moList = new ArrayList<MO>(recordList.size());
        for (Record record : recordList) {
            if (null == record || record.getParams().isEmpty()) continue;
            moList.add(TLVUtils.record2MO(record, metaData, deviceID, moType, idTag));
        }
        return moList;
    }

    public static List<MO> record2MO(List<Record> recordList, TLVMOMsg metaData, String deviceID) {
        ArrayList<MO> moList = new ArrayList<MO>(recordList.size());
        for (Record record : recordList) {
            moList.add(TLVUtils.record2MO(record, metaData, deviceID));
        }
        return moList;
    }

    public static List<MO> record2MO(List<Record> recordList, List<IMOKey> mokeys, String deviceID) {
        ArrayList<MO> moList = new ArrayList<MO>(recordList.size());
        for (Record record : recordList) {
            moList.add(TLVUtils.record2MO(record, mokeys, deviceID));
        }
        return moList;
    }

    public static Param newParam(int tag, ParamType type, Object value) {
        if (value instanceof String) {
            Param tlvParam = new Param(tag, type, (String)value);
            return tlvParam;
        }
        if (value instanceof IsmInteger) {
            Param tlvParam = new Param(tag, type, (IsmInteger)value);
            return tlvParam;
        }
        throw new IllegalArgumentException("value must be a String or IsmInteger Object");
    }

    public static Param newParam(TLVTag tag, boolean value) {
        ParamType paramType = tag.getParamType();
        if (ParamType.BOOL == paramType) {
            int intValue = value ? 1 : 0;
            return new Param(tag.getParamIndex(), paramType, (IsmInteger)new UnsignedInt32(intValue));
        }
        throw new IllegalArgumentException();
    }

    public static Param newParam(TLVTag tag, int value) {
        ParamType paramType = tag.getParamType();
        if (ParamType.STRING == paramType) {
            return new Param(tag.getParamIndex(), paramType, String.valueOf(value));
        }
        if (ParamType.UNSIGN_INT == paramType) {
            return new Param(tag.getParamIndex(), paramType, (IsmInteger)new UnsignedInt32(value));
        }
        if (ParamType.SIGN_INT == paramType) {
            return new Param(tag.getParamIndex(), paramType, (IsmInteger)new SignedInt32(value));
        }
        if (ParamType.ENUM == paramType) {
            return new Param(tag.getParamIndex(), paramType, (IsmInteger)new UnsignedInt32(value));
        }
        throw new IllegalArgumentException();
    }

    public static Param newParam(TLVTag tag, long value) {
        ParamType paramType = tag.getParamType();
        if (ParamType.STRING == paramType) {
            return new Param(tag.getParamIndex(), paramType, String.valueOf(value));
        }
        if (ParamType.UNSIGN_INT == paramType) {
            return new Param(tag.getParamIndex(), paramType, (IsmInteger)new UnsignedInt64(value));
        }
        if (ParamType.SIGN_INT == paramType) {
            return new Param(tag.getParamIndex(), paramType, (IsmInteger)new SignedInt64(value));
        }
        if (ParamType.ENUM == paramType) {
            return new Param(tag.getParamIndex(), paramType, (IsmInteger)new UnsignedInt32(value));
        }
        throw new IllegalArgumentException();
    }

    public static Param newParam(TLVTag tag, String value) {
        if (value == null || tag == null) {
            return null;
        }
        ParamType paramType = tag.getParamType();
        if (ParamType.STRING == paramType) {
            return new Param(tag.getParamIndex(), paramType, value);
        }
        throw new IllegalArgumentException();
    }

    public static Param newParam(TLVTag tag, Date value) {
        if (value == null || tag == null) {
            return null;
        }
        ParamType paramType = tag.getParamType();
        if (ParamType.TIME == paramType) {
            return new Param(tag.getParamIndex(), paramType, (IsmInteger)new SignedInt64(value.getTime()));
        }
        throw new IllegalArgumentException();
    }

    public static List<Param> singleItemList(int tag, ParamType type, Object value) {
        Param tlvParam = TLVUtils.newParam(tag, type, value);
        ArrayList<Param> dataList = new ArrayList<Param>(1);
        dataList.add(tlvParam);
        return dataList;
    }

    public static List<Param> singleItemList(Param tlvParam) {
        ArrayList<Param> dataList = new ArrayList<Param>(1);
        dataList.add(tlvParam);
        return dataList;
    }

    public static DataPackage receiveData(InputStream bisIn) {
        byte[] result;
        try {
            byte[] receiveDataHead = new byte[28];
            TLVUtils.fillBuffer(receiveDataHead, bisIn);
            byte[] tmp4Byte = new byte[4];
            System.arraycopy(receiveDataHead, 24, tmp4Byte, 0, tmp4Byte.length);
            int bufferLength = TLVUtils.bytes2int(tmp4Byte, false);
            result = new byte[28 + bufferLength];
            byte[] receiveDataBuf = new byte[bufferLength];
            TLVUtils.fillBuffer(receiveDataBuf, bisIn);
            System.arraycopy(receiveDataHead, 0, result, 0, 28);
            System.arraycopy(receiveDataBuf, 0, result, 28, receiveDataBuf.length);
        }
        catch (Exception e) {
            throw new IsmException(16797698L, (Throwable)e);
        }
        DataPackage receivedData = TLVUtils.decode(result);
        return receivedData;
    }

    private static void fillBuffer(byte[] receiveDataBuf, InputStream bis) throws IOException {
        int bufferLength = receiveDataBuf.length;
        int lengthBuf = 0;
        int lengthOfOnceRead = 0;
        for (int i = 0; i < 20; ++i) {
            lengthOfOnceRead = bis.read(receiveDataBuf, lengthBuf, bufferLength - lengthBuf);
            if (lengthOfOnceRead > -1) {
                lengthBuf += lengthOfOnceRead;
            }
            if (lengthBuf == bufferLength) break;
        }
        if (lengthBuf < bufferLength) {
            throw new IOException("should read length=" + bufferLength + ", but actually read length=" + lengthBuf);
        }
    }

    public static int bytes2int(byte[] bytes, boolean isHighFirst) {
        return (int)ByteUtil.bytes2long(bytes, isHighFirst);
    }

    public static DataPackage decode(byte[] msgData) throws IsmException {
        MessageHead head = new MessageHead(msgData);
        long retValue = head.getStatus();
        if (retValue != 0L) {
            throw new IsmException(retValue);
        }
        DataPackage dp = new DataPackage();
        dp.setHead(head);
        List<Record> recvDataList = TLVUtils.decode2Records(msgData, 28);
        dp.setRecordset(recvDataList);
        return dp;
    }

    public static List<Record> decode2Records(byte[] msgData, int headLength) {
        ByteArrayInputStream baiStream = new ByteArrayInputStream(msgData);
        long ret = baiStream.skip(headLength);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("return info:" + ret);
        }
        ArrayList<Record> recvDataList = new ArrayList<Record>(0);
        long msgCode = 0L;
        int recordLength = 0;
        byte[] recordBytes = null;
        Record recvData = null;
        List<Param> paramList = null;
        while (baiStream.available() > 0) {
            msgCode = new UnsignedInt64(TLVUtils.readBytes(baiStream, 8)).longValue();
            recordLength = new UnsignedInt16(TLVUtils.readBytes(baiStream, 2)).intValue();
            recordBytes = TLVUtils.readBytes(baiStream, recordLength);
            recvData = TLVUtils.decodeToRecord(recordBytes);
            recvData.setMsgCode(msgCode);
            paramList = recvData.getParams();
            if (paramList.isEmpty() && baiStream.available() > 0) {
                if (!LOGGER.isInfoEnabled()) continue;
                LOGGER.info("return empty record:" + recvData);
                continue;
            }
            if (paramList.isEmpty() && (!recvDataList.isEmpty() || !paramList.isEmpty())) continue;
            recvDataList.add(recvData);
        }
        return recvDataList;
    }

    public static Record decodeToRecord(byte[] recordBytes) throws IsmException {
        ByteArrayInputStream baiStream = new ByteArrayInputStream(recordBytes);
        Record recvData = new Record();
        short typeCmo = 0;
        short paramTypeValue = 0;
        ParamType paramType = null;
        short index = 0;
        int paramLength = 0;
        byte[] tlvBytes = null;
        Param param = null;
        while (baiStream.available() > 0) {
            typeCmo = new UnsignedInt16(TLVUtils.readBytes(baiStream, 2)).shortValue();
            paramTypeValue = (short)(typeCmo & 0xF);
            paramType = ParamType.getParamType(paramTypeValue);
            index = (short)(typeCmo >> 4 & 0xFFF);
            paramLength = new UnsignedInt16(TLVUtils.readBytes(baiStream, 2)).intValue();
            tlvBytes = TLVUtils.readBytes(baiStream, paramLength);
            param = new Param((int)index, paramType, tlvBytes);
            if (index == 4095) {
                if (paramType == ParamType.STRING) {
                    throw new IsmException(param.stringValue());
                }
                if ((paramType == ParamType.UNSIGN_INT || paramType == ParamType.SIGN_INT) && param.longValue() != 1L) {
                    if (param.longValue() == 0L) continue;
                    throw new IsmException(param.longValue());
                }
            }
            recvData.add(param);
        }
        return recvData;
    }

    static byte[] readBytes(InputStream is, int length) {
        byte[] bytes = new byte[length];
        if (length == 0) {
            return bytes;
        }
        int readLength = 0;
        try {
            readLength = is.read(bytes);
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(TLVUtils.class).error("read bytes error");
            throw new IsmException(16797698L, (Throwable)e);
        }
        if (readLength != length) {
            ToolLoggerFactory.getLogger(TLVUtils.class).error("read bytes no data error");
            throw new IllegalStateException(ResourceManager.getString("4294967297"));
        }
        return bytes;
    }

    public static boolean containTag(Record data, int tag) {
        for (Param param : data.getParams()) {
            if (param.getIndex() != tag) continue;
            return true;
        }
        return false;
    }

    public static List<Param> paramList(Param ... params) {
        ArrayList<Param> list = new ArrayList<Param>();
        for (Param param : params) {
            list.add(param);
        }
        return list;
    }

    public static List<Param> paramList(MOType moType, Map<IMOKey, Object> properties) {
        ArrayList<Param> list = new ArrayList<Param>(0);
        list.add(new Param(TLVMOMsg.TYPE.getParamIndex(), ParamType.ENUM, (IsmInteger)new UnsignedInt32(moType.getValue())));
        list.addAll(TLVUtils.paramList(properties));
        return list;
    }

    public static List<Param> paramList(Map<IMOKey, Object> properties) {
        ArrayList<Param> list = new ArrayList<Param>(0);
        TLVTag key = null;
        Object value = null;
        for (Map.Entry<IMOKey, Object> entry : properties.entrySet()) {
            if (!(entry.getKey() instanceof TLVTag)) continue;
            key = (TLVTag)entry.getKey();
            value = entry.getValue();
            Param param = new Param();
            param.setIndex(key.getParamIndex());
            param.setType(key.getParamType());
            if (value instanceof IsmInteger) {
                param.setValue(value);
            } else {
                param.setValue(value.toString());
            }
            list.add(param);
        }
        return list;
    }

    public static List<Record> recordList(Record ... records) {
        ArrayList<Record> list = new ArrayList<Record>(0);
        for (Record param : records) {
            list.add(param);
        }
        return list;
    }

    public static DataPackage param2DP(long cmdWord, String sessionKey, List<Param> tlvParams) {
        DataPackage dp = new DataPackage();
        MessageHead head = new MessageHead();
        if (cmdWord == 55847813121L) {
            head.setSessionKey(0L);
        } else {
            head.setSessionKey(Long.valueOf(sessionKey));
        }
        head.setVersion(3);
        head.setOperationCode(cmdWord);
        head.setNodeId((short)-3);
        dp.setHead(head);
        Record record = new Record();
        record.setMsgCode(cmdWord);
        if (null != tlvParams) {
            for (Param param : tlvParams) {
                record.add(param);
            }
        }
        dp.addRecord(record);
        return dp;
    }

    public static DataPackage param2DP(long cmdWord, String sessionKey, List<Param> tlvParams, TLVConnection.CMD_WORK_CONTRL workContrl) {
        DataPackage dp = TLVUtils.param2DP(cmdWord, sessionKey, tlvParams);
        MessageHead head = dp.getHead();
        head.setNodeId((short)-3);
        if (TLVConnection.CMD_WORK_CONTRL.CURRENT_CONTROLLER.equals((Object)workContrl)) {
            head.setNodeId((short)-1);
        }
        return dp;
    }

    public static DataPackage record2DP(long cmdWord, String sessionKey, List<Record> records) {
        DataPackage dp = new DataPackage();
        MessageHead head = new MessageHead();
        if (cmdWord == 55847813121L) {
            head.setSessionKey(0L);
        } else {
            head.setSessionKey(Long.valueOf(sessionKey));
        }
        head.setVersion(3);
        head.setOperationCode(cmdWord);
        dp.setHead(head);
        for (Record record2 : records) {
            dp.addRecord(record2);
        }
        return dp;
    }

    public static DataPackage record2DP(long cmdWord, String sessionKey, short serial, List<Record> records) {
        DataPackage dp = TLVUtils.record2DP(cmdWord, sessionKey, records);
        dp.getHead().setSerial(serial);
        return dp;
    }

    public static Event record2Event(String deviceID, Record record) {
        return TLVUtils.record2Event(deviceID, record, ResourceManager.getLocale());
    }

    public static Event record2Event(String deviceID, Record record, Locale loc) {
        Event event = null;
        try {
            int type = record.getParamIntValue(TLV.CMOAlarmInfoE.CMO_ALARM_TYPE.getParamIndex()).intValue();
            long eventID = record.getParamIntValue(TLV.CMOAlarmInfoE.CMO_ALARM_ID.getParamIndex()).longValue();
            int levelVal = record.getParamIntValue(TLV.CMOAlarmInfoE.CMO_ALARM_LEVEL.getParamIndex()).intValue();
            Event.Level level = Event.Level.valueOf(levelVal);
            long sn = record.getParamIntValue(TLV.CMOAlarmInfoE.CMO_ALARM_SEQUENCE.getParamIndex()).longValue();
            long startTime = record.getParamIntValue(TLV.CMOAlarmInfoE.CMO_ALARM_TIME.getParamIndex()).longValue();
            long resumeTime = record.getParamIntValue(TLV.CMOAlarmInfoE.CMO_ALARM_RECOVERY_TIME.getParamIndex(), new UnsignedInt16(0)).longValue();
            String param = record.getParamStrValue(TLV.CMOAlarmInfoE.CMO_ALARM_PARMETER.getParamIndex());
            Event.Identifier identifier = new Event.Identifier(deviceID, sn);
            event = new Event(identifier, level, eventID, param, loc);
            event.setStartTime(startTime);
            event.setRecoverTime(resumeTime);
            event.setType(Event.Type.valueOf(type));
        }
        catch (Throwable e) {
            LOGGER.error("record.getParamIntValue() is return null!");
            return null;
        }
        return event;
    }

    public static List<Event> record2Event(String deviceID, List<Record> records) {
        ArrayList<Event> events = new ArrayList<Event>(0);
        long errorcode = 0L;
        for (Record record : records) {
            if (!TLVUtils.containTag(record, 4095)) {
                events.add(TLVUtils.record2Event(deviceID, record));
                continue;
            }
            Object ismInteger = record.getParamValue(4095);
            if (null == ismInteger) {
                LOGGER.error("IsmInteger is null!");
                continue;
            }
            errorcode = ((IsmInteger)record.getParamValue(4095)).longValue();
            if (errorcode == 1L) continue;
            throw new IsmException(errorcode);
        }
        return events;
    }

    public static List<Param> mo2Params(MO mo, TLVMsgDefine msg) {
        List<TLVTag> tlvTags = msg.getTLVTags();
        TLVTag[] tags = tlvTags.toArray(new TLVTag[0]);
        return TLVUtils.mo2Params(mo, tags);
    }

    public static List<Param> mo2Params(MO mo, TLVTag[] tags) {
        ArrayList<Param> params = new ArrayList<Param>(0);
        Object property = null;
        Param param = null;
        for (TLVTag tlvTag : tags) {
            property = mo.getProperty(tlvTag);
            if (property == null) continue;
            try {
                param = TLVUtils.representValue2Param(tlvTag, property);
                if (null == param) continue;
                params.add(param);
            }
            catch (Exception e) {
                LOGGER.error(tlvTag.getTagName());
                throw new IsmException("representValue2Param error.", (Throwable)e);
            }
        }
        return params;
    }

    public static List<Param> mo2Params(Map<Object, Object> properties, TLVMsgDefine msg) {
        ArrayList<Param> params = new ArrayList<Param>(0);
        Param param = null;
        if (null == properties) {
            LOGGER.error("The mo2Params method in properties null.");
            return params;
        }
        for (Object tlvTag : properties.keySet()) {
            if (!(tlvTag instanceof TLVTag) || null == (param = TLVUtils.mo2Param(properties, (TLVTag)tlvTag))) continue;
            params.add(param);
        }
        return params;
    }

    public static Param mo2Param(Map<Object, Object> properties, TLVTag tlvTag) {
        Param param = TLVUtils.representValue2Param(tlvTag, properties.get(tlvTag));
        return param;
    }

    public static Param uuid2Param(UUID uuid, TLVTag tag) {
        String id = uuid.getID();
        switch (tag.getParamType()) {
            case UNSIGN_INT: {
                return new Param(tag.getParamIndex(), tag.getParamType(), (IsmInteger)new UnsignedInt32(new Long(id)));
            }
            case SIGN_INT: {
                return new Param(tag.getParamIndex(), tag.getParamType(), (IsmInteger)new SignedInt32(new Integer(id)));
            }
        }
        return new Param(tag.getParamIndex(), tag.getParamType(), id);
    }

    public static Param firstIDForGETNEXT(TLVTag idTag) {
        Param param = new Param(idTag.getParamIndex(), idTag.getParamType(), (IsmInteger)UnsignedInt32.ALL_FFFF);
        return param;
    }

    public static void notifySwitch(TLVConnection conn, boolean switchOp) {
        try {
            long cmd = switchOp ? 55847747634L : 55847747635L;
            conn.invoke(cmd, new ArrayList<Param>(0));
        }
        catch (IsmException e1) {
            LOGGER.error(switchOp + " switch fail on " + conn.getURL(), (Throwable)e1);
        }
    }

    public static List<Param> addParam(List<Param> tlvParams, Param ... publicParams) {
        ArrayList<Param> returnParams = new ArrayList<Param>(tlvParams.size() + publicParams.length);
        for (int i = 0; i < publicParams.length; ++i) {
            Param param = publicParams[i];
            returnParams.add(param);
        }
        for (Param param : tlvParams) {
            boolean exist = false;
            for (int i = 0; i < publicParams.length; ++i) {
                if (param.getIndex() != publicParams[i].getIndex()) continue;
                exist = true;
                break;
            }
            if (exist) continue;
            returnParams.add(param);
        }
        return returnParams;
    }

    public static Record errorCodeRecord(long errorcode) {
        Record record = new Record();
        record.add(new Param(4095, new UnsignedInt64(errorcode)));
        return record;
    }

    public static DataPackage errorCodePackage(long errorcode) {
        Record record = new Record();
        record.add(new Param(4095, new UnsignedInt64(errorcode)));
        return TLVUtils.record2DP(0L, "0", TLVUtils.recordList(record));
    }

    private static void propertyExp(StringBuffer queryStr, Map<String, TLVTag> nameMap, String exp) {
        String[] keyValueStr = exp.split("::");
        if (keyValueStr.length == 2) {
            TLVTag tag = nameMap.get(keyValueStr[0]);
            if (tag != null) {
                queryStr.append("\"" + tag.getParamIndex() + "\":\"" + keyValueStr[1] + "\"");
            }
            return;
        }
        keyValueStr = exp.split(":");
        if (keyValueStr.length == 2) {
            TLVTag tag = nameMap.get(keyValueStr[0]);
            if (tag != null) {
                if (keyValueStr[1].startsWith("(") || keyValueStr[1].startsWith("[")) {
                    queryStr.append("\"" + tag.getParamIndex() + "\":\"" + keyValueStr[1] + "\"");
                } else {
                    queryStr.append("\"" + tag.getParamIndex() + "\":\"LIKE " + keyValueStr[1] + "\"");
                }
            }
            return;
        }
        throw new IllegalArgumentException("query condition format error");
    }

    public static Param condition2Param(String deviceType, String cmd, QueryCondition condition) {
        List<IMOKey> mokeys = MOKeyManager.getInstance().getMethodKeyList(deviceType, cmd);
        return TLVUtils.condition2Param(mokeys, condition);
    }

    public static Param condition2Param(String deviceType, MOType moType, QueryCondition condition) {
        if (!(condition.hasFilter() || condition.hasRange() || condition.hasSort())) {
            return null;
        }
        List<IMOKey> mokeys = MOKeyManager.getInstance().getMOKeyList(deviceType, moType);
        return TLVUtils.condition2Param(mokeys, condition);
    }

    private static Param condition2Param(List<IMOKey> mokeys, QueryCondition condition) {
        Map<String, TLVTag> nameMap = TLVUtils.toTLVTagNameMap(mokeys);
        StringBuffer queryStr = new StringBuffer("{");
        String filter = condition.getFilter();
        if (filter != null) {
            TLVUtils.condition2ParamDegread(nameMap, queryStr, filter);
        }
        String sortBy = condition.getSort();
        String[] sortByStrs = null;
        if (sortBy != null && (sortByStrs = sortBy.split(",")).length > 0) {
            TLVTag tag = nameMap.get(sortByStrs[0]);
            if (tag != null) {
                queryStr.append(",\"sortby\":\"" + tag.getParamIndex());
            }
            if (sortByStrs.length > 1 && sortByStrs[1].equals("d")) {
                queryStr.append(" DESC\"");
            } else {
                queryStr.append(" \"");
            }
        }
        int start = condition.getStart();
        int end = condition.getEnd();
        if (start >= 0 && end > start) {
            queryStr.append(",\"range\":\"" + start + "-" + end + "\"");
        }
        queryStr.append('}');
        String queryJson = queryStr.toString();
        if (queryJson.startsWith("{,")) {
            queryJson = queryJson.replaceFirst("\\{,", "{");
        }
        return new Param(TLVMOMsg.QUERYCONDITION.getParamIndex(), ParamType.JSON, queryJson);
    }

    private static void condition2ParamDegread(Map<String, TLVTag> nameMap, StringBuffer queryStr, String filter) {
        queryStr.append("\"query\":[");
        String[] andExps = filter.split(" or ");
        String andExp = null;
        String[] exps = null;
        for (int i = 0; i < andExps.length; ++i) {
            andExp = andExps[i];
            queryStr.append('{');
            exps = andExp.split(" and ");
            for (int j = 0; j < exps.length; ++j) {
                TLVUtils.propertyExp(queryStr, nameMap, exps[j]);
                if (j >= exps.length - 1) continue;
                queryStr.append(',');
            }
            if (i >= andExps.length - 1) {
                queryStr.append('}');
                continue;
            }
            queryStr.append("},");
        }
        queryStr.append(']');
    }
}

