/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.forms.lockui;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.resourcemanager.CustomResourceManager;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.forms.lockui.RefreshUIThread;
import com.huawei.ism.ui.swing.RoundSpinner2;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.ValueMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoutTimeSettingDialog
extends IsmDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogoutTimeSettingDialog.class);
    private static final long serialVersionUID = 72393588953103220L;
    private LogoutTimeSettingPane dialogPane = null;
    private ValueMonitor valueMonitor = new ValueMonitor();

    public LogoutTimeSettingDialog() {
        super((Window)Framework.getInstance().getMainFrame(), ResourceManager.getString("PLATFORM_SYSTEM_SETTINGS"), IsmDialog.ECommonButton.Confirm, IsmDialog.ECommonButton.Apply, IsmDialog.ECommonButton.Cancel, IsmDialog.ECommonButton.Help);
        this.doLayoutUI();
        this.doInitTask();
        this.addHandler();
        this.setButtonStatus(false);
        if (ResourceManager.getLocale().getLanguage().equals("zh")) {
            this.setSize(new Dimension(400, 220));
        } else {
            this.setSize(new Dimension(455, 230));
        }
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        SwingUtil.putScreenCenter(this);
    }

    private void doLayoutUI() {
        this.getDialogContentPane().setLayout(new BorderLayout());
        this.dialogPane = new LogoutTimeSettingPane();
        this.getDialogContentPane().add((Component)this.dialogPane, "Center");
    }

    private void doInitTask() {
        String configTime = CustomResourceManager.getInstance().getString("custom.logouttime");
        if (CommonUtil.isNullStr(configTime)) {
            this.dialogPane.getMinutesSpinner().setValue(1);
            this.dialogPane.getMinutesSpinner().setValue(0);
            this.dialogPane.getHoursSpinner().setValue(1);
        } else if (this.getHour(configTime) == 12) {
            this.dialogPane.getHoursSpinner().setValue(12);
            this.dialogPane.getMinutesSpinner().setValue(1);
            this.dialogPane.getMinutesSpinner().setValue(0);
            this.dialogPane.getMinutesSpinner().setEnabled(false);
        } else {
            this.dialogPane.getHoursSpinner().setValue(this.getHour(configTime));
            this.dialogPane.getMinutesSpinner().setValue(1);
            this.dialogPane.getMinutesSpinner().setValue(this.getMinute(configTime));
        }
        this.valueMonitor.addCheckpoint((S[])new JSpinner[]{this.dialogPane.getHoursSpinner(), this.dialogPane.getMinutesSpinner()});
    }

    private void addHandler() {
        ChangeListener changeListener = e -> {
            this.setButtonStatus(this.valueMonitor.isValueChanged());
            this.handleMinute();
        };
        ((JSpinner.NumberEditor)this.dialogPane.getMinutesSpinner().getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                JFormattedTextField textField = (JFormattedTextField)keyEvent.getSource();
                LogoutTimeSettingDialog.this.setInputValue(textField, 59);
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                LogoutTimeSettingDialog.this.onKeyTyped(keyEvent);
            }
        });
        ((JSpinner.NumberEditor)this.dialogPane.getHoursSpinner().getEditor()).getTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                JFormattedTextField textField = (JFormattedTextField)keyEvent.getSource();
                LogoutTimeSettingDialog.this.setInputValue(textField, 12);
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                LogoutTimeSettingDialog.this.onKeyTyped(keyEvent);
            }
        });
        this.dialogPane.getHoursSpinner().addChangeListener(changeListener);
        this.dialogPane.getMinutesSpinner().addChangeListener(changeListener);
    }

    private void onKeyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() >= '0' && keyEvent.getKeyChar() <= '9') {
            return;
        }
        keyEvent.consume();
    }

    private void handleMinute() {
        if (12 == (Integer)this.dialogPane.getHoursSpinner().getValue()) {
            this.dialogPane.getMinutesSpinner().setValue(0);
            this.dialogPane.getMinutesSpinner().setEnabled(false);
        } else {
            this.dialogPane.getMinutesSpinner().setEnabled(true);
        }
    }

    private void setInputValue(JFormattedTextField textField, int maxValue) {
        int caretPosition = textField.getCaretPosition();
        textField.setText(String.valueOf(this.getValidInputValue(textField, maxValue)));
        try {
            textField.commitEdit();
        }
        catch (ParseException e1) {
            LOGGER.error("", (Throwable)e1);
        }
        try {
            textField.setCaretPosition(caretPosition);
        }
        catch (RuntimeException e) {
            textField.setCaretPosition(caretPosition - 1);
        }
    }

    private int getValidInputValue(JFormattedTextField textField, int maxValue) {
        int value;
        String inputStr = textField.getText();
        if ("".equals(inputStr)) {
            inputStr = "0";
        }
        int validLength = String.valueOf(maxValue).length() + 1;
        if (inputStr.length() > validLength) {
            inputStr = inputStr.substring(inputStr.length() - validLength);
        }
        if ((value = Integer.parseInt(inputStr)) >= maxValue) {
            value = maxValue;
        }
        return value;
    }

    @Override
    protected void doApplyTask() {
        if (this.getButtonBy(IsmDialog.ECommonButton.Apply).isEnabled() && this.doTask()) {
            this.getButtonBy(IsmDialog.ECommonButton.Apply).setEnabled(false);
        }
    }

    @Override
    protected void doConfirmTask() {
        if (this.getButtonBy(IsmDialog.ECommonButton.Apply).isEnabled()) {
            if (this.doTask()) {
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    private boolean doTask() {
        Integer hour = (Integer)this.dialogPane.getHoursSpinner().getValue();
        Integer minute = (Integer)this.dialogPane.getMinutesSpinner().getValue();
        int time = hour * 60 * 60 * 1000 + minute * 60 * 1000;
        if (time < 600000 || time > 43200000) {
            DialogUtils.showErrorDialog(this, ResourceManager.getString("session.timeout.bound.error.description"));
            return false;
        }
        CustomResourceManager.getInstance().setIntProperty("custom.logouttime", time);
        DialogUtils.showInfoDialog(this);
        RefreshUIThread refreshThread = Framework.getInstance().getRefreshUIThread();
        refreshThread.setIntervalTime(hour * 60 + minute);
        this.valueMonitor.flushValue();
        return true;
    }

    private void setButtonStatus(boolean status) {
        this.getButtonBy(IsmDialog.ECommonButton.Apply).setEnabled(status);
    }

    private int getHour(String configTime) {
        int config = Integer.parseInt(configTime);
        return config / 60000 / 60;
    }

    private int getMinute(String configTime) {
        int config = Integer.parseInt(configTime);
        if (config < 3600000) {
            return config / 60000;
        }
        return config / 60000 % 60;
    }

    @Override
    protected String getHelpKey() {
        return "system_set";
    }

    private static class LogoutTimeSettingPane
    extends JPanel {
        private static final long serialVersionUID = 8235169092923554554L;
        private JSpinner hoursSpinner;
        private JSpinner minutesSpinner;

        LogoutTimeSettingPane() {
            this.doLayoutUI();
        }

        private void doLayoutUI() {
            JLabel titleLabel = new JLabel(ResourceManager.getString("session.timeout.setting"));
            titleLabel.setFont(IsmFontFactory.getDialogBold());
            IsmTextArea descriptionTextArea = new IsmTextArea(true, true);
            descriptionTextArea.setText(ResourceManager.getString("session.timeout.setting.desctiption"));
            Box contentBox = UCD.buildVBoxTop(UCD.buildHBoxLeft(titleLabel), UCD.buildHBoxLeft(descriptionTextArea), Box.createVerticalStrut(1), UCD.buildHBoxLeft(this.createTimePanel()));
            contentBox.setBorder(UCD.createEmptyBorder(8));
            this.setLayout(new BorderLayout());
            this.add((Component)contentBox, "Center");
        }

        public JSpinner getHoursSpinner() {
            return this.hoursSpinner;
        }

        public JSpinner getMinutesSpinner() {
            return this.minutesSpinner;
        }

        private JPanel createTimePanel() {
            JLabel timeoutLabel = new JLabel(ResourceManager.getStringWithColon("session.timeout.time"));
            JLabel hourLabel = new JLabel(ResourceManager.getString("STORAGEPOOL.CREATE.WIZARD.THREE.HOURS"));
            JLabel minuteLabel = new JLabel(ResourceManager.getString("STORAGEPOOL.CREATE.WIZARD.THREE.MINUTES"));
            JLabel tipLabel = new JLabel(ResourceManager.getString("session.timeout.bound"));
            this.hoursSpinner = new RoundSpinner2(new SpinnerNumberModel(0, 0, 12, 1), "[0][0-9]||[0-9]||[1][0-2]");
            UCD.setJComponentSize(this.hoursSpinner, new Dimension(60, 23));
            this.minutesSpinner = new RoundSpinner2(new SpinnerNumberModel(0, 0, 59, 1), "[0-5][0-9]||[0-9]");
            UCD.setJComponentSize(this.minutesSpinner, new Dimension(60, 23));
            ArrayList<Pair<Component, Component>> pairs = new ArrayList<Pair<Component, Component>>(0);
            pairs.add(new Pair<JLabel, Box>(timeoutLabel, UCD.buildHBoxLeft(5, this.hoursSpinner, hourLabel, this.minutesSpinner, minuteLabel, Box.createHorizontalStrut(8), tipLabel)));
            return UCD.createRightKVPane(8, pairs);
        }
    }
}

