/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.notification;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GFCommon {
    private static final Logger LOGGER = LoggerFactory.getLogger(GFCommon.class);

    public static String hex2bin(String hex) {
        if (hex != null) {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put(Integer.toString(0), "0000");
            map.put(Integer.toString(1), "0001");
            map.put(Integer.toString(2), "0010");
            map.put(Integer.toString(3), "0011");
            map.put(Integer.toString(4), "0100");
            map.put(Integer.toString(5), "0101");
            map.put(Integer.toString(6), "0110");
            map.put(Integer.toString(7), "0111");
            map.put(Integer.toString(8), "1000");
            map.put(Integer.toString(9), "1001");
            map.put("F", "1111");
            map.put("E", "1110");
            map.put("D", "1101");
            map.put("C", "1100");
            map.put("B", "1011");
            map.put("A", "1010");
            return (String)map.get(hex.toUpperCase(ResourceManager.getLocale()));
        }
        return null;
    }

    public static boolean isHex(String hex) {
        if (hex != null) {
            String upperHex = hex.toUpperCase(ResourceManager.getLocale());
            char value = '\u0000';
            for (int i = 0; i < upperHex.length(); ++i) {
                value = upperHex.charAt(i);
                if (value >= '0' && (value <= '9' || value >= 'A') && value <= 'F') continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public static boolean isBinstr(String bin) {
        boolean result = false;
        if (bin != null) {
            byte[] b = bin.getBytes(Charset.defaultCharset());
            for (int i = 0; i < b.length; ++i) {
                if (b[i] == 48 || b[i] == 49) continue;
                return false;
            }
            return true;
        }
        return result;
    }

    public static boolean isLetter(String str) {
        if (str != null) {
            byte[] b = str.trim().toUpperCase(ResourceManager.getLocale()).getBytes(Charset.defaultCharset());
            for (int i = 0; i < b.length; ++i) {
                if (b[i] >= 65 && b[i] <= 90) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static long clong(String str) {
        if (str != null) {
            try {
                return new Long(str);
            }
            catch (NumberFormatException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        return -1L;
    }

    public static String fill(String src, int len) {
        String result = null;
        StringBuilder builder = new StringBuilder();
        if (src != null && src.length() <= len) {
            result = src;
            int zeroNums = len - src.length();
            for (int i = 0; i < zeroNums; ++i) {
                builder.append("0");
            }
        }
        builder.append(result);
        return builder.toString();
    }

    public static String insert(String src, String insertStr, int index) {
        StringBuffer result = new StringBuffer();
        if (StringUtils.isNULLStr(src)) {
            return result.append(insertStr).toString();
        }
        if (StringUtils.isNULLStr(insertStr)) {
            return result.append(src).toString();
        }
        result.append(src);
        if (index < 0) {
            if (index * -1 > src.length()) {
                result.insert(0, insertStr);
            } else {
                result.insert(src.length() + index + 1, insertStr);
            }
        } else if (index >= src.length()) {
            result.append(insertStr);
        } else {
            result.insert(index, insertStr);
        }
        return result.toString();
    }

    public static String bytes2hexstr(byte[] b) {
        return GFCommon.bytes2hexstr(b, false);
    }

    public static String bytes2hexstr(byte[] b, boolean highBitFirst) {
        String result = null;
        if (b != null && b.length > 0) {
            if (highBitFirst) {
                String hex = null;
                for (int i = b.length - 1; i >= 0; --i) {
                    hex = GFCommon.byte2hex(b[i]);
                    result = result == null ? hex : result + hex;
                }
            } else {
                String hex = null;
                for (int i = 0; i < b.length; ++i) {
                    hex = GFCommon.byte2hex(b[i]);
                    result = result == null ? hex : result + hex;
                }
            }
            if (null != result) {
                result = result.toUpperCase(ResourceManager.getLocale());
            }
        }
        return result;
    }

    public static String bytes2hexstr(byte[] b, int len) {
        String result = null;
        if (b != null && b.length > 0 && len <= b.length) {
            String hex = null;
            for (int i = 0; i < len; ++i) {
                hex = GFCommon.byte2hex(b[i]);
                result = result == null ? hex : result + hex;
            }
            if (null == result) {
                return null;
            }
            result = result.toUpperCase(ResourceManager.getLocale());
        }
        return result;
    }

    public static byte[] hexstr2bytes(String hexstr) {
        byte[] b = null;
        int len = 0;
        if (hexstr != null) {
            String hex = hexstr;
            if (hex.length() % 2 != 0) {
                hex = "0" + hex;
            }
            len = hex.length() / 2;
            b = new byte[len];
            String temp = hex + "0";
            int i = 0;
            int j = 0;
            while (i < temp.length() - 2) {
                b[j] = GFCommon.hex2byte(temp.substring(i, i + 2));
                i += 2;
                ++j;
            }
        }
        return b;
    }

    public static int hexstr2int(String hex) {
        if (hex != null && hex.length() <= 8) {
            char value = '\u0000';
            String upperHex = hex.toUpperCase(ResourceManager.getLocale());
            for (int i = 0; i < upperHex.length(); ++i) {
                value = upperHex.charAt(i);
                if (value >= '0' && (value <= '9' || value >= 'A') && value <= 'F') continue;
                return 0;
            }
            byte[] b = GFCommon.hexstr2bytes(upperHex);
            return GFCommon.bytes2int(b);
        }
        return 0;
    }

    public static byte hex2byte(String hex) {
        byte b = 0;
        char value = '\u0000';
        if (hex != null && hex.length() <= 2) {
            String upperHex = hex.toUpperCase(ResourceManager.getLocale());
            if (upperHex.length() == 0) {
                return 0;
            }
            if (upperHex.length() >= 1 && 0 == GFCommon.degradeForHex2Byte(upperHex, value = upperHex.charAt(0))) {
                return 0;
            }
            try {
                b = (byte)Integer.parseInt(upperHex, 16);
            }
            catch (NumberFormatException e) {
                ToolLoggerFactory.getLogger(GFCommon.class).error("NumberFormatException", (Throwable)e);
            }
        }
        return b;
    }

    private static int degradeForHex2Byte(String hex, int value) {
        char hexValue;
        if (value < 48 || value > 57 && value < 65 || value > 70) {
            return 0;
        }
        if (hex.length() == 2 && ((hexValue = hex.charAt(1)) < '0' || hexValue > '9' && hexValue < 'A' || hexValue > 'F')) {
            return 0;
        }
        return -1;
    }

    public static String byte2hex(byte b) {
        String result = null;
        result = Integer.toHexString(b >> 4 & 0xF);
        result = result + Integer.toHexString(b & 0xF);
        return result.toUpperCase(ResourceManager.getLocale());
    }

    public static String removeSpace(String s) {
        String rs = null;
        String s1 = null;
        if (s != null) {
            String str = s + " ";
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < str.length(); ++i) {
                s1 = str.substring(i, i + 1);
                if (s1.equals(" ")) continue;
                sb.append(s1);
            }
            rs = sb.toString();
        }
        return rs;
    }

    public static boolean isAlphanumeric(String str) {
        if (str != null) {
            byte[] bs;
            for (byte b : bs = str.getBytes(Charset.defaultCharset())) {
                boolean b1;
                boolean bl = b1 = b < 48 || b > 57 && b < 65 || b > 90;
                if ((!b1 || b >= 97) && b <= 122) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static byte[] int2bytes(int aa, boolean isHighFirst) {
        byte[] result = new byte[4];
        if (isHighFirst) {
            result[0] = (byte)(aa >> 24 & 0xFF);
            result[1] = (byte)(aa >> 16 & 0xFF);
            result[2] = (byte)(aa >> 8 & 0xFF);
            result[3] = (byte)(aa & 0xFF);
        } else {
            result[3] = (byte)(aa >> 24 & 0xFF);
            result[2] = (byte)(aa >> 16 & 0xFF);
            result[1] = (byte)(aa >> 8 & 0xFF);
            result[0] = (byte)(aa & 0xFF);
        }
        return result;
    }

    public static byte[] int2bytes(int aa) {
        return GFCommon.int2bytes(aa, true);
    }

    public static int bytes2int(byte[] b) {
        return (int)GFCommon.bytes2long(b);
    }

    public static int bytes2int(byte[] b, boolean isHighFirst) {
        return (int)GFCommon.bytes2long(b, isHighFirst);
    }

    public static long bytes2long(byte[] b) {
        return GFCommon.bytes2long(b, true);
    }

    public static long bytes2long(byte[] b, boolean isHighFirst) {
        long result;
        block4: {
            result = 0L;
            if (b == null || b.length > 8) break block4;
            if (isHighFirst) {
                int i = b.length - 1;
                int j = 0;
                while (i >= 0) {
                    long value = b[i] & 0xFF;
                    result += value << (j << 3);
                    --i;
                    ++j;
                }
            } else {
                int i = 0;
                int j = 0;
                while (i < b.length - 1) {
                    long value = b[i] & 0xFF;
                    result += value << (j << 3);
                    ++i;
                    ++j;
                }
            }
        }
        return result;
    }

    public static byte[] long2bytes(long value) {
        return GFCommon.long2bytes(value, true);
    }

    public static byte[] long2bytes(long value, boolean isHighFirst) {
        byte[] b = new byte[8];
        if (isHighFirst) {
            for (int i = 0; i < 8; ++i) {
                b[i] = (byte)(value >> 8 * (7 - i) & 0xFFL);
            }
        } else {
            int i = 0;
            int j = 7;
            while (i < 8) {
                b[j] = (byte)(value >> 8 * (7 - i) & 0xFFL);
                ++i;
                --j;
            }
        }
        return b;
    }

    public static String getSystemInfo() {
        String result = "os.name:" + System.getProperty("os.name") + "\nos.arch:" + System.getProperty("os.arch") + "\n\njava.vendor:" + System.getProperty("java.vendor") + "\njava.home:" + System.getProperty("java.home") + "\njava.version:" + System.getProperty("java.version") + "\njava.vm.version:" + System.getProperty("java.vm.version") + "\n\nuser.name:" + System.getProperty("user.name") + "\nuser.dir:" + System.getProperty("user.dir");
        return result;
    }

    public static int getUnsigned(byte b) {
        if (b > 0) {
            return b;
        }
        return b & 0xFF;
    }
}

