/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.task;

import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.ui.module.task.BackgroundTask;
import com.huawei.ism.ui.module.task.BackgroundTaskListener;
import com.huawei.ism.ui.module.task.BgroudTaskRecord;
import com.huawei.ism.ui.module.task.IBatchTaskParser;
import com.huawei.ism.ui.module.task.ITaskParser;
import com.huawei.ism.ui.module.task.TaskFilter;
import com.huawei.ism.ui.module.task.TaskManagerFrame;
import com.huawei.ism.util.SwingUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskManager.class);
    private static TaskManager instance = new TaskManager();
    private static final ReentrantReadWriteLock RWL = new ReentrantReadWriteLock();
    private static final ReentrantReadWriteLock.WriteLock WLOCK = RWL.writeLock();
    private static final ReentrantReadWriteLock.ReadLock RLOCK = RWL.readLock();
    private Map<Class<?>, ITaskParser<?>> taskParserMap = new ConcurrentHashMap();
    private Map<Class<?>, IBatchTaskParser<?>> batchTaskParserMap = new ConcurrentHashMap();
    private List<BackgroundTask> taskList = new ArrayList<BackgroundTask>(0);
    private TaskManagerFrame frame;
    private List<BackgroundTaskListener> listeners = new ArrayList<BackgroundTaskListener>(0);

    private TaskManager() {
    }

    public static TaskManager getInstance() {
        return instance;
    }

    public void registerITaskParser(Class<?> classObj, ITaskParser<?> parser) {
        if (null == classObj || null == parser) {
            throw new IllegalArgumentException("The task parser cannot be null!");
        }
        if (this.taskParserMap.containsKey(classObj)) {
            return;
        }
        this.taskParserMap.put(classObj, parser);
    }

    public void registerIBatchTaskParser(Class<?> classObj, IBatchTaskParser<?> parser) {
        if (null == classObj || null == parser) {
            throw new IllegalArgumentException("The task parser cannot be null!");
        }
        if (this.batchTaskParserMap.containsKey(classObj)) {
            return;
        }
        this.batchTaskParserMap.put(classObj, parser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(final BackgroundTask taskCarrier) {
        if (null == taskCarrier || taskCarrier.getTaskSN().length() <= 0) {
            return;
        }
        Launcher launcher = LauncherManager.getInstance().getLauncher(taskCarrier.getDviceId());
        if (null != launcher && Launcher.State.STOPPED.equals((Object)launcher.getState())) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Can't Add task,the launcher state:" + (Object)((Object)launcher.getState()));
                LOGGER.info("Can't Add task,the task is:" + taskCarrier);
            }
            return;
        }
        if (null != launcher && LOGGER.isInfoEnabled()) {
            LOGGER.info("Add task success,the launcher state:" + (Object)((Object)launcher.getState()));
            LOGGER.info("Add task success,the task is:" + taskCarrier);
        }
        try {
            WLOCK.lock();
            this.taskList.add(taskCarrier);
        }
        catch (Exception e) {
            LOGGER.error("add back ground task error:", (Throwable)e);
        }
        finally {
            WLOCK.unlock();
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (null != TaskManager.this.frame) {
                    TaskManager.this.frame.fireTableRowsInserted(taskCarrier);
                }
                TaskManager.this.notifyListener();
            }
        };
        SwingUtil.runInEventDispatchThread(run);
    }

    public void removeTask(final BackgroundTask taskCarrier) {
        try {
            WLOCK.lock();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("remove back ground task:" + taskCarrier);
            }
            this.taskList.remove(taskCarrier);
        }
        catch (Exception e) {
            LOGGER.error("remove back ground task error:", (Throwable)e);
        }
        finally {
            WLOCK.unlock();
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (null != TaskManager.this.frame) {
                    TaskManager.this.frame.fireTableRowsDeleted(taskCarrier);
                }
                TaskManager.this.notifyListener();
            }
        };
        SwingUtil.runInEventDispatchThread(run);
    }

    public void updateTask(BackgroundTask task) {
        TaskFilter taskFilter = TaskFilter.createTaskSNFilter(task.getTaskSN());
        List<BackgroundTask> existedTasks = this.getTask(taskFilter);
        if (existedTasks.isEmpty()) {
            this.addTask(task);
            return;
        }
        boolean isBgroundTaskExist = false;
        for (BackgroundTask existedTask : existedTasks) {
            boolean bl = isBgroundTaskExist = existedTask != null;
            if (isBgroundTaskExist && task.isRemoveOnCompleted()) {
                this.removeTask(existedTask);
                continue;
            }
            if (null == existedTask) continue;
            this.fireUpdateTask(task);
        }
    }

    private void updateTaskState(String taskSN, BackgroundTask.State newState) {
        if (null == taskSN || null == newState) {
            LOGGER.info("update Task State Failed, SN is nll or state is null.");
            return;
        }
        TaskFilter taskFilter = TaskFilter.createTaskSNFilter(taskSN);
        List<BackgroundTask> tasks = this.getTask(taskFilter);
        for (BackgroundTask task : tasks) {
            task.setState(newState);
            this.updateTask(task);
            if (!LOGGER.isInfoEnabled()) continue;
            LOGGER.info("update Task State Success, SN =" + taskSN + ", state = " + (Object)((Object)newState));
        }
    }

    private void fireUpdateTask(final BackgroundTask task) {
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("change back ground task :" + task);
            }
            WLOCK.lock();
            if (!this.taskList.contains(task)) {
                this.addTask(task);
            } else {
                this.taskList.remove(task);
                this.taskList.add(task);
            }
        }
        catch (Exception e) {
            LOGGER.error("change back ground task error:", (Throwable)e);
        }
        finally {
            WLOCK.unlock();
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (null != TaskManager.this.frame) {
                    TaskManager.this.frame.fireTableRowsUpdated(task);
                }
                TaskManager.this.notifyListener();
            }
        };
        SwingUtil.runInEventDispatchThread(run);
    }

    public void removeTask(TaskFilter filter) {
        List<BackgroundTask> filterTasks = this.getTask(filter);
        for (BackgroundTask task : filterTasks) {
            this.removeTask(task);
        }
    }

    public List<BackgroundTask> getTask(TaskFilter filter) {
        if (null == filter) {
            return new ArrayList<BackgroundTask>(0);
        }
        ArrayList<BackgroundTask> list = new ArrayList<BackgroundTask>(0);
        ArrayList<BackgroundTask> tasks = new ArrayList<BackgroundTask>(0);
        tasks.addAll(this.taskList);
        this.fillTasksToLists(filter, list, tasks);
        return list;
    }

    private void fillTasksToLists(TaskFilter filter, List<BackgroundTask> list, List<BackgroundTask> tasks) {
        for (BackgroundTask task : tasks) {
            if (!filter.include(task)) continue;
            list.add(task);
        }
    }

    public void removeTask(Object component) {
        if (null == component) {
            return;
        }
        ITaskParser<?> taskParser = this.getTaskParser(component.getClass());
        if (null == taskParser) {
            return;
        }
        String taskSN = taskParser.getTaskSN(component);
        if (null == taskSN) {
            return;
        }
        List<BackgroundTask> tasks = this.getTask(TaskFilter.createTaskSNFilter(taskSN));
        if (tasks.isEmpty()) {
            return;
        }
        for (BackgroundTask currentTask : tasks) {
            if (null == currentTask) continue;
            this.removeTask(currentTask);
        }
    }

    public void updateTask(Object component) {
        if (null == component) {
            return;
        }
        ITaskParser<?> singleTaskParser = this.getTaskParser(component.getClass());
        if (null != singleTaskParser) {
            this.updateSingleTask(singleTaskParser, component);
            return;
        }
        IBatchTaskParser<Object> batchTaskParser = this.getBatchTaskParser(component.getClass());
        if (null != batchTaskParser) {
            this.updateBatchTask(batchTaskParser, component);
            return;
        }
    }

    private void updateSingleTask(ITaskParser<? super Object> taskParser, Object component) {
        String taskSN = taskParser.getTaskSN(component);
        if (null == taskSN) {
            return;
        }
        BackgroundTask.State state = taskParser.getTaskState(component);
        if (state == BackgroundTask.State.FAILED) {
            this.updateTaskState(taskSN, state);
            return;
        }
        BackgroundTask newTask = taskParser.createTask(component);
        if (null != newTask) {
            this.updateTask(newTask);
            return;
        }
        TaskFilter taskFilter = TaskFilter.createTaskSNFilter(taskSN);
        List<BackgroundTask> existedTasks = this.getTask(taskFilter);
        if (existedTasks.isEmpty()) {
            return;
        }
        for (BackgroundTask task : existedTasks) {
            if (null == task || !taskParser.removedOnCompleted(component)) continue;
            this.removeTask(task);
        }
    }

    private void updateBatchTask(IBatchTaskParser<Object> batchTaskParser, Object component) {
        Collection<?> sources = batchTaskParser.getTaskSources(component);
        for (Object source : sources) {
            this.updateTask(source);
        }
    }

    public void clearUnavailabeTask() {
    }

    private synchronized ITaskParser<?> getTaskParser(Class<?> clazz) {
        if (null == clazz) {
            return null;
        }
        try {
            ITaskParser<?> taskParser = this.taskParserMap.get(clazz);
            if (null == taskParser) {
                return this.getTaskParser(clazz.getSuperclass());
            }
            return taskParser;
        }
        catch (Exception e) {
            LOGGER.error("get task parser error:" + clazz, (Throwable)e);
            return null;
        }
    }

    private synchronized IBatchTaskParser<?> getBatchTaskParser(Class<?> clazz) {
        if (null == clazz) {
            return null;
        }
        try {
            IBatchTaskParser<?> batchTaskParser = this.batchTaskParserMap.get(clazz);
            if (null == batchTaskParser) {
                return this.getBatchTaskParser(clazz.getSuperclass());
            }
            return batchTaskParser;
        }
        catch (Exception e) {
            LOGGER.error("get batch task parser error: ", (Throwable)e);
            return null;
        }
    }

    public void showDialog() {
        if (null == this.frame) {
            this.frame = new TaskManagerFrame(this.taskList);
        }
        SwingUtil.putScreenCenter(this.frame);
        this.frame.setVisible(true);
    }

    private BgroudTaskRecord statisticTasks(List<BackgroundTask> tasks) {
        boolean haveFaultTask = false;
        boolean haveRunningTask = false;
        boolean haveWarningTask = false;
        int successTaskCount = 0;
        int failedTaskCount = 0;
        int count = 0;
        BackgroundTask.State state = null;
        for (BackgroundTask task : tasks) {
            if (null == task) continue;
            state = task.getState();
            if (BackgroundTask.State.RUNNING_NORMAL == state) {
                haveRunningTask = true;
            } else if (BackgroundTask.State.FAILED == state) {
                haveFaultTask = true;
                ++failedTaskCount;
            } else if (BackgroundTask.State.RUNNING_WARNING == state) {
                haveWarningTask = true;
            } else if (BackgroundTask.State.COMPLETED_NORMAL == state) {
                ++successTaskCount;
            }
            if (!haveFaultTask || !haveRunningTask) continue;
            break;
        }
        count = tasks.size();
        return new BgroudTaskRecord(haveFaultTask, haveRunningTask, haveWarningTask, count);
    }

    private void notifyListener() {
        BgroudTaskRecord record = null;
        try {
            RLOCK.lock();
            record = this.statisticTasks(this.taskList);
        }
        finally {
            RLOCK.unlock();
        }
        for (BackgroundTaskListener listener : this.listeners) {
            listener.taskChanged(record);
        }
    }

    public void addBackgroundTaskListener(BackgroundTaskListener backgroundTaskListener) {
        this.listeners.add(backgroundTaskListener);
    }

    public void removeFrame() {
        this.frame = null;
    }

    public List<BackgroundTask> getAllTaskList() {
        return this.taskList;
    }

    public static enum Operation {
        Start,
        Stop,
        Pause,
        RemoveSelected,
        RemoveCompleted,
        RemoveFailed;

    }
}

