/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.control;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public abstract class ImgsAssembledPane
extends JPanel {
    private static final long serialVersionUID = -8306450534238577891L;
    private Style style1;

    public ImgsAssembledPane(Style style) {
        this.style1 = style;
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
    }

    public Style getStyle() {
        return this.style1;
    }

    public abstract ImageIcon getLeftUPIcon();

    public abstract ImageIcon getCenterIcon();

    public abstract ImageIcon getRightDownIcon();

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        ImageIcon leftUPIcon = this.getLeftUPIcon();
        ImageIcon centerIcon = this.getCenterIcon();
        ImageIcon rightDownIcon = this.getRightDownIcon();
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.style1 == Style.HORIZONAL) {
            graphics.drawImage(leftUPIcon.getImage(), 0, 0, leftUPIcon.getIconWidth(), leftUPIcon.getIconHeight(), this);
            graphics.drawImage(centerIcon.getImage(), leftUPIcon.getIconWidth(), 0, width - leftUPIcon.getIconWidth() - rightDownIcon.getIconWidth(), centerIcon.getIconHeight(), this);
            graphics.drawImage(rightDownIcon.getImage(), width - rightDownIcon.getIconWidth(), 0, rightDownIcon.getIconWidth(), rightDownIcon.getIconHeight(), this);
        } else {
            graphics.drawImage(leftUPIcon.getImage(), 0, 0, leftUPIcon.getIconWidth(), leftUPIcon.getIconHeight(), this);
            graphics.drawImage(centerIcon.getImage(), 0, leftUPIcon.getIconHeight(), centerIcon.getIconWidth(), height - leftUPIcon.getIconHeight() - rightDownIcon.getIconHeight(), this);
            graphics.drawImage(rightDownIcon.getImage(), 0, height - rightDownIcon.getIconHeight(), rightDownIcon.getIconWidth(), rightDownIcon.getIconHeight(), this);
        }
    }

    public static class VerticalSeparator
    extends ImgsAssembledPane {
        private static final long serialVersionUID = 8362738424035205487L;
        private static final ImageIcon UP_BG_ICON = ResourceManager.getImage("vertical_separator_up.png");
        private static final ImageIcon CENTER_BG_ICON = ResourceManager.getImage("vertical_separator_center.png");
        private static final ImageIcon DOWN_BG_ICON = ResourceManager.getImage("vertical_separator_down.png");

        public VerticalSeparator() {
            super(Style.VERTICAL);
            Box box = Box.createVerticalBox();
            box.add(Box.createRigidArea(new Dimension(this.getLeftUPIcon().getIconWidth(), 0)));
            this.add(box);
        }

        @Override
        public ImageIcon getCenterIcon() {
            return CENTER_BG_ICON;
        }

        @Override
        public ImageIcon getLeftUPIcon() {
            return UP_BG_ICON;
        }

        @Override
        public ImageIcon getRightDownIcon() {
            return DOWN_BG_ICON;
        }
    }

    public static final class HorizonalSeparator
    extends ImgsAssembledPane {
        private static final long serialVersionUID = -4748831905134912799L;
        private static final ImageIcon LEFT_BG_ICON = ResourceManager.getImage("LRGradientSeparator_leftBG.png");
        private static final ImageIcon CENTER_BG_ICON = ResourceManager.getImage("LRGradientSeparator_centerBG.png");
        private static final ImageIcon RIGHT_BG_ICON = ResourceManager.getImage("LRGradientSeparator_rightBG.png");
        private ImageIcon leftIcon = LEFT_BG_ICON;
        private ImageIcon centerIcon = CENTER_BG_ICON;
        private ImageIcon rightIcon = RIGHT_BG_ICON;

        public HorizonalSeparator() {
            super(Style.HORIZONAL);
            Box box = Box.createHorizontalBox();
            box.add(Box.createRigidArea(new Dimension(0, this.getLeftUPIcon().getIconHeight())));
            this.add(box);
        }

        public HorizonalSeparator(ImageIcon leftIcon, ImageIcon centerIcon, ImageIcon rightIcon) {
            this();
            if (null == leftIcon || null == centerIcon || null == rightIcon) {
                throw new IllegalArgumentException("The bg icon cannot be null");
            }
            this.leftIcon = leftIcon;
            this.centerIcon = centerIcon;
            this.rightIcon = rightIcon;
        }

        @Override
        public ImageIcon getCenterIcon() {
            return this.centerIcon;
        }

        @Override
        public ImageIcon getLeftUPIcon() {
            return this.leftIcon;
        }

        @Override
        public ImageIcon getRightDownIcon() {
            return this.rightIcon;
        }

        @Override
        public void setPreferredSize(Dimension preferredSize) {
            super.setPreferredSize(new Dimension(preferredSize.width, this.leftIcon.getIconHeight()));
        }

        public void setPreferredWidth(int width) {
            this.setPreferredSize(new Dimension(width, LEFT_BG_ICON.getIconHeight()));
            this.setMaximumSize(new Dimension(width, LEFT_BG_ICON.getIconHeight()));
        }
    }

    public static enum Style {
        HORIZONAL,
        VERTICAL;

    }
}

