/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import com.huawei.ism.ui.swing.plaf.IsmButtonStyle;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsmButtonUI
extends BasicButtonUI {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsmButtonUI.class);
    private static final IsmButtonUI INSTANCE = new IsmButtonUI();
    private Color focusColor;
    private Color selectColor;
    private Color disabledTextColor;

    public static ComponentUI createUI(JComponent x) {
        return INSTANCE;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AbstractButton button = null;
        if (jComponent instanceof AbstractButton) {
            button = (AbstractButton)jComponent;
        }
        if (null == button) {
            LOGGER.error("The button parameter is null.");
            return;
        }
        if (jComponent.getBackground() instanceof UIResource && button.isContentAreaFilled() && jComponent.isEnabled()) {
            ButtonModel model = button.getModel();
            if (!model.isPressed() && model.isRollover()) {
                this.paintButtonRollover(graphics, button);
                this.paint(graphics, jComponent);
                return;
            }
            if (!model.isArmed() && !model.isPressed()) {
                this.paintButtonNormal(graphics, button);
                this.paint(graphics, jComponent);
                return;
            }
        }
        this.updateDiabledButton(graphics, jComponent);
        super.update(graphics, jComponent);
    }

    protected void updateDiabledButton(Graphics graphics, JComponent jComponent) {
        if (!jComponent.isEnabled() && !(jComponent.getParent() instanceof JToolBar)) {
            IsmButtonStyle style = (IsmButtonStyle)UIManager.get("Button.style");
            IsmPlafUtils.drawDualGradient((Component)jComponent, graphics, style.getGradientUL(IsmButtonStyle.ButtonState.DISABLED), style.getGradientDR(IsmButtonStyle.ButtonState.DISABLED), new Rectangle(1, 1, jComponent.getWidth() - 2, jComponent.getHeight() - 2), true);
        }
    }

    @Override
    protected void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        LookAndFeel.installProperty(abstractButton, "opaque", Boolean.FALSE);
    }

    protected Color getSelectColor() {
        this.selectColor = UIManager.getColor(this.getPropertyPrefix() + "select");
        return this.selectColor;
    }

    protected Color getDisabledTextColor() {
        this.disabledTextColor = UIManager.getColor(this.getPropertyPrefix() + "disabledText");
        return this.disabledTextColor;
    }

    protected Color getFocusColor() {
        this.focusColor = UIManager.getColor(this.getPropertyPrefix() + "focus");
        return this.focusColor;
    }

    @Override
    protected void paintFocus(Graphics graphics, AbstractButton button, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (!(button.getParent() instanceof JToolBar)) {
            Rectangle buttonRect = button.getBounds();
            Rectangle focusRect = new Rectangle();
            focusRect.width = buttonRect.width - 8;
            focusRect.height = buttonRect.height - 8;
            focusRect.setLocation(4, 4);
            graphics.setColor(this.getFocusColor());
            BasicGraphicsUtils.drawDashedRect(graphics, (int)focusRect.getX() - 1, (int)focusRect.getY() - 1, focusRect.width + 1, focusRect.height + 2);
        }
    }

    @Override
    protected void paintButtonPressed(Graphics graphics, AbstractButton button) {
        this.setTextShiftOffset();
        IsmButtonStyle style = null;
        style = !(button.getParent() instanceof JToolBar) ? (IsmButtonStyle)UIManager.get("Button.style") : (IsmButtonStyle)UIManager.get("ToolBarButton.style");
        IsmPlafUtils.drawDualGradient((Component)button, graphics, style.getGradientUL(IsmButtonStyle.ButtonState.PRESSED), style.getGradientDR(IsmButtonStyle.ButtonState.PRESSED), new Rectangle(1, 1, button.getWidth() - 2, button.getHeight() - 2), true);
    }

    protected void paintButtonRollover(Graphics graphics, AbstractButton button) {
        IsmButtonStyle style = null;
        style = !(button.getParent() instanceof JToolBar) ? (IsmButtonStyle)UIManager.get("Button.style") : (IsmButtonStyle)UIManager.get("ToolBarButton.style");
        IsmPlafUtils.drawDualGradient((Component)button, graphics, style.getGradientUL(IsmButtonStyle.ButtonState.ROLLOVER), style.getGradientDR(IsmButtonStyle.ButtonState.ROLLOVER), new Rectangle(1, 1, button.getWidth() - 2, button.getHeight() - 2), true);
    }

    protected void paintButtonNormal(Graphics graphics, AbstractButton button1) {
        if (!(button1.getParent() instanceof JToolBar)) {
            IsmButtonStyle style1 = (IsmButtonStyle)UIManager.get("Button.style");
            IsmButtonStyle.ButtonState state = button1.hasFocus() ? IsmButtonStyle.ButtonState.ROLLOVER : IsmButtonStyle.ButtonState.NORMAL;
            IsmPlafUtils.drawDualGradient((Component)button1, graphics, style1.getGradientUL(state), style1.getGradientDR(state), new Rectangle(1, 1, button1.getWidth() - 2, button1.getHeight() - 2), true);
        }
    }
}

