/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import com.huawei.ism.ui.swing.ImagePanel;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PanelUI;
import javax.swing.plaf.basic.BasicPanelUI;

public class IsmImagePanelUI
extends BasicPanelUI {
    private static PanelUI panelUI;

    public static ComponentUI createUI(JComponent c) {
        if (null == panelUI) {
            panelUI = new IsmImagePanelUI();
        }
        return panelUI;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        if (!(jComponent instanceof ImagePanel)) {
            return;
        }
        ImagePanel panel = (ImagePanel)jComponent;
        ImageIcon bgImg = panel.getBackgroundImage();
        if (null != panel.getOrientation() && null != bgImg) {
            int imgWidth = bgImg.getIconWidth();
            int imgHeight = bgImg.getIconHeight();
            int width = jComponent.getWidth();
            int height = jComponent.getHeight();
            this.paintBackground(graphics, jComponent, panel, bgImg, imgWidth, imgHeight, width, height);
            return;
        }
        if (null != bgImg) {
            graphics.drawImage(bgImg.getImage(), 0, 0, jComponent);
        }
    }

    private void paintBackground(Graphics graphics, JComponent jComponent, ImagePanel panel, ImageIcon bgImg, int imgWidth, int imgHeight, int width, int height) {
        switch (panel.getOrientation()) {
            case HORIZONAL: {
                graphics.drawImage(bgImg.getImage(), 0, 0, width, imgHeight, jComponent);
                break;
            }
            case VETICAL: {
                graphics.drawImage(bgImg.getImage(), 0, 0, imgWidth, height, jComponent);
                break;
            }
            case VERTICAL_BOTTOM_TO_TOP: {
                if (imgHeight >= height) {
                    graphics.drawImage(bgImg.getImage(), 0, 0, jComponent);
                    break;
                }
                graphics.drawImage(bgImg.getImage(), 0, height - imgHeight, jComponent);
                break;
            }
            case HORIZONAL_AND_VETICAL: {
                for (int ix = 0; ix < width; ix += imgWidth) {
                    for (int iy = 0; iy < height; iy += imgHeight) {
                        graphics.drawImage(bgImg.getImage(), ix, iy, jComponent);
                    }
                }
                break;
            }
        }
    }
}

