/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import com.huawei.ism.ui.swing.plaf.IsmTextFieldUI;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PasswordView;
import javax.swing.text.Position;
import javax.swing.text.View;

public class IsmPasswordFieldUI
extends IsmTextFieldUI {
    public static ComponentUI createUI(JComponent c) {
        return new IsmPasswordFieldUI();
    }

    @Override
    protected String getPropertyPrefix() {
        return "PasswordField";
    }

    @Override
    public View create(Element elem) {
        return new IsmPasswordView(elem);
    }

    private static class IsmPasswordView
    extends PasswordView {
        private int ancho = 7;
        private int hueco = 3;

        public IsmPasswordView(Element elem) {
            super(elem);
        }

        @Override
        protected int drawEchoCharacter(Graphics graphics, int xx, int yy, char cc) {
            int charWidth = this.getFontMetrics().charWidth(cc);
            charWidth = charWidth < this.ancho ? this.ancho : charWidth;
            int hh = (this.getContainer().getHeight() - this.ancho) / 2;
            Graphics2D g2D = (Graphics2D)graphics;
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.fillOval(xx, hh + 1, charWidth, charWidth);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            return xx + charWidth + this.hueco;
        }

        @Override
        public Shape modelToView(int pos, Shape shape, Position.Bias bias) throws BadLocationException {
            Container container = this.getContainer();
            if (container instanceof JPasswordField) {
                JPasswordField container1 = (JPasswordField)container;
                if (!container1.echoCharIsSet()) {
                    return super.modelToView(pos, shape, bias);
                }
                char echoChar = container1.getEchoChar();
                int charWidth = container1.getFontMetrics(container1.getFont()).charWidth(echoChar);
                charWidth = (charWidth < this.ancho ? this.ancho : charWidth) + this.hueco;
                Rectangle alloc = this.adjustAllocation(shape).getBounds();
                int dx = (pos - this.getStartOffset()) * charWidth;
                int allocX = (int)alloc.getX();
                if ((allocX += dx - 2) <= 5) {
                    allocX = 6;
                }
                alloc.width = 1;
                alloc.setLocation(allocX, (int)alloc.getY());
                return alloc;
            }
            return null;
        }

        @Override
        public int viewToModel(float fx, float fy, Shape shape, Position.Bias[] bias) {
            bias[0] = Position.Bias.Forward;
            int counter = 0;
            Container container = this.getContainer();
            if (container instanceof JPasswordField) {
                JPasswordField container1 = (JPasswordField)container;
                if (!container1.echoCharIsSet()) {
                    return super.viewToModel(fx, fy, shape, bias);
                }
                char echoChar = container1.getEchoChar();
                int charWidth = container1.getFontMetrics(container1.getFont()).charWidth(echoChar);
                charWidth = (charWidth < this.ancho ? this.ancho : charWidth) + this.hueco;
                Shape actualShape = this.adjustAllocation(shape);
                Rectangle alloc = actualShape instanceof Rectangle ? (Rectangle)actualShape : actualShape.getBounds();
                counter = ((int)fx - (int)alloc.getX()) / charWidth;
                if (counter < 0) {
                    counter = 0;
                } else if (counter > this.getStartOffset() + this.getDocument().getLength()) {
                    counter = this.getDocument().getLength() - this.getStartOffset();
                }
            }
            return this.getStartOffset() + counter;
        }
    }
}

