/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import com.huawei.ism.ui.swing.plaf.IsmButtonStyle;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public class IsmToggleButtonUI
extends BasicToggleButtonUI {
    private static final IsmToggleButtonUI INSTANCE = new IsmToggleButtonUI();
    private Color focusColor;
    private Color selectColor;
    private Color disabledTextColor;
    private boolean defaultsInitialized = false;

    public static ComponentUI createUI(JComponent b) {
        return INSTANCE;
    }

    @Override
    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        if (!this.defaultsInitialized) {
            this.focusColor = UIManager.getColor(this.getPropertyPrefix() + "focus");
            this.setSelectColor(UIManager.getColor(this.getPropertyPrefix() + "select"));
            this.disabledTextColor = UIManager.getColor(this.getPropertyPrefix() + "disabledText");
            this.defaultsInitialized = true;
        }
        LookAndFeel.installProperty(abstractButton, "opaque", Boolean.FALSE);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AbstractButton button = null;
        if (!(jComponent instanceof AbstractButton)) {
            return;
        }
        button = (AbstractButton)jComponent;
        if (jComponent.getBackground() instanceof UIResource && button.isContentAreaFilled() && jComponent.isEnabled()) {
            ButtonModel model = button.getModel();
            if (!model.isPressed() && model.isRollover()) {
                this.paintButtonRollover(graphics, button);
                this.paint(graphics, jComponent);
                return;
            }
            if (!model.isArmed() && !model.isPressed()) {
                this.paintButtonNormal(graphics, button);
                this.paint(graphics, jComponent);
                return;
            }
        }
        super.update(graphics, jComponent);
    }

    @Override
    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.defaultsInitialized = false;
    }

    protected Color getSelectColor() {
        return this.selectColor;
    }

    protected Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    @Override
    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        IsmButtonStyle style = null;
        style = !(abstractButton.getParent() instanceof JToolBar) ? (IsmButtonStyle)UIManager.get("ToggleButton.style") : (IsmButtonStyle)UIManager.get("ToolBarButton.style");
        IsmPlafUtils.drawDualGradient((Component)abstractButton, graphics, style.getGradientUL(IsmButtonStyle.ButtonState.PRESSED), style.getGradientDR(IsmButtonStyle.ButtonState.PRESSED), new Rectangle(1, 1, abstractButton.getWidth() - 2, abstractButton.getHeight() - 2), true);
    }

    @Override
    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (!(abstractButton.getParent() instanceof JToolBar)) {
            Rectangle focusRect = new Rectangle();
            Rectangle buttonRect = abstractButton.getBounds();
            focusRect.x = 4;
            focusRect.y = 4;
            focusRect.width = buttonRect.width - 8;
            focusRect.height = buttonRect.height - 8;
            graphics.setColor(this.getFocusColor());
            BasicGraphicsUtils.drawDashedRect(graphics, focusRect.x - 1, focusRect.y - 1, focusRect.width + 1, focusRect.height + 2);
        }
    }

    protected void paintButtonRollover(Graphics graphics, AbstractButton button) {
        IsmButtonStyle style = null;
        style = !(button.getParent() instanceof JToolBar) ? (IsmButtonStyle)UIManager.get("ToggleButton.style") : (IsmButtonStyle)UIManager.get("ToolBarButton.style");
        IsmPlafUtils.drawDualGradient((Component)button, graphics, style.getGradientUL(IsmButtonStyle.ButtonState.ROLLOVER), style.getGradientDR(IsmButtonStyle.ButtonState.ROLLOVER), new Rectangle(1, 1, button.getWidth() - 2, button.getHeight() - 2), true);
    }

    protected void paintButtonNormal(Graphics graphics, AbstractButton button2) {
        if (!(button2.getParent() instanceof JToolBar)) {
            IsmButtonStyle style2 = (IsmButtonStyle)UIManager.get("ToggleButton.style");
            IsmButtonStyle.ButtonState state = button2.hasFocus() ? IsmButtonStyle.ButtonState.ROLLOVER : IsmButtonStyle.ButtonState.NORMAL;
            IsmPlafUtils.drawDualGradient((Component)button2, graphics, style2.getGradientUL(state), style2.getGradientDR(state), new Rectangle(1, 1, button2.getWidth() - 2, button2.getHeight() - 2), true);
        }
    }

    public void setFocusColor(Color focusColor) {
        this.focusColor = focusColor;
    }

    public void setSelectColor(Color selectColor) {
        this.selectColor = selectColor;
    }

    public void setDisabledTextColor(Color disabledTextColor) {
        this.disabledTextColor = disabledTextColor;
    }
}

