/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.armor;

import com.huawei.ism.ui.swing.control.ToolBarButton;
import com.huawei.ism.ui.swing.plaf.IsmBorders;
import com.huawei.ism.ui.swing.plaf.IsmButtonStyle;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;

public class ArmorBorders {
    public static Border getTableHeaderBorder() {
        return new TableHeaderBorder(null);
    }

    public static Border getTableHeaderBorder(Insets insert) {
        return new TableHeaderBorder(insert);
    }

    public static Border getSequenceTableHeaderBorder() {
        return new SequenceTableHeaderBorder();
    }

    public static Border getArmorRolloverButtonBorder(boolean drawArrow) {
        if (drawArrow) {
            return new BorderUIResource.CompoundBorderUIResource(new ArmorRolloverButtonBorder(), new EmptyBorder(0, 7, 0, 15));
        }
        return new BorderUIResource.CompoundBorderUIResource(new ArmorRolloverButtonBorder(), new EmptyBorder(0, 7, 0, 7));
    }

    public static Border getArmorButtonBorder(boolean isRound) {
        return new BorderUIResource.CompoundBorderUIResource(new ArmorButtonBorder(isRound), new IsmBorders.MarginBorder());
    }

    public static Border getToolBarButtonBorder(boolean isRound) {
        return new BorderUIResource.CompoundBorderUIResource(new ArmorButtonBorder(isRound), new EmptyBorder(0, 2, 0, 2));
    }

    public static Border getToolBarBorder() {
        return new ArmorToolBarBorder();
    }

    public static Border getFrameBorder() {
        return new BorderUIResource.EmptyBorderUIResource(0, 0, 0, 0);
    }

    public static Border getDialogBorder(boolean round) {
        return new BorderUIResource(new WindowBorder(round));
    }

    public static Border getArmorTextFieldBorder() {
        return new BorderUIResource.CompoundBorderUIResource(new IsmBorders.TextFieldBorder(), new EmptyBorder(0, 5, 0, 0));
    }

    public static Border getArmorFilterTextFieldBorder() {
        return new BorderUIResource.CompoundBorderUIResource(new IsmBorders.TextFieldBorder(), new EmptyBorder(0, 1, 0, 0));
    }

    private static class WindowBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = -5759662583826912139L;
        private static Insets insets = new Insets(1, 1, 1, 1);
        private boolean round = true;

        public WindowBorder(boolean round) {
            this.round = round;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xx, int yy, int width, int height) {
            Color background = UIManager.getColor("TitleBar.dialogBorderColor");
            IsmPlafUtils.drawBorderStyle(graphics, background, background, new Rectangle(xx, yy, width, height), this.round);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return insets;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = WindowBorder.insets.top;
            newInsets.left = WindowBorder.insets.left;
            newInsets.bottom = WindowBorder.insets.bottom;
            newInsets.right = WindowBorder.insets.right;
            return newInsets;
        }
    }

    private static class ArmorRolloverButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 1L;
        private static Insets buttonInsets = new Insets(0, 0, 0, 0);

        private ArmorRolloverButtonBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xx, int yy, int width, int height) {
            if (!(component instanceof AbstractButton)) {
                return;
            }
            AbstractButton button = (AbstractButton)component;
            IsmButtonStyle style = (IsmButtonStyle)UIManager.get("ArmorButton.style");
            IsmButtonStyle.ButtonState state = IsmPlafUtils.getRolloverButtonState(button);
            if (state == IsmButtonStyle.ButtonState.ROLLOVER || state == IsmButtonStyle.ButtonState.PRESSED || state == IsmButtonStyle.ButtonState.SELECTED) {
                state = IsmButtonStyle.ButtonState.ROLLOVER;
            } else if (state != IsmButtonStyle.ButtonState.NONE) {
                state = IsmButtonStyle.ButtonState.NORMAL;
            }
            IsmPlafUtils.drawArmorButtonBorder(style, state, graphics, new Rectangle(xx, yy, width, height), true);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return buttonInsets;
        }

        @Override
        public Insets getBorderInsets(Component component, Insets newInsets) {
            newInsets.top = this.getBorderInsets((Component)component).top;
            newInsets.left = this.getBorderInsets((Component)component).left;
            newInsets.bottom = this.getBorderInsets((Component)component).bottom;
            newInsets.right = this.getBorderInsets((Component)component).right;
            return newInsets;
        }
    }

    private static class ArmorToolBarBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 8343966141200657215L;

        private ArmorToolBarBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return UIManager.getInsets("IsmToolBar.Insets");
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets1) {
            Insets inset = this.getBorderInsets(component);
            insets1.top = inset.top;
            insets1.left = inset.left;
            insets1.bottom = inset.bottom;
            insets1.right = inset.right;
            return insets1;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xx, int yy, int width, int height) {
            if (!(component instanceof JToolBar)) {
                return;
            }
            graphics.setColor(UIManager.getColor("IsmToolBar.TopBorderColor"));
            graphics.fillRect(xx, yy, width, 1);
            graphics.setColor(UIManager.getColor("IsmToolBar.bottomBorderColor"));
            graphics.fillRect(xx + 1, yy + 1, width, 1);
        }
    }

    private static class ArmorButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 1L;
        private static Insets toolbarButtonInsets = new Insets(1, 1, 1, 1);
        private static Insets buttonInsets = new Insets(0, 3, 0, 3);
        private boolean isRound;

        public ArmorButtonBorder(boolean isRound) {
            this.isRound = isRound;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xx, int yy, int width, int height) {
            if (!(component instanceof AbstractButton)) {
                return;
            }
            AbstractButton button = (AbstractButton)component;
            IsmButtonStyle style = (IsmButtonStyle)UIManager.get("ArmorButton.style");
            if (button.getParent() instanceof JComboBox) {
                style = (IsmButtonStyle)UIManager.get("ArmorComboBoxButton.style");
            }
            if (IsmPlafUtils.isButtonOnToolBar(button)) {
                style = (IsmButtonStyle)UIManager.get("ArmorToolBarButton.style");
            }
            IsmButtonStyle.ButtonState state = this.getButtonState(button, style);
            IsmPlafUtils.drawArmorButtonBorder(style, state, graphics, new Rectangle(xx, yy, width, height), this.isRound);
        }

        private IsmButtonStyle.ButtonState getButtonState(AbstractButton button, IsmButtonStyle style) {
            IsmButtonStyle.ButtonState state = IsmPlafUtils.getButtonState(button);
            if (null == style.getBorderColor(state) || null == style.getBorderCornerColor(state)) {
                if (state == IsmButtonStyle.ButtonState.ROLLOVER || state == IsmButtonStyle.ButtonState.PRESSED || state == IsmButtonStyle.ButtonState.SELECTED) {
                    state = IsmButtonStyle.ButtonState.ROLLOVER;
                } else if (state != IsmButtonStyle.ButtonState.NONE && state != IsmButtonStyle.ButtonState.DEFAULT) {
                    state = IsmButtonStyle.ButtonState.NORMAL;
                }
            }
            return state;
        }

        @Override
        public Insets getBorderInsets(Component component) {
            if (component instanceof ToolBarButton) {
                return toolbarButtonInsets;
            }
            return buttonInsets;
        }

        @Override
        public Insets getBorderInsets(Component component, Insets newInsets) {
            Insets insets = this.getBorderInsets(component);
            newInsets.top = insets.top;
            newInsets.left = insets.left;
            newInsets.bottom = insets.bottom;
            newInsets.right = insets.right;
            return newInsets;
        }
    }

    private static class SequenceTableHeaderBorder
    extends AbstractBorder {
        protected static final Insets TABLE_CELL_BORDER = new Insets(0, 0, 2, 0);
        private static final Color TABLEHEADER_SEPERATOR_COLOR = new Color(0x8D8D8D);
        private static final Color TABLEHEADER_BOTTOM_COLOR = new Color(0xFFFFFF);
        private static final long serialVersionUID = 1L;

        private SequenceTableHeaderBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xx, int yy, int width, int height) {
            graphics.translate(xx, yy);
            graphics.setColor(TABLEHEADER_SEPERATOR_COLOR);
            graphics.drawLine(39, 4, 39, height - 5);
            graphics.drawLine(width - 1, 4, width - 1, height - 5);
            graphics.setColor(TABLEHEADER_BOTTOM_COLOR);
            graphics.drawLine(0, height - 1, width - 1, height - 1);
            graphics.translate(-xx, -yy);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return TABLE_CELL_BORDER;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.left = SequenceTableHeaderBorder.TABLE_CELL_BORDER.left;
            insets.top = SequenceTableHeaderBorder.TABLE_CELL_BORDER.top;
            insets.right = SequenceTableHeaderBorder.TABLE_CELL_BORDER.right;
            insets.bottom = SequenceTableHeaderBorder.TABLE_CELL_BORDER.bottom;
            return insets;
        }
    }

    private static class TableHeaderBorder
    extends AbstractBorder {
        private static final Color TABLEHEADER_SEPERATOR_COLOR = new Color(0x8D8D8D);
        private static final Color TABLEHEADER_BOTTOM_COLOR = new Color(0xFFFFFF);
        private static final long serialVersionUID = 1L;
        private Insets tableCellBorder;

        public TableHeaderBorder(Insets insert) {
            this.tableCellBorder = null != insert ? insert : new Insets(0, 10, 2, 10);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xx, int yy, int width, int height) {
            graphics.translate(xx, yy);
            graphics.setColor(TABLEHEADER_SEPERATOR_COLOR);
            graphics.drawLine(width - 1, 4, width - 1, height - 5);
            graphics.setColor(TABLEHEADER_BOTTOM_COLOR);
            graphics.drawLine(0, height - 1, width - 1, height - 1);
            graphics.translate(-xx, -yy);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.left = this.tableCellBorder.left;
            insets.top = this.tableCellBorder.top;
            insets.right = this.tableCellBorder.right;
            insets.bottom = this.tableCellBorder.bottom;
            return insets;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.tableCellBorder;
        }
    }
}

