/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.armor;

import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.plaf.armor.ArmorTitleBarPane;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class ArmorButtonUI
extends BasicButtonUI {
    private static final ArmorButtonUI ARMOR_BUTTONUI_INSTANCE = new ArmorButtonUI();

    public static ComponentUI createUI(JComponent x) {
        return ARMOR_BUTTONUI_INSTANCE;
    }

    @Override
    protected void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        LookAndFeel.installProperty(abstractButton, "opaque", Boolean.FALSE);
    }

    @Override
    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        LookAndFeel.installProperty(abstractButton, "opaque", Boolean.TRUE);
    }

    @Override
    public void update(Graphics graphics, JComponent jc) {
        if (!(jc instanceof AbstractButton)) {
            super.update(graphics, jc);
            return;
        }
        AbstractButton button = (AbstractButton)jc;
        if (jc.getBackground() instanceof UIResource && button.isContentAreaFilled() && jc.isEnabled()) {
            ButtonModel model = button.getModel();
            if (!model.isPressed() && model.isRollover()) {
                this.paintButtonRollover(graphics, button);
                this.paint(graphics, jc);
                return;
            }
            if (!model.isArmed() && !model.isPressed()) {
                this.paintButtonNormal(graphics, button);
                this.paint(graphics, jc);
                return;
            }
        }
        if (!jc.isEnabled()) {
            this.paintDiabledButton(graphics, jc);
        }
        super.update(graphics, jc);
    }

    protected void paintDiabledButton(Graphics g, JComponent jc) {
    }

    @Override
    protected void paintIcon(Graphics graphics, JComponent jComponent, Rectangle iconRect) {
        if (jComponent.getParent() instanceof ArmorTitleBarPane) {
            iconRect.setLocation(0, (int)iconRect.getY());
        }
        super.paintIcon(graphics, jComponent, iconRect);
    }

    @Override
    protected void paintFocus(Graphics graphics, AbstractButton button, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (null == button.getText() || "".equals(button.getText())) {
            return;
        }
        if (IsmPlafUtils.isButtonOnToolBar(button)) {
            return;
        }
        Rectangle buttonRect = button.getBounds();
        Rectangle focusRect = new Rectangle();
        focusRect.width = buttonRect.width - 6;
        focusRect.height = buttonRect.height - 6;
        focusRect.setLocation(3, 3);
        graphics.setColor(UIManager.getColor("IsmTheme.selectionBGGradientBG"));
        BasicGraphicsUtils.drawDashedRect(graphics, (int)focusRect.getX(), (int)focusRect.getY(), focusRect.width, focusRect.height);
    }

    @Override
    protected void paintButtonPressed(Graphics graphics, AbstractButton button) {
        this.setTextShiftOffset();
        if (button.getParent() instanceof ArmorTitleBarPane || button.getParent() instanceof JScrollPane) {
            return;
        }
        if (IsmPlafUtils.isButtonOnToolBar(button)) {
            this.drawButtonNormalContentArea(graphics, button, null, "IsmToolBarButton.normalFillBackground");
            return;
        }
        this.drawButtonContentArea(graphics, button, "IsmButton.pressHighlight", "IsmButton.gradientPress");
    }

    protected void paintButtonRollover(Graphics graphics, AbstractButton button) {
        if (IsmPlafUtils.isButtonOnToolBar(button)) {
            this.drawButtonNormalContentArea(graphics, button, null, "IsmToolBarButton.normalFillBackground");
            return;
        }
        this.drawButtonContentArea(graphics, button, "IsmButton.rolloverHighlight", "IsmButton.gradientRollover");
    }

    protected void paintButtonNormal(Graphics graphics, AbstractButton button) {
        if (IsmPlafUtils.isButtonOnToolBar(button)) {
            return;
        }
        if (!button.hasFocus()) {
            this.drawButtonNormalContentArea(graphics, button, "IsmButton.normalHighlight", "IsmButton.normalFillBackground");
        } else {
            this.drawButtonContentArea(graphics, button, "IsmButton.normalHighlight", "IsmButton.gradientRollover");
        }
    }

    protected void drawButtonNormalContentArea(Graphics graphics, AbstractButton button, String hightlightKey, String normalKey) {
        if (null != hightlightKey) {
            graphics.setColor(UIManager.getColor(hightlightKey));
            graphics.fillRect(0, 1, button.getWidth() - 1, 2);
            graphics.setColor(UIManager.getColor(normalKey));
            graphics.fillRect(0, 3, button.getWidth() - 1, button.getHeight() - 4);
        } else {
            graphics.setColor(UIManager.getColor(normalKey));
            graphics.fillRect(0, 1, button.getWidth() - 1, button.getHeight() - 1);
        }
    }

    protected void drawButtonContentArea(Graphics graphics, AbstractButton btn, String highlightKey, String grientKey) {
        graphics.setColor(UIManager.getColor(highlightKey));
        graphics.fillRect(0, 1, btn.getWidth() - 1, 2);
        IsmPlafUtils.drawGradient((Component)btn, graphics, grientKey, new Rectangle(0, 3, btn.getWidth(), btn.getHeight() - 4), true);
    }
}

