/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.armor;

import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalSliderUI;

public class ArmorSliderUI
extends MetalSliderUI {
    public static ComponentUI createUI(JComponent c) {
        return new ArmorSliderUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        jComponent.putClientProperty("JSlider.isFilled", true);
        super.installUI(jComponent);
    }

    @Override
    protected void installDefaults(JSlider slider) {
        super.installDefaults(slider);
        LookAndFeel.installProperty(slider, "opaque", Boolean.FALSE);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        LookAndFeel.installProperty(this.slider, "opaque", Boolean.TRUE);
        jComponent.putClientProperty("JSlider.isFilled", false);
        super.uninstallUI(jComponent);
    }

    @Override
    protected int getTrackWidth() {
        double kIdealTrackWidth = 8.0;
        double kIdealThumbHeight = 15.0;
        double kWidthScalar = 0.5333333333333333;
        if (this.slider.getOrientation() == 0) {
            return (int)(0.5333333333333333 * (double)this.thumbRect.height);
        }
        return (int)(0.5333333333333333 * (double)this.thumbRect.width);
    }

    @Override
    public void paintTrack(Graphics graphics) {
        boolean leftToRight = IsmPlafUtils.isLeftToRight(this.slider);
        graphics.translate((int)this.trackRect.getX(), (int)this.trackRect.getY());
        int trackLeft = 0;
        int trackTop = 0;
        int trackRight = 0;
        int trackBottom = 0;
        if (this.slider.getOrientation() == 0) {
            trackBottom = this.trackRect.height - this.getThumbOverhang();
            trackTop = trackBottom - this.getTrackWidth();
            trackRight = this.trackRect.width - 1;
        } else {
            if (leftToRight) {
                trackLeft = this.trackRect.width - this.getThumbOverhang() - this.getTrackWidth();
                trackRight = this.trackRect.width - this.getThumbOverhang() + 1;
            } else {
                trackLeft = this.getThumbOverhang();
                trackRight = this.getThumbOverhang() + this.getTrackWidth() - 1;
            }
            trackBottom = this.trackRect.height - 1;
        }
        Color innerColor = UIManager.getColor("Slider.trackInnerUnFillColor");
        graphics.setColor(innerColor);
        graphics.fillRect(trackLeft, trackTop, trackRight - trackLeft - 1, trackBottom - trackTop);
        if (this.slider.isEnabled()) {
            Color borColor = UIManager.getColor("Slider.trackBorderColor");
            IsmPlafUtils.drawBorderStyle(graphics, borColor, borColor, new Rectangle(trackLeft, trackTop, trackRight - trackLeft - 1, trackBottom - trackTop), true);
        } else {
            Color borColor = UIManager.getColor("Slider.trackDisableBorderColor");
            IsmPlafUtils.drawBorderStyle(graphics, borColor, borColor, new Rectangle(trackLeft, trackTop, trackRight - trackLeft - 1, trackBottom - trackTop), true);
        }
        if (this.filledSlider) {
            this.fillSlider(graphics, trackLeft, trackTop, trackRight, trackBottom);
        }
        graphics.translate(-((int)this.trackRect.getX()), -((int)this.trackRect.getY()));
    }

    private void fillSlider(Graphics graphics, int trackLeft, int trackTop, int trackRight, int trackBottom) {
        int middleOfThumb = 0;
        int fillTop = 0;
        int fillLeft = 0;
        int fillBottom = 0;
        int fillRight = 0;
        if (this.slider.getOrientation() == 0) {
            middleOfThumb = (int)this.thumbRect.getX() + this.thumbRect.width / 2;
            middleOfThumb -= (int)this.trackRect.getX();
            fillTop = trackTop + 1;
            fillBottom = trackBottom - 3;
            if (!this.drawInverted()) {
                fillLeft = trackLeft + 1;
                fillRight = middleOfThumb;
            } else {
                fillLeft = middleOfThumb;
                fillRight = trackRight - 1;
            }
        } else {
            middleOfThumb = (int)this.thumbRect.getY() + this.thumbRect.height / 2;
            middleOfThumb -= (int)this.trackRect.getY();
            fillLeft = trackLeft + 1;
            fillRight = trackRight - 4;
            if (!this.drawInverted()) {
                fillTop = middleOfThumb;
                fillBottom = trackBottom - 3;
            } else {
                fillTop = !this.slider.isEnabled() ? trackTop : trackTop + 1;
                fillBottom = middleOfThumb;
            }
        }
        Color fillColor = null;
        fillColor = UIManager.getColor("JSlider.trackInnerFillColor");
        graphics.setColor(fillColor);
        graphics.fillRect(fillLeft + 2, fillTop + 2, fillRight - fillLeft - 2, fillBottom - fillTop - 2);
        IsmPlafUtils.drawBorderStyle(graphics, fillColor, fillColor, new Rectangle(fillLeft + 1, fillTop + 1, fillRight - fillLeft, fillBottom - fillTop), true);
    }
}

